/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.telnet.connector;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.NullSettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;
import org.eclipse.tm.terminal.connector.telnet.connector.ITelnetSettings;
import org.eclipse.tm.terminal.connector.telnet.connector.TelnetConnectWorker;
import org.eclipse.tm.terminal.connector.telnet.connector.TelnetConnection;
import org.eclipse.tm.terminal.connector.telnet.connector.TelnetSettings;

public class TelnetConnector
extends TerminalConnectorImpl {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private Socket fSocket;
    private TelnetConnection fTelnetConnection;
    private final TelnetSettings fSettings;
    private int fWidth = -1;
    private int fHeight = -1;

    public TelnetConnector() {
        this(new TelnetSettings());
    }

    public TelnetConnector(TelnetSettings settings) {
        this.fSettings = settings;
    }

    public void connect(ITerminalControl control) {
        super.connect(control);
        this.fWidth = -1;
        this.fHeight = -1;
        control.setVT100LineWrapping(true);
        TelnetConnectWorker worker = new TelnetConnectWorker(this, control);
        worker.start();
    }

    public void doDisconnect() {
        if (this.getSocket() != null) {
            try {
                this.getSocket().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        if (this.getTerminalToRemoteStream() != null) {
            try {
                this.getTerminalToRemoteStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        this.cleanSocket();
    }

    public boolean isLocalEcho() {
        if (this.fTelnetConnection == null) {
            return false;
        }
        return this.fTelnetConnection.localEcho();
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fTelnetConnection != null && (newWidth != this.fWidth || newHeight != this.fHeight)) {
            this.fTelnetConnection.setTerminalSize(newWidth, newHeight);
            this.fWidth = newWidth;
            this.fHeight = newHeight;
        }
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.fOutputStream;
    }

    private void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    private void setOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            this.fOutputStream = null;
            return;
        }
        this.fOutputStream = new FilterOutputStream(outputStream){
            final byte CR = 13;
            final byte LF = 10;
            final byte[] CRLF;
            int last;
            {
                this.CR = (byte)13;
                this.LF = (byte)10;
                this.CRLF = new byte[]{13, 10};
                this.last = -1;
            }

            @Override
            public void write(int b) throws IOException {
                if (b == 10 && this.last == 13) {
                    this.last = b;
                    return;
                }
                this.last = b;
                if (b == 13) {
                    this.out.write(this.CRLF);
                } else {
                    this.out.write(b);
                }
            }
        };
    }

    Socket getSocket() {
        return this.fSocket;
    }

    void cleanSocket() {
        this.fSocket = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    void setSocket(Socket socket) throws IOException {
        if (socket == null) {
            this.cleanSocket();
        } else {
            this.fSocket = socket;
            this.setInputStream(socket.getInputStream());
            this.setOutputStream(socket.getOutputStream());
        }
    }

    public void setTelnetConnection(TelnetConnection connection) {
        this.fTelnetConnection = connection;
    }

    public void displayTextInTerminal(String text) {
        this.fControl.displayTextInTerminal(text);
    }

    public OutputStream getRemoteToTerminalOutputStream() {
        return this.fControl.getRemoteToTerminalOutputStream();
    }

    public void setState(TerminalState state) {
        this.fControl.setState(state);
    }

    public ITelnetSettings getTelnetSettings() {
        return this.fSettings;
    }

    public void setDefaultSettings() {
        this.fSettings.load((ISettingsStore)new NullSettingsStore());
    }

    public String getSettingsSummary() {
        return this.fSettings.getSummary();
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }
}

