/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.grammar.AttributedScopeStack;
import org.eclipse.tm4e.core.internal.grammar.Grammar;
import org.eclipse.tm4e.core.internal.grammar.Injection;
import org.eclipse.tm4e.core.internal.grammar.LineTokens;
import org.eclipse.tm4e.core.internal.grammar.StateStack;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;
import org.eclipse.tm4e.core.internal.oniguruma.OnigScannerMatch;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.eclipse.tm4e.core.internal.rule.BeginEndRule;
import org.eclipse.tm4e.core.internal.rule.BeginWhileRule;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.CompiledRule;
import org.eclipse.tm4e.core.internal.rule.MatchRule;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.rule.RuleId;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

final class LineTokenizer {
    private static final System.Logger LOGGER = System.getLogger(LineTokenizer.class.getName());
    private final Grammar grammar;
    private final OnigString lineText;
    private boolean isFirstLine;
    private int linePos;
    private StateStack stack;
    private final LineTokens lineTokens;
    private int anchorPosition = -1;
    private boolean stop;
    private final int lineLength;

    private LineTokenizer(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StateStack stack, LineTokens lineTokens) {
        this.grammar = grammar;
        this.lineText = lineText;
        this.isFirstLine = isFirstLine;
        this.linePos = linePos;
        this.stack = stack;
        this.lineTokens = lineTokens;
        this.lineLength = lineText.content.length();
    }

    private TokenizeStringResult scan(boolean checkWhileConditions, long timeLimit) {
        this.stop = false;
        if (checkWhileConditions) {
            WhileCheckResult whileCheckResult = this.checkWhileConditions(this.grammar, this.lineText, this.isFirstLine, this.linePos, this.stack, this.lineTokens);
            this.stack = whileCheckResult.stack;
            this.linePos = whileCheckResult.linePos;
            this.isFirstLine = whileCheckResult.isFirstLine;
            this.anchorPosition = whileCheckResult.anchorPosition;
        }
        long startTime = System.currentTimeMillis();
        while (!this.stop) {
            long elapsedTime;
            if (timeLimit > 0L && (elapsedTime = System.currentTimeMillis() - startTime) > timeLimit) {
                return new TokenizeStringResult(this.stack, true);
            }
            this.scanNext();
        }
        return new TokenizeStringResult(this.stack, false);
    }

    private void scanNext() {
        boolean hasAdvanced;
        LOGGER.log(System.Logger.Level.TRACE, () -> "@@scanNext: |" + this.lineText.content.replace("\n", "\\n").substring(this.linePos) + "|");
        MatchResult r = this.matchRuleOrInjections(this.grammar, this.lineText, this.isFirstLine, this.linePos, this.stack, this.anchorPosition);
        if (r == null) {
            LOGGER.log(System.Logger.Level.TRACE, " no more matches.");
            this.lineTokens.produce(this.stack, this.lineLength);
            this.stop = true;
            return;
        }
        OnigCaptureIndex[] captureIndices = r.captureIndices;
        RuleId matchedRuleId = r.matchedRuleId;
        boolean bl = hasAdvanced = captureIndices.length > 0 && captureIndices[0].end > this.linePos;
        if (matchedRuleId.equals(RuleId.END_RULE)) {
            BeginEndRule poppedRule = (BeginEndRule)this.stack.getRule(this.grammar);
            this.lineTokens.produce(this.stack, captureIndices[0].start);
            this.stack = this.stack.withContentNameScopesList(this.stack.nameScopesList);
            this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, poppedRule.endCaptures, captureIndices);
            this.lineTokens.produce(this.stack, captureIndices[0].end);
            StateStack popped = this.stack;
            this.stack = NullSafetyHelper.castNonNull(this.stack.pop());
            this.anchorPosition = popped.getAnchorPos();
            if (!hasAdvanced && popped.getEnterPos() == this.linePos) {
                LOGGER.log(System.Logger.Level.INFO, "[1] - Grammar is in an endless loop - Grammar pushed & popped a rule without advancing");
                this.stack = popped;
                this.lineTokens.produce(this.stack, this.lineLength);
                this.stop = true;
                return;
            }
        } else if (captureIndices.length > 0) {
            Rule rule = this.grammar.getRule(matchedRuleId);
            this.lineTokens.produce(this.stack, captureIndices[0].start);
            StateStack beforePush = this.stack;
            String scopeName = rule.getName(this.lineText.content, captureIndices);
            AttributedScopeStack nameScopesList = NullSafetyHelper.castNonNull(this.stack.contentNameScopesList).pushAttributed(scopeName, this.grammar);
            this.stack = this.stack.push(matchedRuleId, this.linePos, this.anchorPosition, captureIndices[0].end == this.lineLength, null, nameScopesList, nameScopesList);
            if (rule instanceof BeginEndRule) {
                BeginEndRule pushedRule = (BeginEndRule)rule;
                this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, pushedRule.beginCaptures, captureIndices);
                this.lineTokens.produce(this.stack, captureIndices[0].end);
                this.anchorPosition = captureIndices[0].end;
                String contentName = pushedRule.getContentName(this.lineText.content, captureIndices);
                AttributedScopeStack contentNameScopesList = nameScopesList.pushAttributed(contentName, this.grammar);
                this.stack = this.stack.withContentNameScopesList(contentNameScopesList);
                if (pushedRule.endHasBackReferences) {
                    this.stack = this.stack.withEndRule(pushedRule.getEndWithResolvedBackReferences(this.lineText.content, captureIndices));
                }
                if (!hasAdvanced && beforePush.hasSameRuleAs(this.stack)) {
                    LOGGER.log(System.Logger.Level.INFO, "[2] - Grammar is in an endless loop - Grammar pushed the same rule without advancing");
                    this.stack = NullSafetyHelper.castNonNull(this.stack.pop());
                    this.lineTokens.produce(this.stack, this.lineLength);
                    this.stop = true;
                    return;
                }
            } else if (rule instanceof BeginWhileRule) {
                BeginWhileRule pushedRule = (BeginWhileRule)rule;
                this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, pushedRule.beginCaptures, captureIndices);
                this.lineTokens.produce(this.stack, captureIndices[0].end);
                this.anchorPosition = captureIndices[0].end;
                String contentName = pushedRule.getContentName(this.lineText.content, captureIndices);
                AttributedScopeStack contentNameScopesList = nameScopesList.pushAttributed(contentName, this.grammar);
                this.stack = this.stack.withContentNameScopesList(contentNameScopesList);
                if (pushedRule.whileHasBackReferences) {
                    this.stack = this.stack.withEndRule(pushedRule.getWhileWithResolvedBackReferences(this.lineText.content, captureIndices));
                }
                if (!hasAdvanced && beforePush.hasSameRuleAs(this.stack)) {
                    LOGGER.log(System.Logger.Level.INFO, "[3] - Grammar is in an endless loop - Grammar pushed the same rule without advancing");
                    this.stack = NullSafetyHelper.castNonNull(this.stack.pop());
                    this.lineTokens.produce(this.stack, this.lineLength);
                    this.stop = true;
                    return;
                }
            } else {
                MatchRule matchingRule = (MatchRule)rule;
                this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, matchingRule.captures, captureIndices);
                this.lineTokens.produce(this.stack, captureIndices[0].end);
                this.stack = NullSafetyHelper.castNonNull(this.stack.pop());
                if (!hasAdvanced) {
                    LOGGER.log(System.Logger.Level.INFO, "[4] - Grammar is in an endless loop - Grammar is not advancing, nor is it pushing/popping");
                    this.stack = this.stack.safePop();
                    this.lineTokens.produce(this.stack, this.lineLength);
                    this.stop = true;
                    return;
                }
            }
        }
        if (captureIndices.length > 0 && captureIndices[0].end > this.linePos) {
            this.linePos = captureIndices[0].end;
            this.isFirstLine = false;
        }
    }

    private @Nullable MatchResult matchRule(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StateStack stack, int anchorPosition) {
        Rule rule = stack.getRule(grammar);
        CompiledRule ruleScanner = rule.compileAG(grammar, stack.endRule, isFirstLine, linePos == anchorPosition);
        OnigScannerMatch r = ruleScanner.scanner.findNextMatch(lineText, linePos);
        if (r != null) {
            return new MatchResult(ruleScanner.rules[r.index], r.getCaptureIndices());
        }
        return null;
    }

    private @Nullable MatchResult matchRuleOrInjections(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StateStack stack, int anchorPosition) {
        MatchResult matchResult = this.matchRule(grammar, lineText, isFirstLine, linePos, stack, anchorPosition);
        List<Injection> injections = grammar.getInjections();
        if (injections.isEmpty()) {
            return matchResult;
        }
        MatchInjectionsResult injectionResult = this.matchInjections(injections, grammar, lineText, isFirstLine, linePos, stack, anchorPosition);
        if (injectionResult == null) {
            return matchResult;
        }
        if (matchResult == null) {
            return injectionResult;
        }
        int injectionResultScore = injectionResult.captureIndices[0].start;
        int matchResultScore = matchResult.captureIndices[0].start;
        if (injectionResultScore < matchResultScore || injectionResult.isPriorityMatch && injectionResultScore == matchResultScore) {
            return injectionResult;
        }
        return matchResult;
    }

    private @Nullable MatchInjectionsResult matchInjections(List<Injection> injections, Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StateStack stack, int anchorPosition) {
        int bestMatchRating = Integer.MAX_VALUE;
        OnigCaptureIndex[] bestMatchCaptureIndices = null;
        RuleId bestMatchRuleId = RuleId.END_RULE;
        int bestMatchResultPriority = 0;
        List<String> scopes = stack.contentNameScopesList != null ? stack.contentNameScopesList.getScopeNames() : Collections.emptyList();
        for (Injection injection : injections) {
            int matchRating;
            if (!injection.matches(scopes)) continue;
            Rule rule = grammar.getRule(injection.ruleId);
            CompiledRule ruleScanner = rule.compileAG(grammar, null, isFirstLine, linePos == anchorPosition);
            OnigScannerMatch matchResult = ruleScanner.scanner.findNextMatch(lineText, linePos);
            if (matchResult == null) continue;
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "  matched injection: " + injection.debugSelector);
                LOGGER.log(System.Logger.Level.TRACE, LineTokenizer.debugCompiledRuleToString(ruleScanner));
            }
            if ((matchRating = matchResult.getCaptureIndices()[0].start) > bestMatchRating) continue;
            bestMatchRating = matchRating;
            bestMatchCaptureIndices = matchResult.getCaptureIndices();
            bestMatchRuleId = ruleScanner.rules[matchResult.index];
            bestMatchResultPriority = injection.priority;
            if (bestMatchRating == linePos) break;
        }
        if (bestMatchCaptureIndices != null) {
            return new MatchInjectionsResult(bestMatchRuleId, bestMatchCaptureIndices, bestMatchResultPriority == -1);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void handleCaptures(Grammar grammar, OnigString lineText, boolean isFirstLine, StateStack stack, LineTokens lineTokens, List<@Nullable CaptureRule> captures, OnigCaptureIndex[] captureIndices) {
        if (captures.isEmpty()) {
            return;
        }
        lineTextContent = lineText.content;
        len = Math.min(captures.size(), captureIndices.length);
        localStack = new ArrayDeque<LocalStackElement>();
        maxEnd = captureIndices[0].end;
        i = 0;
        while (i < len) {
            block9: {
                captureRule = captures.get(i);
                if (captureRule == null || (captureIndex = captureIndices[i]).getLength() == 0) break block9;
                if (captureIndex.start <= maxEnd) ** GOTO lbl15
                break;
lbl-1000:
                // 1 sources

                {
                    lastElem = (LocalStackElement)localStack.removeLast();
                    lineTokens.produceFromScopes(lastElem.scopes, lastElem.endPos);
lbl15:
                    // 2 sources

                    ** while (!localStack.isEmpty() && ((LocalStackElement)localStack.getLast()).endPos <= captureIndex.start)
                }
lbl16:
                // 1 sources

                if (!localStack.isEmpty()) {
                    lineTokens.produceFromScopes(((LocalStackElement)localStack.getLast()).scopes, captureIndex.start);
                } else {
                    lineTokens.produce(stack, captureIndex.start);
                }
                retokenizeCapturedWithRuleId = captureRule.retokenizeCapturedWithRuleId;
                if (retokenizeCapturedWithRuleId.notEquals(RuleId.NO_RULE)) {
                    scopeName = captureRule.getName(lineTextContent, captureIndices);
                    nameScopesList = NullSafetyHelper.castNonNull(stack.contentNameScopesList).pushAttributed(scopeName, grammar);
                    contentName = captureRule.getContentName(lineTextContent, captureIndices);
                    contentNameScopesList = nameScopesList.pushAttributed(contentName, grammar);
                    stackClone = stack.push(retokenizeCapturedWithRuleId, captureIndex.start, -1, false, null, nameScopesList, contentNameScopesList);
                    onigSubStr = OnigString.of(lineTextContent.substring(0, captureIndex.end));
                    LineTokenizer.tokenizeString(grammar, onigSubStr, isFirstLine != false && captureIndex.start == 0, captureIndex.start, stackClone, lineTokens, false, Duration.ZERO);
                } else {
                    captureRuleScopeName = captureRule.getName(lineTextContent, captureIndices);
                    if (captureRuleScopeName != null) {
                        base = localStack.isEmpty() != false ? stack.contentNameScopesList : ((LocalStackElement)localStack.getLast()).scopes;
                        captureRuleScopesList = NullSafetyHelper.castNonNull(base).pushAttributed(captureRuleScopeName, grammar);
                        localStack.add(new LocalStackElement(captureRuleScopesList, captureIndex.end));
                    }
                }
            }
            ++i;
        }
        while (!localStack.isEmpty()) {
            lastElem = (LocalStackElement)localStack.removeLast();
            lineTokens.produceFromScopes(lastElem.scopes, lastElem.endPos);
        }
    }

    private WhileCheckResult checkWhileConditions(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StateStack stack, LineTokens lineTokens) {
        int anchorPosition = stack.beginRuleCapturedEOL ? 0 : -1;
        final class WhileStack {
            final StateStack stack;
            final BeginWhileRule rule;

            WhileStack(StateStack stack, BeginWhileRule rule) {
                this.stack = stack;
                this.rule = rule;
            }
        }
        ArrayList<WhileStack> whileRules = new ArrayList<WhileStack>();
        StateStack node = stack;
        while (node != null) {
            Rule nodeRule = node.getRule(grammar);
            if (nodeRule instanceof BeginWhileRule) {
                BeginWhileRule beginWhileRule = (BeginWhileRule)nodeRule;
                whileRules.add(new WhileStack(node, beginWhileRule));
            }
            node = node.pop();
        }
        int i = whileRules.size() - 1;
        while (i >= 0) {
            block6: {
                WhileStack whileRule;
                block5: {
                    whileRule = (WhileStack)whileRules.get(i);
                    CompiledRule ruleScanner = whileRule.rule.compileWhileAG(whileRule.stack.endRule, isFirstLine, anchorPosition == linePos);
                    OnigScannerMatch r = ruleScanner.scanner.findNextMatch(lineText, linePos);
                    if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                        LOGGER.log(System.Logger.Level.TRACE, "  scanning for while rule");
                        LOGGER.log(System.Logger.Level.TRACE, LineTokenizer.debugCompiledRuleToString(ruleScanner));
                    }
                    if (r == null) break block5;
                    RuleId matchedRuleId = ruleScanner.rules[r.index];
                    if (RuleId.WHILE_RULE.notEquals(matchedRuleId)) {
                        stack = NullSafetyHelper.castNonNull(whileRule.stack.pop());
                        break;
                    }
                    if (r.getCaptureIndices().length <= 0) break block6;
                    lineTokens.produce(whileRule.stack, r.getCaptureIndices()[0].start);
                    this.handleCaptures(grammar, lineText, isFirstLine, whileRule.stack, lineTokens, whileRule.rule.whileCaptures, r.getCaptureIndices());
                    lineTokens.produce(whileRule.stack, r.getCaptureIndices()[0].end);
                    anchorPosition = r.getCaptureIndices()[0].end;
                    if (r.getCaptureIndices()[0].end <= linePos) break block6;
                    linePos = r.getCaptureIndices()[0].end;
                    isFirstLine = false;
                    break block6;
                }
                stack = NullSafetyHelper.castNonNull(whileRule.stack.pop());
                break;
            }
            --i;
        }
        return new WhileCheckResult(stack, linePos, anchorPosition, isFirstLine);
    }

    static TokenizeStringResult tokenizeString(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StateStack stack, LineTokens lineTokens, boolean checkWhileConditions, Duration timeLimit) {
        return new LineTokenizer(grammar, lineText, isFirstLine, linePos, stack, lineTokens).scan(checkWhileConditions, timeLimit.toMillis());
    }

    static String debugCompiledRuleToString(CompiledRule ruleScanner) {
        ArrayList<CallSite> r = new ArrayList<CallSite>(ruleScanner.rules.length);
        int i = 0;
        int l = ruleScanner.rules.length;
        while (i < l) {
            r.add((CallSite)((Object)("   - " + String.valueOf(ruleScanner.rules[i]) + ": " + ruleScanner.debugRegExps.get(i))));
            ++i;
        }
        return String.join((CharSequence)System.lineSeparator(), r);
    }

    private record LocalStackElement(AttributedScopeStack scopes, int endPos) {
    }

    private static final class MatchInjectionsResult
    extends MatchResult {
        final boolean isPriorityMatch;

        MatchInjectionsResult(RuleId matchedRuleId, OnigCaptureIndex[] captureIndices, boolean isPriorityMatch) {
            super(matchedRuleId, captureIndices);
            this.isPriorityMatch = isPriorityMatch;
        }
    }

    private static class MatchResult {
        final OnigCaptureIndex[] captureIndices;
        final RuleId matchedRuleId;

        MatchResult(RuleId matchedRuleId, OnigCaptureIndex[] captureIndices) {
            this.matchedRuleId = matchedRuleId;
            this.captureIndices = captureIndices;
        }
    }

    static final class TokenizeStringResult {
        final StateStack stack;
        final boolean stoppedEarly;

        private TokenizeStringResult(StateStack stack, boolean stoppedEarly) {
            this.stack = stack;
            this.stoppedEarly = stoppedEarly;
        }
    }

    private record WhileCheckResult(StateStack stack, int linePos, int anchorPosition, boolean isFirstLine) {
    }
}

