/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackagesProvider;

class PackagesViewFlatContentProvider
extends LogicalPackagesProvider
implements IStructuredContentProvider {
    PackagesViewFlatContentProvider(StructuredViewer viewer) {
        super(viewer);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IJavaScriptElement) {
            IJavaScriptElement element = (IJavaScriptElement)parentElement;
            int type = element.getElementType();
            try {
                switch (type) {
                    case 2: {
                        IJavaScriptProject project = (IJavaScriptProject)element;
                        Object[] children = this.getPackageFragments(project.getPackageFragments());
                        if (this.isInCompoundState()) {
                            this.fMapToLogicalPackage.clear();
                            this.fMapToPackageFragments.clear();
                            return this.combineSamePackagesIntoLogialPackages((IPackageFragment[])children);
                        }
                        return children;
                    }
                    case 3: {
                        this.fMapToLogicalPackage.clear();
                        this.fMapToPackageFragments.clear();
                        IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                        return root.getChildren();
                    }
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return NO_CHILDREN;
            }
        }
        return NO_CHILDREN;
    }

    private IPackageFragment[] getPackageFragments(IPackageFragment[] iPackageFragments) {
        ArrayList<IPackageFragment> list = new ArrayList<IPackageFragment>();
        int i = 0;
        while (i < iPackageFragments.length) {
            IPackageFragmentRoot root;
            IPackageFragment fragment = iPackageFragments[i];
            IJavaScriptElement el = fragment.getParent();
            if (!(el instanceof IPackageFragmentRoot && (root = (IPackageFragmentRoot)el).isArchive() && root.isExternal())) {
                list.add(fragment);
            }
            ++i;
        }
        return list.toArray(new IPackageFragment[list.size()]);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    @Override
    protected void processDelta(IJavaScriptElementDelta delta) throws JavaScriptModelException {
        Object input;
        int kind = delta.getKind();
        IJavaScriptElement element = delta.getElement();
        if (this.isClassPathChange(delta) && (input = this.fViewer.getInput()) != null) {
            if (this.fInputIsProject && input.equals(element.getJavaScriptProject())) {
                this.postRefresh(input);
                return;
            }
            if (!this.fInputIsProject && input.equals(element)) {
                if (element.exists()) {
                    this.postRefresh(input);
                } else {
                    this.postRemove(input);
                }
                return;
            }
        }
        if (kind == 2 && (input = this.fViewer.getInput()) != null && input.equals(element)) {
            this.postRemove(input);
            return;
        }
        if (element instanceof IPackageFragment) {
            IPackageFragment frag = (IPackageFragment)element;
            if (kind == 2) {
                this.removeElement(frag);
            } else if (kind == 1) {
                this.addElement(frag);
            } else if (kind == 4) {
                Object toBeRefreshed = element;
                IPackageFragment pkgFragment = (IPackageFragment)element;
                LogicalPackage logicalPkg = this.findLogicalPackage(pkgFragment);
                toBeRefreshed = logicalPkg != null ? this.findElementToRefresh(logicalPkg) : this.findElementToRefresh(pkgFragment);
                this.postRefresh(toBeRefreshed);
            }
            return;
        }
        this.processAffectedChildren(delta);
    }

    private Object findElementToRefresh(IPackageFragment fragment) {
        if (this.fViewer.testFindItem((Object)fragment) == null) {
            if (this.fInputIsProject) {
                return fragment.getJavaScriptProject();
            }
            return fragment.getParent();
        }
        return fragment;
    }

    private Object findElementToRefresh(LogicalPackage logicalPackage) {
        if (this.fViewer.testFindItem((Object)logicalPackage) == null) {
            IPackageFragment fragment = logicalPackage.getFragments()[0];
            return fragment.getJavaScriptProject();
        }
        return logicalPackage;
    }

    private void processAffectedChildren(IJavaScriptElementDelta delta) throws JavaScriptModelException {
        IJavaScriptElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            IJavaScriptElementDelta elementDelta = children[i];
            this.processDelta(elementDelta);
            ++i;
        }
    }

    private void postAdd(final Object child) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = PackagesViewFlatContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TableViewer)PackagesViewFlatContentProvider.this.fViewer).add(child);
                }
            }
        });
    }

    private void postRemove(final Object object) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = PackagesViewFlatContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TableViewer)PackagesViewFlatContentProvider.this.fViewer).remove(object);
                }
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay != null && currentDisplay.equals(ctrl.getDisplay())) {
                ctrl.getDisplay().syncExec(r);
            } else {
                ctrl.getDisplay().asyncExec(r);
            }
        }
    }

    private void removeElement(IPackageFragment frag) {
        String key = this.getKey(frag);
        LogicalPackage lp = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(key));
        if (lp != null) {
            lp.remove(frag);
            if (lp.getFragments().length == 1) {
                IPackageFragment fragment = lp.getFragments()[0];
                this.fMapToLogicalPackage.remove(key);
                this.fMapToPackageFragments.put(key, fragment);
                this.postRemove((Object)lp);
                this.postAdd(fragment);
            }
            return;
        }
        this.fMapToPackageFragments.remove(key);
        this.postRemove(frag);
    }

    private void postRefresh(final Object element) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = PackagesViewFlatContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    PackagesViewFlatContentProvider.this.fViewer.refresh(element);
                }
            }
        });
    }

    private void addElement(IPackageFragment frag) {
        String key = this.getKey(frag);
        LogicalPackage lp = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(key));
        if (lp != null && lp.belongs(frag)) {
            lp.add(frag);
            return;
        }
        IPackageFragment fragment = (IPackageFragment)this.fMapToPackageFragments.get(key);
        if (fragment != null) {
            if (!fragment.equals(frag)) {
                lp = new LogicalPackage(fragment);
                lp.add(frag);
                this.fMapToLogicalPackage.put(key, lp);
                this.postRemove(fragment);
                this.postAdd((Object)lp);
                return;
            }
        } else {
            this.fMapToPackageFragments.put(key, frag);
            this.postAdd(frag);
        }
    }
}

