/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.handler;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;
import org.eclipse.tracecompass.tmf.ui.symbols.SymbolProviderConfigDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ConfigureSymbolHandler
extends AbstractHandler {
    private @Nullable ITmfTrace fTrace;

    public boolean isEnabled() {
        TmfCommonProjectElement selected;
        ITmfTrace trace;
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fTrace = null;
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfCommonProjectElement && (trace = (selected = (TmfCommonProjectElement)element).getTrace()) != null) {
            this.fTrace = trace;
        }
        return this.fTrace != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell shell = window.getShell();
        SymbolProviderConfigDialog dialog = new SymbolProviderConfigDialog(shell, this.getProviderPages());
        dialog.open();
        return null;
    }

    private ISymbolProviderPreferencePage[] getProviderPages() {
        ArrayList<ISymbolProviderPreferencePage> pages = new ArrayList<ISymbolProviderPreferencePage>();
        ITmfTrace trace = this.fTrace;
        if (trace != null) {
            for (ITmfTrace subTrace : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
                for (ISymbolProvider provider : SymbolProviderManager.getInstance().getSymbolProviders(subTrace)) {
                    org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider provider2;
                    ISymbolProviderPreferencePage page;
                    if (!(provider instanceof org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider) || (page = (provider2 = (org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider)provider).createPreferencePage()) == null) continue;
                    pages.add(page);
                }
            }
        }
        return pages.toArray(new ISymbolProviderPreferencePage[pages.size()]);
    }
}

