/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.core;

import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.AsyncMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.preferences.SDViewPref;

public class EllipsisMessage
extends AsyncMessage {
    @Override
    public int getX() {
        if (this.getStartLifeline() == null) {
            return super.getX() + super.getWidth() - 16;
        }
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY() + 3;
    }

    @Override
    public int getWidth() {
        return 16;
    }

    @Override
    protected void drawMessage(IGC context) {
        int x = super.getX();
        int y = this.getY();
        int width = super.getWidth();
        int height = this.getHeight();
        if (this.getStartLifeline() == null && this.getEndLifeline() != null) {
            context.drawTextTruncatedCentred(this.getName(), x, y - Metrics.getMessageFontHeigth() - 20, width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            int currentStyle = context.getLineStyle();
            context.setLineStyle(context.getLineSolidStyle());
            context.drawRectangle(x + width - 5, y, x + width - 6, y + height);
            context.drawRectangle(x + width - 10, y, x + width - 11, y + height);
            context.drawRectangle(x + width - 15, y, x + width - 16, y + height);
            context.setLineStyle(currentStyle);
            IColor storedColor = context.getBackground();
            context.setBackground(context.getForeground());
            context.fillRectangle(x + width - 5, y, x + width - 6, y + height);
            context.fillRectangle(x + width - 10, y, x + width - 11, y + height);
            context.fillRectangle(x + width - 15, y, x + width - 16, y + height);
            context.setBackground(storedColor);
        } else if (this.getEndLifeline() == null && this.getStartLifeline() != null) {
            context.drawTextTruncatedCentred(this.getName(), x, y - Metrics.getMessageFontHeigth() - 20, width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            int currentStyle = context.getLineStyle();
            context.setLineStyle(context.getLineSolidStyle());
            context.drawRectangle(x + 5, y, 1, 1);
            context.drawRectangle(x + 10, y, 1, 1);
            context.drawRectangle(x + 15, y, 1, 1);
            context.setLineStyle(currentStyle);
            IColor storedColor = context.getBackground();
            context.setBackground(context.getForeground());
            context.fillRectangle(x + 5, y, 1, 1);
            context.fillRectangle(x + 10, y, 1, 1);
            context.fillRectangle(x + 15, y, 1, 1);
            context.setBackground(storedColor);
        } else {
            super.draw(context);
        }
    }

    @Override
    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        SDViewPref pref = SDViewPref.getInstance();
        if (this.isSelected()) {
            context.setForeground(pref.getBackGroundColorSelection());
            context.setLineWidth(5);
            this.drawMessage(context);
            context.setBackground(pref.getBackGroundColorSelection());
            context.setForeground(pref.getForeGroundColorSelection());
        } else {
            context.setBackground(pref.getBackGroundColor("PREF_ASYNC_MESS"));
            context.setForeground(pref.getForeGroundColor("PREF_ASYNC_MESS"));
        }
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(true);
        }
        context.setLineWidth(1);
        this.drawMessage(context);
        context.setLineWidth(1);
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(false);
        }
    }
}

