/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.matching;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;

@NonNullByDefault
public class TcpEventKey
implements IEventMatchingKey {
    private static final HashFunction HF = (HashFunction)NonNullUtils.checkNotNull((Object)Hashing.goodFastHash((int)32));
    private final long fSeq;
    private final long fAckseq;
    private final long fFlags;

    public TcpEventKey(long sequence, long ack, long flags) {
        this.fSeq = sequence;
        this.fAckseq = ack;
        this.fFlags = flags;
    }

    public int hashCode() {
        return HF.newHasher().putLong(this.fSeq).putLong(this.fAckseq).putLong(this.fFlags).hash().asInt();
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof TcpEventKey) {
            TcpEventKey key = (TcpEventKey)o;
            return key.fSeq == this.fSeq && key.fAckseq == this.fAckseq && key.fFlags == this.fFlags;
        }
        return false;
    }
}

