/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.atrace.trace;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.atrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.atrace.event.IAtraceConstants;
import org.eclipse.tracecompass.incubator.internal.atrace.event.SystraceProcessDumpEvent;
import org.eclipse.tracecompass.incubator.internal.atrace.event.SystraceProcessDumpEventField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.IGenericFtraceConstants;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.trace.GenericFtrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public class ATrace
extends GenericFtrace {
    private static final String ATRACE_TRACEEVENT_EVENT = "tracing_mark_write";
    private static final String TRACE_EVENT_PHASE_GROUP = "phase";
    private static final String TRACE_EVENT_CONTENT_GROUP = "content";
    private static final int MAX_LINES = 100;
    private static final int MAX_CONFIDENCE = 100;
    private static final TmfLongLocation NULL_LOCATION = new TmfLongLocation(-1L);
    private static final TmfContext INVALID_CONTEXT = new TmfContext((ITmfLocation)NULL_LOCATION, -1L);
    private long startingTimestamp;

    public IStatus validate(IProject project, String path) {
        File file = new File(path);
        if (!file.exists()) {
            return new Status(4, "org.eclipse.tracecompass.incubator.atrace.core", "File not found: " + path);
        }
        if (!file.isFile()) {
            return new Status(4, "org.eclipse.tracecompass.incubator.atrace.core", "Not a file. It's a directory: " + path);
        }
        int confidence = 0;
        try {
            if (!TmfTraceUtils.isText((File)file)) {
                return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.atrace.core");
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
            return new Status(4, "org.eclipse.tracecompass.incubator.atrace.core", "IOException validating file: " + path, (Throwable)e);
        }
        try {
            Throwable e = null;
            Object var6_9 = null;
            try (BufferedRandomAccessFile rafile = new BufferedRandomAccessFile(path, "r");){
                int lineCount = 0;
                int matches = 0;
                String line = rafile.readLine();
                int functionCallCount = 0;
                boolean isSystrace = false;
                while (line != null && lineCount++ < 100) {
                    if (line.contains("<title>Android System Trace</title>")) {
                        confidence = 100;
                        isSystrace = true;
                        ++matches;
                        break;
                    }
                    try {
                        GenericFtraceField field = this.parseLine(line);
                        if (field != null) {
                            ++matches;
                            if (field.getTid() != field.getPid()) {
                                ++functionCallCount;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        confidence = Integer.MIN_VALUE;
                    }
                    confidence = 100 * matches / lineCount;
                    line = rafile.readLine();
                }
                confidence = functionCallCount > 0 || isSystrace ? ++confidence : 0;
                if (matches == 0) {
                    return new Status(4, "org.eclipse.tracecompass.incubator.atrace.core", "Most assuredly NOT a atrace trace");
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
            return new Status(4, "org.eclipse.tracecompass.incubator.atrace.core", "IOException validating file: " + path, (Throwable)e);
        }
        return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.atrace.core");
    }

    public ITmfContext seekEvent(ITmfLocation location) {
        if (this.getFile() == null) {
            return INVALID_CONTEXT;
        }
        TmfContext context = new TmfContext((ITmfLocation)NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals((Object)location)) {
            return context;
        }
        RandomAccessFile fileInput = this.getFileInput();
        try {
            if (location == null) {
                fileInput.seek(0L);
                long lineStartOffset = fileInput.getFilePointer();
                String line = fileInput.readLine();
                Matcher processDumpMatcher = IAtraceConstants.PROCESS_DUMP_PATTERN.matcher(line);
                Matcher atraceMatcher = IGenericFtraceConstants.FTRACE_PATTERN.matcher(line);
                while (!atraceMatcher.matches() && !processDumpMatcher.matches()) {
                    lineStartOffset = fileInput.getFilePointer();
                    line = fileInput.readLine();
                    atraceMatcher = IGenericFtraceConstants.FTRACE_PATTERN.matcher(line);
                    processDumpMatcher = IAtraceConstants.PROCESS_DUMP_PATTERN.matcher(line);
                }
                if (processDumpMatcher.matches()) {
                    while (!atraceMatcher.matches()) {
                        line = fileInput.readLine();
                        atraceMatcher = IGenericFtraceConstants.FTRACE_PATTERN.matcher(line);
                    }
                    GenericFtraceField field = GenericFtraceField.parseLine((String)line);
                    if (field != null) {
                        this.startingTimestamp = field.getTs();
                    }
                }
                fileInput.seek(lineStartOffset);
            } else if (location.getLocationInfo() instanceof Long) {
                fileInput.seek((Long)location.getLocationInfo());
            }
            context.setLocation((ITmfLocation)new TmfLongLocation(fileInput.getFilePointer()));
            context.setRank(0L);
        }
        catch (IOException | NullPointerException e) {
            Activator.getInstance().logError("Error seeking event." + this.getPath(), (Throwable)e);
        }
        return context;
    }

    public ITmfEvent parseEvent(ITmfContext context) {
        ITmfEvent event = super.parseEvent(context);
        if (event != null) {
            return event;
        }
        ITmfLocation location = context.getLocation();
        if (location instanceof TmfLongLocation) {
            TmfLongLocation tmfLongLocation = (TmfLongLocation)location;
            Long locationInfo = tmfLongLocation.getLocationInfo();
            if (location.equals(NULL_LOCATION)) {
                locationInfo = 0L;
            }
            super.parseEvent(context);
            if (locationInfo != null) {
                RandomAccessFile fileInput = this.getFileInput();
                try {
                    String nextLine;
                    SystraceProcessDumpEventField field;
                    if (!locationInfo.equals(fileInput.getFilePointer())) {
                        fileInput.seek(locationInfo);
                    }
                    if ((field = SystraceProcessDumpEventField.parseLine(nextLine = fileInput.readLine())) != null) {
                        return new SystraceProcessDumpEvent((ITmfTrace)this, context.getRank(), TmfTimestamp.fromNanos((long)this.startingTimestamp), field);
                    }
                }
                catch (IOException e) {
                    Activator.getInstance().logError("Error parsing event", (Throwable)e);
                }
            }
        }
        return event;
    }

    protected @Nullable GenericFtraceField parseLine(String line) {
        String data;
        Matcher atraceMatcher;
        Matcher matcher;
        if (line == null || line.isEmpty()) {
            return null;
        }
        GenericFtraceField field = GenericFtraceField.parseLine((String)line);
        if (field != null && (matcher = IGenericFtraceConstants.FTRACE_PATTERN.matcher(line)).matches() && field.getName().equals(ATRACE_TRACEEVENT_EVENT) && (atraceMatcher = IAtraceConstants.TRACE_EVENT_PATTERN.matcher(data = matcher.group("data"))).matches()) {
            String phase = atraceMatcher.group(TRACE_EVENT_PHASE_GROUP);
            String pname = matcher.group("comm");
            String content = atraceMatcher.group(TRACE_EVENT_CONTENT_GROUP);
            Integer tid = field.getTid();
            Integer pid = field.getPid();
            HashMap<@NonNull String, @NonNull Object> argmap = new HashMap<String, Object>();
            if (phase != null) {
                argmap.put("ph", phase);
            }
            if (tid != null) {
                argmap.put("tid", tid);
            }
            if (pid != null) {
                argmap.put("pid", pid);
            }
            if (pname != null) {
                argmap.put("tname", pname);
            }
            if (content != null) {
                field.setName(content);
            }
            field.setContent(argmap);
        }
        return field;
    }
}

