/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class InlineConstantAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public InlineConstantAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public InlineConstantAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.InlineConstantAction_inline_Constant);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.inline_action");
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isInlineConstantAvailable(selection));
        }
        catch (JavaScriptModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaScriptPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isInlineConstantAvailable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue((boolean)(first instanceof IField));
            IField field = (IField)first;
            this.run(field.getNameRange().getOffset(), field.getNameRange().getLength(), field.getJavaScriptUnit());
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.InlineConstantAction_dialog_title, RefactoringMessages.InlineConstantAction_unexpected_exception);
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    @Override
    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isInlineConstantAvailable(selection));
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.setEnabled(false);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        this.run(selection.getOffset(), selection.getLength(), SelectionConverter.getInputAsCompilationUnit(this.fEditor));
    }

    private void run(int offset, int length, IJavaScriptUnit cu) {
        Assert.isNotNull((Object)cu);
        Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((length >= 0 ? 1 : 0) != 0);
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaScriptElement)cu)) {
            return;
        }
        try {
            JavaScriptUnit node = RefactoringASTParser.parseWithASTProvider((ITypeRoot)cu, true, null);
            if (!RefactoringExecutionStarter.startInlineConstantRefactoring(cu, node, offset, length, this.getShell())) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.InlineConstantAction_dialog_title, (String)RefactoringMessages.InlineConstantAction_no_constant_reference_or_declaration);
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.InlineConstantAction_dialog_title, RefactoringMessages.InlineConstantAction_unexpected_exception);
        }
    }

    public boolean tryInlineConstant(IJavaScriptUnit unit, JavaScriptUnit node, ITextSelection selection, Shell shell) {
        try {
            if (RefactoringExecutionStarter.startInlineConstantRefactoring(unit, node, selection.getOffset(), selection.getLength(), shell)) {
                return true;
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.InlineConstantAction_dialog_title, RefactoringMessages.InlineConstantAction_unexpected_exception);
        }
        return false;
    }
}

