/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathAlgorithmException;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath.CriticalPathAlgorithmBounded;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;

public class OSCriticalPathAlgorithm
extends CriticalPathAlgorithmBounded {
    public OSCriticalPathAlgorithm(ITmfGraph graph) {
        super(graph);
    }

    @Override
    public @Nullable ITmfVertex findIncoming(ITmfVertex vertex, ITmfGraph.EdgeDirection dir) {
        ITmfVertex currentVertex = vertex;
        while (true) {
            ITmfEdge incoming;
            if ((incoming = this.getGraph().getEdgeFrom(vertex, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE)) != null) {
                return currentVertex;
            }
            ITmfEdge edge = this.getGraph().getEdgeFrom(vertex, dir);
            if (edge == null || edge.getEdgeContextState().getContextEnum() != OSEdgeContextState.OSEdgeContextEnum.EPS) break;
            currentVertex = this.getNeighborFromEdge(edge, dir);
        }
        return null;
    }

    @Override
    protected List<ITmfEdge> resolveBlockingBounded(ITmfEdge blocking, ITmfVertex bound) {
        ITmfGraph graph = this.getGraph();
        LinkedList<ITmfEdge> subPath = new LinkedList<ITmfEdge>();
        ITmfVertex junction = this.findIncoming(blocking.getVertexTo(), ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        if (junction == null) {
            return subPath;
        }
        ITmfEdge down = graph.getEdgeFrom(junction, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
        if (down == null) {
            return subPath;
        }
        subPath.add(down);
        ITmfVertex vertexFrom = down.getVertexFrom();
        ITmfVertex currentBound = bound.compareTo(blocking.getVertexFrom()) < 0 ? blocking.getVertexFrom() : bound;
        ArrayDeque<ITmfVertex> stack = new ArrayDeque<ITmfVertex>();
        while (vertexFrom != null && vertexFrom.compareTo(currentBound) > 0) {
            ITmfEdge inVerticalEdge = graph.getEdgeFrom(vertexFrom, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
            if (inVerticalEdge != null && inVerticalEdge.getVertexFrom().compareTo(currentBound) <= 0) {
                subPath.add(inVerticalEdge);
                break;
            }
            ITmfEdge incomingEdge = graph.getEdgeFrom(vertexFrom, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
            if (inVerticalEdge != null && (incomingEdge == null || incomingEdge.getEdgeContextState().getContextEnum() != OSEdgeContextState.OSEdgeContextEnum.BLOCKED && incomingEdge.getEdgeContextState().getContextEnum() != OSEdgeContextState.OSEdgeContextEnum.NETWORK)) {
                stack.addFirst(vertexFrom);
            }
            if (incomingEdge != null) {
                if (incomingEdge.getEdgeContextState().getContextEnum() == OSEdgeContextState.OSEdgeContextEnum.BLOCKED || incomingEdge.getEdgeContextState().getContextEnum() == OSEdgeContextState.OSEdgeContextEnum.NETWORK) {
                    List<ITmfEdge> blockings = this.resolveBlockingBounded(incomingEdge, currentBound);
                    if (blockings.isEmpty() && incomingEdge.getEdgeContextState().getContextEnum() == OSEdgeContextState.OSEdgeContextEnum.NETWORK) {
                        subPath.add(incomingEdge);
                    } else {
                        subPath.addAll(blockings);
                    }
                } else {
                    subPath.add(incomingEdge);
                }
                vertexFrom = incomingEdge.getVertexFrom();
                continue;
            }
            if (!stack.isEmpty()) {
                ITmfVertex v = (ITmfVertex)stack.removeFirst();
                while (!subPath.isEmpty() && subPath.getLast().getVertexFrom() != v) {
                    subPath.removeLast();
                }
                ITmfEdge edge = graph.getEdgeFrom(v, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
                if (edge != null) {
                    subPath.add(edge);
                    vertexFrom = edge.getVertexFrom();
                    continue;
                }
            }
            vertexFrom = null;
        }
        return subPath;
    }

    @Override
    public ITmfGraph computeCriticalPath(ITmfGraph criticalPath, ITmfVertex start, @Nullable ITmfVertex end) throws CriticalPathAlgorithmException {
        ITmfGraph graph = this.getGraph();
        IGraphWorker parent = (IGraphWorker)NonNullUtils.checkNotNull((Object)graph.getParentOf(start));
        criticalPath.add(criticalPath.createVertex(parent, start.getTimestamp()));
        ITmfVertex currentVertex = start;
        ITmfEdge nextEdge = graph.getEdgeFrom(currentVertex, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        long endTime = Long.MAX_VALUE;
        if (end != null) {
            endTime = end.getTimestamp();
        }
        while (nextEdge != null) {
            ITmfVertex nextVertex = nextEdge.getVertexTo();
            if (nextVertex.getTimestamp() >= endTime) break;
            switch ((OSEdgeContextState.OSEdgeContextEnum)nextEdge.getEdgeContextState().getContextEnum()) {
                case UNKNOWN: 
                case RUNNING: 
                case INTERRUPTED: 
                case PREEMPTED: 
                case TIMER: 
                case USER_INPUT: 
                case BLOCK_DEVICE: 
                case IPI: {
                    IGraphWorker parentTo = (IGraphWorker)NonNullUtils.checkNotNull((Object)graph.getParentOf(nextEdge.getVertexTo()));
                    if (parentTo != parent) {
                        throw new CriticalPathAlgorithmException("no, the parents of horizontal edges are not always identical... shouldn't they be?");
                    }
                    ITmfVertex vertex = criticalPath.createVertex(parentTo, nextEdge.getVertexTo().getTimestamp());
                    criticalPath.append(vertex, nextEdge.getEdgeContextState(), nextEdge.getLinkQualifier());
                    break;
                }
                case BLOCKED: 
                case NETWORK: {
                    List<ITmfEdge> links = this.resolveBlockingBounded(nextEdge, nextEdge.getVertexFrom());
                    Collections.reverse(links);
                    this.appendPathComponent(criticalPath, graph, currentVertex, links);
                    break;
                }
                case EPS: {
                    if (nextEdge.getDuration() == 0L) break;
                    throw new CriticalPathAlgorithmException("epsilon duration is not zero " + String.valueOf(nextEdge));
                }
                case DEFAULT: {
                    throw new CriticalPathAlgorithmException("Illegal link type " + String.valueOf(nextEdge.getEdgeContextState().getContextEnum()));
                }
            }
            currentVertex = nextVertex;
            nextEdge = graph.getEdgeFrom(currentVertex, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
            if (nextEdge == null || nextEdge.getEdgeContextState().getContextEnum() != OSEdgeContextState.OSEdgeContextEnum.NO_EDGE) continue;
            nextEdge = null;
        }
        return criticalPath;
    }
}

