/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProbeEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class ChangeEventStateHandler
extends BaseControlViewHandler {
    protected Parameter fParam;

    protected abstract TraceEnablement getNewState();

    protected abstract void changeState(TraceChannelComponent var1, List<String> var2, TraceLogLevel var3, LogLevelType var4, TraceEventType var5, String var6, IProgressMonitor var7) throws ExecutionException;

    private void changeState(Parameter param, List<String> eventNames, IProgressMonitor monitor) throws ExecutionException {
        this.changeState(param.getChannel(), eventNames, param.getLogLevel(), param.getLogLevelType(), param.getEventType(), param.getProbe(), monitor);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            final Parameter param = new Parameter(this.fParam);
            Job job = new Job(Messages.TraceControl_ChangeChannelStateJob){

                protected IStatus run(IProgressMonitor monitor) {
                    ExecutionException error = null;
                    TraceSessionComponent session = null;
                    try {
                        if (param.getChannel() != null) {
                            session = param.getChannel().getSession();
                            ArrayList<String> eventNames = new ArrayList<String>();
                            List<TraceEventComponent> events = param.getEvents();
                            for (TraceEventComponent traceEvent : events) {
                                if ("*".equals(traceEvent.getName())) {
                                    ChangeEventStateHandler.this.changeState(param, null, monitor);
                                    continue;
                                }
                                eventNames.add(traceEvent.getName());
                            }
                            if (!eventNames.isEmpty()) {
                                ChangeEventStateHandler.this.changeState(param, eventNames, monitor);
                            }
                            for (TraceEventComponent traceEvent : events) {
                                traceEvent.setState(ChangeEventStateHandler.this.getNewState());
                            }
                        }
                    }
                    catch (ExecutionException e) {
                        error = e;
                    }
                    if (session != null) {
                        session.fireComponentChanged(session);
                    }
                    if (error != null) {
                        return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_ChangeEventStateFailure, (Throwable)error);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        TraceChannelComponent channel = null;
        TraceLogLevel logLevel = null;
        LogLevelType logLevelType = null;
        ArrayList<TraceEventComponent> events = new ArrayList<TraceEventComponent>();
        TraceEventType eventType = null;
        String probe = null;
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            String sessionName = null;
            String channelName = null;
            for (Object element : structered) {
                if (!(element instanceof TraceEventComponent)) continue;
                TraceEventComponent event = (TraceEventComponent)element;
                if (sessionName == null) {
                    sessionName = String.valueOf(event.getSessionName());
                }
                if (channel == null) {
                    channel = (TraceChannelComponent)event.getParent();
                }
                if (channelName == null) {
                    channelName = event.getChannelName();
                }
                if (logLevel == null) {
                    logLevel = event.getLogLevel();
                }
                if (logLevelType == null) {
                    logLevelType = event.getLogLevelType();
                }
                if (eventType == null) {
                    eventType = event.getEventType();
                } else if (!eventType.equals((Object)event.getEventType())) {
                    events.clear();
                    break;
                }
                if (probe == null) {
                    if (event instanceof TraceProbeEventComponent) {
                        probe = ((TraceProbeEventComponent)event).getProbeString();
                    }
                } else {
                    events.clear();
                    break;
                }
                if (!(sessionName.equals(event.getSessionName()) && channelName.equals(event.getChannelName()) && channel.getDomain().equals((Object)event.getDomain()))) {
                    events.clear();
                    break;
                }
                if (!(event.getLogLevelType().equals((Object)LogLevelType.LOGLEVEL_NONE) || logLevelType.equals((Object)event.getLogLevelType()) && logLevel.equals((Object)event.getLogLevel()))) {
                    events.clear();
                    break;
                }
                if (event.getState() == this.getNewState()) continue;
                events.add(event);
            }
        }
        boolean isEnabled = !events.isEmpty();
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new Parameter(channel, events, logLevel, logLevelType, eventType, probe);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    protected static class Parameter {
        private final TraceChannelComponent fChannel;
        private final List<TraceEventComponent> fEvents = new ArrayList<TraceEventComponent>();
        private final TraceLogLevel fLogLevel;
        private final LogLevelType fLogLevelType;
        private final TraceEventType fEventType;
        private final String fProbe;

        public Parameter(TraceChannelComponent channel, List<TraceEventComponent> events, TraceLogLevel logLevel, LogLevelType logLevelType, TraceEventType eventType, String probe) {
            this.fChannel = channel;
            this.fEvents.addAll(events);
            this.fLogLevel = logLevel;
            this.fLogLevelType = logLevelType;
            this.fEventType = eventType;
            this.fProbe = probe;
        }

        public Parameter(Parameter other) {
            this(other.fChannel, other.fEvents, other.fLogLevel, other.fLogLevelType, other.fEventType, other.fProbe);
        }

        public TraceChannelComponent getChannel() {
            return this.fChannel;
        }

        public List<TraceEventComponent> getEvents() {
            return this.fEvents;
        }

        public LogLevelType getLogLevelType() {
            return this.fLogLevelType;
        }

        public TraceLogLevel getLogLevel() {
            return this.fLogLevel;
        }

        public TraceEventType getEventType() {
            return this.fEventType;
        }

        public String getProbe() {
            return this.fProbe;
        }
    }
}

