/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.binary;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryWizard;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringContribution;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.binary.AbstractCodeCreationOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.binary.SourceCreationOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.binary.StubCreationOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;

public abstract class BinaryRefactoringHistoryWizard
extends RefactoringHistoryWizard {
    private static final String META_INF_FRAGMENT = "META-INF/MANIFEST.MF".substring(0, "META-INF/MANIFEST.MF".indexOf(47));
    private static final String SOURCE_FOLDER = ".src";
    private static final String STUB_FOLDER = ".stubs";
    protected boolean fAutoBuild = true;
    protected boolean fCancelled = false;
    protected RefactoringArguments fCurrentArguments = null;
    protected IScriptableRefactoring fCurrentRefactoring = null;
    protected IJavaScriptProject fJavaProject = null;
    protected final Collection fProcessedFragments = new HashSet();
    protected IFolder fSourceFolder = null;

    private static void addExclusionPatterns(List entries, IPath path) {
        int index = 0;
        while (index < entries.size()) {
            IPath[] patterns;
            IIncludePathEntry entry = (IIncludePathEntry)entries.get(index);
            if (entry.getEntryKind() == 3 && entry.getPath().isPrefixOf(path) && !JavaModelUtil.isExcludedPath(path, patterns = entry.getExclusionPatterns())) {
                IPath[] filters = new IPath[patterns.length + 1];
                System.arraycopy(patterns, 0, filters, 0, patterns.length);
                filters[patterns.length] = path.removeFirstSegments(entry.getPath().segmentCount()).addTrailingSeparator();
                entries.set(index, JavaScriptCore.newSourceEntry((IPath)entry.getPath(), (IPath[])filters, null));
            }
            ++index;
        }
    }

    private static RefactoringStatus checkPackageFragmentRoots(IPackageFragmentRoot root, IProgressMonitor monitor) {
        RefactoringStatus status;
        block14: {
            status = new RefactoringStatus();
            try {
                IJavaScriptModel model;
                monitor.beginTask(RefactoringMessages.JarImportWizard_prepare_import, 100);
                IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
                if (workspace == null || (model = JavaScriptCore.create((IWorkspaceRoot)workspace)) == null) break block14;
                try {
                    URI uri = BinaryRefactoringHistoryWizard.getLocationURI(root.getRawIncludepathEntry());
                    if (uri == null) break block14;
                    IJavaScriptProject[] projects = model.getJavaScriptProjects();
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100, 2);
                    try {
                        subMonitor.beginTask(RefactoringMessages.JarImportWizard_prepare_import, projects.length * 100);
                        int index = 0;
                        while (index < projects.length) {
                            IPackageFragmentRoot[] roots = projects[index].getPackageFragmentRoots();
                            SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 100, 2);
                            try {
                                subsubMonitor.beginTask(RefactoringMessages.JarImportWizard_prepare_import, roots.length);
                                int offset = 0;
                                while (offset < roots.length) {
                                    URI location;
                                    IIncludePathEntry entry;
                                    IPackageFragmentRoot current = roots[offset];
                                    if (!current.equals(root) && current.getKind() == 2 && (entry = current.getRawIncludepathEntry()).getEntryKind() == 1 && uri.equals(location = BinaryRefactoringHistoryWizard.getLocationURI(entry))) {
                                        status.addFatalError(Messages.format(RefactoringMessages.JarImportWizard_error_shared_jar, new String[]{current.getJavaScriptProject().getElementName()}));
                                    }
                                    subsubMonitor.worked(1);
                                    ++offset;
                                }
                            }
                            finally {
                                subsubMonitor.done();
                            }
                            ++index;
                        }
                    }
                    finally {
                        subMonitor.done();
                    }
                }
                catch (CoreException exception) {
                    status.addError(exception.getLocalizedMessage());
                }
            }
            finally {
                monitor.done();
            }
        }
        return status;
    }

    private static void configureClasspath(IJavaScriptProject project, IPackageFragmentRoot root, IFolder folder, IProgressMonitor monitor) throws IllegalStateException, CoreException {
        try {
            monitor.beginTask(RefactoringMessages.JarImportWizard_prepare_import, 200);
            IIncludePathEntry entry = root.getRawIncludepathEntry();
            IIncludePathEntry[] entries = project.getRawIncludepath();
            ArrayList<IIncludePathEntry> list = new ArrayList<IIncludePathEntry>();
            list.addAll(Arrays.asList(entries));
            IFileStore store = EFS.getLocalFileSystem().getStore(JavaScriptPlugin.getDefault().getStateLocation().append(STUB_FOLDER).append(project.getElementName()));
            if (store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2)).exists()) {
                store.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2));
            }
            store.mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2));
            folder.createLink(store.toURI(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2));
            BinaryRefactoringHistoryWizard.addExclusionPatterns(list, folder.getFullPath());
            int index = 0;
            while (index < entries.length) {
                if (entries[index].equals(entry)) {
                    list.add(index, JavaScriptCore.newSourceEntry((IPath)folder.getFullPath()));
                }
                ++index;
            }
            project.setRawIncludepath(list.toArray(new IIncludePathEntry[list.size()]), false, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
        }
        finally {
            monitor.done();
        }
    }

    public static URI getLocationURI(IIncludePathEntry entry) {
        IPath path = null;
        path = entry.getEntryKind() == 4 ? JavaScriptCore.getResolvedVariablePath((IPath)entry.getPath()) : entry.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        URI location = null;
        location = root.exists(path) ? root.getFile(path).getRawLocationURI() : URIUtil.toURI((IPath)path);
        return location;
    }

    protected BinaryRefactoringHistoryWizard(boolean overview, String caption, String title, String description) {
        super(overview, caption, title, description);
    }

    protected BinaryRefactoringHistoryWizard(String caption, String title, String description) {
        super(caption, title, description);
    }

    protected RefactoringStatus aboutToPerformHistory(IProgressMonitor monitor) {
        RefactoringStatus status;
        block13: {
            status = new RefactoringStatus();
            try {
                IJavaScriptProject project;
                IPackageFragmentRoot root;
                this.fJavaProject = null;
                this.fSourceFolder = null;
                this.fProcessedFragments.clear();
                monitor.beginTask(RefactoringMessages.JarImportWizard_prepare_import, 520);
                status.merge(super.aboutToPerformHistory((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2)));
                if (status.hasFatalError() || (root = this.getPackageFragmentRoot()) == null) break block13;
                status.merge(BinaryRefactoringHistoryWizard.checkPackageFragmentRoots(root, (IProgressMonitor)new SubProgressMonitor(monitor, 90, 2)));
                if (status.hasFatalError()) break block13;
                status.merge(this.checkSourceAttachmentRefactorings((IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)));
                if (status.hasFatalError() || (project = root.getJavaScriptProject()) == null) break block13;
                IFolder folder = project.getProject().getFolder(SOURCE_FOLDER + String.valueOf(System.currentTimeMillis()));
                try {
                    try {
                        this.fAutoBuild = CoreUtility.enableAutoBuild(false);
                        RefactoringHistory history = this.getRefactoringHistory();
                        if (history != null && !history.isEmpty()) {
                            BinaryRefactoringHistoryWizard.configureClasspath(project, root, folder, (IProgressMonitor)new SubProgressMonitor(monitor, 300, 2));
                        }
                    }
                    catch (CoreException exception) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                        try {
                            project.setRawIncludepath(project.readRawIncludepath(), false, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                        }
                        catch (CoreException throwable) {
                            JavaScriptPlugin.log(throwable);
                        }
                        if (!status.hasFatalError()) {
                            this.fJavaProject = project;
                            this.fSourceFolder = folder;
                        }
                    }
                }
                finally {
                    if (!status.hasFatalError()) {
                        this.fJavaProject = project;
                        this.fSourceFolder = folder;
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
        return status;
    }

    protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(RefactoringMessages.JarImportWizard_prepare_import, 100);
            status.merge(this.createNecessarySourceCode(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)));
            if (!status.hasFatalError() && this.fCurrentRefactoring != null && this.fCurrentArguments != null) {
                status.merge(this.fCurrentRefactoring.initialize(this.fCurrentArguments));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected boolean canUseSourceAttachment() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            try {
                return root.getSourceAttachmentPath() != null;
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
        }
        return false;
    }

    protected RefactoringStatus checkSourceAttachmentRefactorings(IProgressMonitor monitor) {
        RefactoringStatus status = new RefactoringStatus();
        try {
            if (!this.canUseSourceAttachment()) {
                RefactoringDescriptorProxy[] proxies = this.getRefactoringHistory().getDescriptors();
                monitor.beginTask(RefactoringMessages.JarImportWizard_prepare_import, proxies.length * 100);
                int index = 0;
                while (index < proxies.length) {
                    int flags;
                    RefactoringDescriptor descriptor = proxies[index].requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                    if (descriptor != null && ((flags = descriptor.getFlags()) & 0x40000) != 0) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringMessages.BinaryRefactoringHistoryWizard_error_missing_source_attachment, descriptor.getDescription())));
                    }
                    ++index;
                }
            } else {
                monitor.beginTask(RefactoringMessages.JarImportWizard_prepare_import, 1);
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus createNecessarySourceCode(Refactoring refactoring, IProgressMonitor monitor) {
        RefactoringStatus status;
        block13: {
            status = new RefactoringStatus();
            try {
                monitor.beginTask(RefactoringMessages.JarImportWizard_prepare_import, 240);
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                if (root == null || this.fSourceFolder == null || this.fJavaProject == null) break block13;
                try {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 40, 2);
                    IJavaScriptElement[] elements = root.getChildren();
                    ArrayList<IJavaScriptElement> list = new ArrayList<IJavaScriptElement>(elements.length);
                    try {
                        subMonitor.beginTask(RefactoringMessages.JarImportWizard_prepare_import, elements.length);
                        int index = 0;
                        while (index < elements.length) {
                            IJavaScriptElement element = elements[index];
                            if (!this.fProcessedFragments.contains(element) && !element.getElementName().equals(META_INF_FRAGMENT)) {
                                list.add(element);
                            }
                            subMonitor.worked(1);
                            ++index;
                        }
                    }
                    finally {
                        subMonitor.done();
                    }
                    if (list.isEmpty()) break block13;
                    this.fProcessedFragments.addAll(list);
                    URI uri = this.fSourceFolder.getRawLocationURI();
                    if (uri == null) break block13;
                    final IPackageFragmentRoot sourceFolder = this.fJavaProject.getPackageFragmentRoot((IResource)this.fSourceFolder);
                    AbstractCodeCreationOperation runnable = null;
                    runnable = this.canUseSourceAttachment() ? new SourceCreationOperation(uri, list){
                        private IPackageFragment fFragment;
                        {
                            super($anonymous0, $anonymous1);
                            this.fFragment = null;
                        }

                        @Override
                        protected final void createCompilationUnit(IFileStore store, String name, String content, IProgressMonitor pm) throws CoreException {
                            this.fFragment.createCompilationUnit(name, content, true, pm);
                        }

                        @Override
                        protected final void createPackageFragment(IFileStore store, String name, IProgressMonitor pm) throws CoreException {
                            this.fFragment = sourceFolder.createPackageFragment(name, true, pm);
                        }
                    } : new StubCreationOperation(uri, list, true){
                        private IPackageFragment fFragment;
                        {
                            super($anonymous0, $anonymous1, $anonymous2);
                            this.fFragment = null;
                        }

                        @Override
                        protected final void createCompilationUnit(IFileStore store, String name, String content, IProgressMonitor pm) throws CoreException {
                            this.fFragment.createCompilationUnit(name, content, true, pm);
                        }

                        @Override
                        protected final void createPackageFragment(IFileStore store, String name, IProgressMonitor pm) throws CoreException {
                            this.fFragment = sourceFolder.createPackageFragment(name, true, pm);
                        }
                    };
                    try {
                        runnable.run((IProgressMonitor)new SubProgressMonitor(monitor, 150, 2));
                    }
                    finally {
                        this.fSourceFolder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                    }
                }
                catch (CoreException exception) {
                    status.addFatalError(exception.getLocalizedMessage());
                }
            }
            finally {
                monitor.done();
            }
        }
        return status;
    }

    protected Refactoring createRefactoring(RefactoringDescriptor descriptor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)descriptor);
        Refactoring refactoring = null;
        if (descriptor instanceof JDTRefactoringDescriptor) {
            JDTRefactoringDescriptor javaDescriptor = (JDTRefactoringDescriptor)descriptor;
            RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)javaDescriptor.getID());
            if (contribution instanceof JDTRefactoringContribution) {
                JDTRefactoringContribution extended = (JDTRefactoringContribution)contribution;
                refactoring = extended.createRefactoring(descriptor);
            }
            if (refactoring != null) {
                JavaRefactoringArguments arguments = javaDescriptor.createArguments();
                if (arguments instanceof JavaRefactoringArguments) {
                    JavaRefactoringArguments extended = arguments;
                    if (this.fJavaProject != null) {
                        String name = this.fJavaProject.getElementName();
                        extended.setProject(name);
                        String handle = extended.getAttribute("input");
                        if (handle != null && !"".equals(handle)) {
                            extended.setAttribute("input", this.getTransformedHandle(name, handle));
                        }
                        int count = 1;
                        String attribute = "element" + count;
                        while ((handle = extended.getAttribute(attribute)) != null) {
                            if (!"".equals(handle)) {
                                extended.setAttribute(attribute, this.getTransformedHandle(name, handle));
                            }
                            attribute = "element" + ++count;
                        }
                    }
                } else {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments));
                }
                if (refactoring instanceof IScriptableRefactoring) {
                    this.fCurrentRefactoring = (IScriptableRefactoring)refactoring;
                    this.fCurrentArguments = arguments;
                } else {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_initialization_error, javaDescriptor.getID())));
                }
            }
            return refactoring;
        }
        return null;
    }

    protected boolean deconfigureClasspath(IIncludePathEntry[] entries, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    private void deconfigureClasspath(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringMessages.JarImportWizard_cleanup_import, 300);
            if (this.fJavaProject != null) {
                boolean valid;
                IIncludePathEntry[] entries = this.fJavaProject.readRawIncludepath();
                boolean changed = this.deconfigureClasspath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                RefactoringHistory history = this.getRefactoringHistory();
                boolean bl = valid = history != null && !history.isEmpty();
                if (valid) {
                    RefactoringCore.getUndoManager().flush();
                }
                if (valid || changed) {
                    this.fJavaProject.setRawIncludepath(entries, changed, (IProgressMonitor)new SubProgressMonitor(monitor, 60, 2));
                }
            }
            if (this.fSourceFolder != null) {
                IFileStore store = EFS.getStore((URI)this.fSourceFolder.getRawLocationURI());
                if (store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2)).exists()) {
                    store.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                }
                this.fSourceFolder.delete(true, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                this.fSourceFolder.clearHistory((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                this.fSourceFolder = null;
            }
            if (this.fJavaProject != null) {
                try {
                    this.fJavaProject.getResource().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                }
                catch (CoreException exception) {
                    JavaScriptPlugin.log(exception);
                }
            }
        }
        finally {
            this.fJavaProject = null;
            monitor.done();
        }
    }

    protected abstract IPackageFragmentRoot getPackageFragmentRoot();

    protected abstract RefactoringHistory getRefactoringHistory();

    private String getTransformedHandle(String project, String handle) {
        IJavaScriptElement target;
        if (this.fSourceFolder != null && (target = JavaScriptCore.create((IFolder)this.fSourceFolder)) instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot extended = (IPackageFragmentRoot)target;
            String sourceIdentifier = null;
            IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(project, handle, false);
            if (element != null) {
                IJavaScriptElement result;
                IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
                if (root != null) {
                    sourceIdentifier = root.getHandleIdentifier();
                } else {
                    IJavaScriptProject javaProject = element.getJavaScriptProject();
                    if (javaProject != null) {
                        sourceIdentifier = javaProject.getHandleIdentifier();
                    }
                }
                if (sourceIdentifier != null && (result = JavaScriptCore.create((String)(String.valueOf(extended.getHandleIdentifier()) + element.getHandleIdentifier().substring(sourceIdentifier.length())))) != null) {
                    return JDTRefactoringDescriptor.elementToHandle(project, result);
                }
            }
        }
        return handle;
    }

    protected RefactoringStatus historyPerformed(IProgressMonitor monitor) {
        try {
            RefactoringStatus status;
            block15: {
                monitor.beginTask(RefactoringMessages.JarImportWizard_cleanup_import, 100);
                status = super.historyPerformed((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                if (!status.hasFatalError()) {
                    try {
                        try {
                            this.deconfigureClasspath((IProgressMonitor)new SubProgressMonitor(monitor, 90, 2));
                        }
                        catch (CoreException exception) {
                            status.addError(exception.getLocalizedMessage());
                            try {
                                CoreUtility.enableAutoBuild(this.fAutoBuild);
                            }
                            catch (CoreException exception2) {
                                JavaScriptPlugin.log(exception2);
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            CoreUtility.enableAutoBuild(this.fAutoBuild);
                        }
                        catch (CoreException exception) {
                            JavaScriptPlugin.log(exception);
                        }
                        throw throwable;
                    }
                    try {
                        CoreUtility.enableAutoBuild(this.fAutoBuild);
                    }
                    catch (CoreException exception) {
                        JavaScriptPlugin.log(exception);
                    }
                }
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    public boolean performCancel() {
        this.fCancelled = true;
        return super.performCancel();
    }

    protected RefactoringStatus refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
        try {
            monitor.beginTask("", 120);
            RefactoringStatus status = super.refactoringPerformed(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
            if (!status.hasFatalError() && this.fSourceFolder != null) {
                try {
                    this.fSourceFolder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                }
                catch (CoreException exception) {
                    JavaScriptPlugin.log(exception);
                }
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected boolean selectPreviewChange(Change change) {
        if (this.fSourceFolder != null) {
            IAdaptable adaptable;
            IResource resource;
            IPath source = this.fSourceFolder.getFullPath();
            Object element = change.getModifiedElement();
            if (element instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) != null && source.isPrefixOf(resource.getFullPath())) {
                return false;
            }
        }
        return super.selectPreviewChange(change);
    }

    protected boolean selectStatusEntry(RefactoringStatusEntry entry) {
        if (this.fSourceFolder != null) {
            IResource resource;
            JavaStatusContext extended;
            IJavaScriptUnit unit;
            IPath source = this.fSourceFolder.getFullPath();
            RefactoringStatusContext context = entry.getContext();
            if (context instanceof JavaStatusContext && (unit = (extended = (JavaStatusContext)context).getCompilationUnit()) != null && (resource = unit.getResource()) != null && source.isPrefixOf(resource.getFullPath())) {
                return false;
            }
        }
        return super.selectStatusEntry(entry);
    }
}

