/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.util.QuotedStringTokenizer;

public abstract class QuotedCSVParser {
    public static final String DELIMITERS = ",;=";
    public static final QuotedStringTokenizer LIST_TOKENIZER = QuotedStringTokenizer.builder().delimiters(",;=").ignoreOptionalWhiteSpace().allowEmbeddedQuotes().returnDelimiters().returnQuotes().build();
    protected final boolean _keepQuotes;

    public QuotedCSVParser(boolean keepQuotes) {
        this._keepQuotes = keepQuotes;
    }

    public static String quote(String s) {
        return LIST_TOKENIZER.quote(s);
    }

    public static String quoteIfNeeded(String s) {
        return LIST_TOKENIZER.quoteIfNeeded(s);
    }

    public static String unquote(String s) {
        return LIST_TOKENIZER.unquote(s);
    }

    /*
     * Unable to fully structure code
     */
    public void addValue(String value) {
        if (value == null) {
            return;
        }
        buffer = new StringBuilder();
        l = value.length();
        state = State.VALUE;
        quoted = false;
        sloshed = false;
        nwsLength = 0;
        lastLength = 0;
        valueLength = -1;
        paramName = -1;
        paramValue = -1;
        block25: for (i = 0; i <= l; ++i) {
            block40: {
                block41: {
                    v0 = c = i == l ? '\u0000' : value.charAt(i);
                    if (!quoted || c == '\u0000') break block40;
                    if (!sloshed) break block41;
                    sloshed = false;
                    ** GOTO lbl-1000
                }
                switch (c) {
                    case '\\': {
                        sloshed = true;
                        if (!this._keepQuotes) {
                            break;
                        }
                        ** GOTO lbl29
                    }
                    case '\"': {
                        quoted = false;
                        if (!this._keepQuotes) break;
                    }
lbl29:
                    // 3 sources

                    default: lbl-1000:
                    // 2 sources

                    {
                        buffer.append(c);
                        nwsLength = buffer.length();
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\t': 
                case ' ': {
                    if (buffer.length() > lastLength) {
                        buffer.append(c);
                        continue block25;
                    }
                    if (state != State.PARAM_VALUE) continue block25;
                    this.onComplianceViolation(HttpCompliance.Violation.WHITESPACE_IN_PARAMETER);
                    continue block25;
                }
                case ';': {
                    buffer.setLength(nwsLength);
                    if (state == State.VALUE) {
                        this.parsedValue(buffer);
                        valueLength = buffer.length();
                    } else {
                        this.parsedParam(buffer, valueLength, paramName, paramValue);
                    }
                    nwsLength = buffer.length();
                    paramValue = -1;
                    paramName = -1;
                    buffer.append(c);
                    lastLength = ++nwsLength;
                    state = State.PARAM_NAME;
                    continue block25;
                }
                case '\u0000': 
                case ',': {
                    if (nwsLength > 0) {
                        buffer.setLength(nwsLength);
                        switch (state.ordinal()) {
                            case 0: {
                                this.parsedValue(buffer);
                                break;
                            }
                            case 1: 
                            case 2: {
                                this.parsedParam(buffer, valueLength, paramName, paramValue);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(state.toString());
                            }
                        }
                        this.parsedValueAndParams(buffer);
                    }
                    buffer.setLength(0);
                    lastLength = 0;
                    nwsLength = 0;
                    paramValue = -1;
                    paramName = -1;
                    valueLength = -1;
                    state = State.VALUE;
                    continue block25;
                }
                case '=': {
                    switch (state.ordinal()) {
                        case 0: {
                            paramName = 0;
                            if (nwsLength != buffer.length()) {
                                this.onComplianceViolation(HttpCompliance.Violation.WHITESPACE_IN_PARAMETER);
                            }
                            buffer.setLength(nwsLength);
                            param = buffer.toString();
                            buffer.setLength(0);
                            this.parsedValue(buffer);
                            valueLength = buffer.length();
                            buffer.append(param);
                            buffer.append(c);
                            lastLength = ++nwsLength;
                            state = State.PARAM_VALUE;
                            continue block25;
                        }
                        case 1: {
                            if (nwsLength != buffer.length()) {
                                this.onComplianceViolation(HttpCompliance.Violation.WHITESPACE_IN_PARAMETER);
                            }
                            buffer.setLength(nwsLength);
                            buffer.append(c);
                            lastLength = ++nwsLength;
                            state = State.PARAM_VALUE;
                            continue block25;
                        }
                        case 2: {
                            if (paramValue < 0) {
                                paramValue = nwsLength;
                            }
                            buffer.append(c);
                            nwsLength = buffer.length();
                            continue block25;
                        }
                    }
                    throw new IllegalStateException(state.toString());
                }
                case '\"': {
                    if (state == State.VALUE && buffer.isEmpty() || state == State.PARAM_VALUE && paramValue < 0) {
                        quoted = true;
                        if (state == State.PARAM_VALUE) {
                            paramValue = nwsLength;
                        }
                        if (this._keepQuotes) {
                            buffer.append(c);
                        }
                        nwsLength = buffer.length();
                        continue block25;
                    }
                }
                default: {
                    switch (state.ordinal()) {
                        case 0: {
                            buffer.append(c);
                            nwsLength = buffer.length();
                            continue block25;
                        }
                        case 1: {
                            if (paramName < 0) {
                                paramName = nwsLength;
                            }
                            buffer.append(c);
                            nwsLength = buffer.length();
                            continue block25;
                        }
                        case 2: {
                            if (paramValue < 0) {
                                paramValue = nwsLength;
                            }
                            buffer.append(c);
                            nwsLength = buffer.length();
                            continue block25;
                        }
                    }
                    throw new IllegalStateException(state.toString());
                }
            }
        }
    }

    protected void parsedValueAndParams(StringBuilder buffer) {
    }

    protected void parsedValue(StringBuilder buffer) {
    }

    protected void parsedParam(StringBuilder buffer, int valueLength, int paramName, int paramValue) {
    }

    protected void onComplianceViolation(ComplianceViolation violation) {
        throw new IllegalArgumentException(violation.getDescription());
    }

    private static enum State {
        VALUE,
        PARAM_NAME,
        PARAM_VALUE;

    }
}

