/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyEntryModel;

public class TmfTreeModelSerializer
extends StdSerializer<TmfTreeDataModel> {
    private static final long serialVersionUID = 3393902091244330176L;

    protected TmfTreeModelSerializer() {
        super(TmfTreeDataModel.class);
    }

    public void serialize(TmfTreeDataModel value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField("id", value.getId());
        gen.writeNumberField("parentId", value.getParentId());
        if (value.getStyle() != null) {
            gen.writeObjectField("style", (Object)value.getStyle());
        }
        gen.writeArrayFieldStart("labels");
        for (String label : value.getLabels()) {
            gen.writeString(label);
        }
        gen.writeEndArray();
        if (value.hasRowModel()) {
            gen.writeBooleanField("hasData", value.hasRowModel());
        }
        if (value instanceof ITmfXyEntryModel) {
            ITmfXyEntryModel xyValue = (ITmfXyEntryModel)value;
            gen.writeBooleanField("isDefault", xyValue.isDefault());
        }
        gen.writeEndObject();
    }
}

