/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.encoding.HTVarInt;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public final class HTInterval
implements ITmfStateInterval {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String errMsg = "Invalid interval data. Maybe your file is corrupt?";
    private static final byte TYPE_NULL = -1;
    private static final byte TYPE_INTEGER = 0;
    private static final byte TYPE_STRING = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_DOUBLE = 3;
    private static final byte TYPE_CUSTOM = 20;
    private final long fStart;
    private final long fDuration;
    private final int fAttribute;
    private final @Nullable Object fStateValue;
    private int fSizeOnDisk;

    public HTInterval(long intervalStart, long intervalEnd, int attribute, Object value) throws TimeRangeException {
        if (intervalStart > intervalEnd) {
            throw new TimeRangeException("Start:" + intervalStart + ", End:" + intervalEnd);
        }
        this.fStart = intervalStart;
        this.fDuration = intervalEnd - intervalStart;
        this.fAttribute = attribute;
        this.fStateValue = value instanceof TmfStateValue ? ((ITmfStateValue)value).unboxValue() : value;
        this.fSizeOnDisk = this.computeSizeOnDisk(this.fStateValue, 0L);
    }

    private int computeSizeOnDisk(Object stateValue, long nodeStart) {
        int minSize = HTVarInt.getEncodedLengthLong((long)(this.fStart - nodeStart)) + HTVarInt.getEncodedLengthLong((long)this.fDuration) + 4 + 1;
        if (stateValue == null) {
            return minSize;
        }
        if (stateValue instanceof Integer) {
            return minSize + 4;
        }
        if (stateValue instanceof Long) {
            return minSize + 8;
        }
        if (stateValue instanceof Double) {
            return minSize + 8;
        }
        if (stateValue instanceof CustomStateValue) {
            return minSize + 2 + ((CustomStateValue)stateValue).getSerializedSize();
        }
        String str = String.valueOf(stateValue);
        int strLength = str.getBytes(CHARSET).length;
        if (strLength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("String is too long to be stored in state system: " + str);
        }
        return minSize + strLength + 3;
    }

    private HTInterval(long intervalStart, long intervalEnd, int attribute, Object value, int size) throws TimeRangeException {
        if (intervalStart > intervalEnd) {
            throw new TimeRangeException("Start:" + intervalStart + ", End:" + intervalEnd);
        }
        this.fStart = intervalStart;
        this.fDuration = intervalEnd - intervalStart;
        this.fAttribute = attribute;
        this.fStateValue = value;
        this.fSizeOnDisk = size;
    }

    public static final HTInterval readFrom(ByteBuffer buffer, long nodeStart) throws IOException {
        Object value;
        int posStart = buffer.position();
        long intervalStart = HTVarInt.readLong((ByteBuffer)buffer) + nodeStart;
        long intervalEnd = HTVarInt.readLong((ByteBuffer)buffer) + intervalStart;
        int attribute = buffer.getInt();
        byte valueType = buffer.get();
        switch (valueType) {
            case -1: {
                value = null;
                break;
            }
            case 0: {
                value = buffer.getInt();
                break;
            }
            case 1: {
                short valueSize = buffer.getShort();
                byte[] array = new byte[valueSize];
                buffer.get(array);
                value = new String(array, CHARSET);
                byte res = buffer.get();
                if (res == 0) break;
                throw new IOException(errMsg);
            }
            case 2: {
                value = buffer.getLong();
                break;
            }
            case 3: {
                value = buffer.getDouble();
                break;
            }
            case 20: {
                short valueSize = buffer.getShort();
                ISafeByteBufferReader safeBuffer = SafeByteBufferFactory.wrapReader((ByteBuffer)buffer, (int)valueSize);
                value = CustomStateValue.readSerializedValue(safeBuffer);
                break;
            }
            default: {
                throw new IOException(errMsg);
            }
        }
        try {
            return new HTInterval(intervalStart, intervalEnd, attribute, value, buffer.position() - posStart);
        }
        catch (TimeRangeException e) {
            throw new IOException(errMsg);
        }
    }

    public void writeInterval(ByteBuffer buffer, long nodeStart) {
        HTVarInt.writeLong((ByteBuffer)buffer, (long)(this.fStart - nodeStart));
        HTVarInt.writeLong((ByteBuffer)buffer, (long)this.fDuration);
        buffer.putInt(this.fAttribute);
        if (this.fStateValue != null) {
            @NonNull Object value = this.fStateValue;
            if (value instanceof Integer) {
                buffer.put((byte)0);
                buffer.putInt((Integer)value);
            } else if (value instanceof Long) {
                buffer.put((byte)2);
                buffer.putLong((Long)value);
            } else if (value instanceof Double) {
                buffer.put((byte)3);
                buffer.putDouble((Double)value);
            } else if (value instanceof CustomStateValue) {
                buffer.put((byte)20);
                int size = ((CustomStateValue)value).getSerializedSize();
                buffer.putShort((short)size);
                ISafeByteBufferWriter safeBuffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)buffer, (int)size);
                ((CustomStateValue)value).serialize(safeBuffer);
            } else {
                String string = String.valueOf(value);
                buffer.put((byte)1);
                byte[] strArray = string.getBytes(CHARSET);
                buffer.putShort((short)strArray.length);
                buffer.put(strArray);
                buffer.put((byte)0);
            }
        } else {
            buffer.put((byte)-1);
        }
    }

    @Override
    public long getStartTime() {
        return this.fStart;
    }

    @Override
    public long getEndTime() {
        return this.fStart + this.fDuration;
    }

    @Override
    public int getAttribute() {
        return this.fAttribute;
    }

    @Override
    public ITmfStateValue getStateValue() {
        return TmfStateValue.newValue(this.fStateValue);
    }

    @Override
    public Object getValue() {
        return this.fStateValue;
    }

    @Override
    public boolean intersects(long timestamp) {
        return this.fStart <= timestamp && this.fStart + this.fDuration >= timestamp;
    }

    public int getSizeOnDisk() {
        return this.fSizeOnDisk;
    }

    public int getSizeOnDisk(long nodeStart) {
        return this.computeSizeOnDisk(this.fStateValue, nodeStart);
    }

    public void setSizeOnDisk(int sizeOnDisk) {
        this.fSizeOnDisk = sizeOnDisk;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HTInterval other = (HTInterval)obj;
        return this.fStart == other.fStart && this.fDuration == other.fDuration && this.fAttribute == other.fAttribute && Objects.equals(this.fStateValue, other.fStateValue);
    }

    public int hashCode() {
        return Objects.hash(this.fStart, this.fDuration, this.fAttribute, this.fStateValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.fStart);
        sb.append(", ");
        sb.append(this.fStart + this.fDuration);
        sb.append(']');
        sb.append(", attribute = ");
        sb.append(this.fAttribute);
        sb.append(", value = ");
        sb.append(String.valueOf(this.fStateValue));
        return sb.toString();
    }
}

