/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSourceType;

public class TmfConfigurationSourceTypeSerializer
extends StdSerializer<ITmfConfigurationSourceType> {
    private static final long serialVersionUID = 9170252203750031947L;

    public TmfConfigurationSourceTypeSerializer() {
        super(ITmfConfigurationSourceType.class);
    }

    public void serialize(ITmfConfigurationSourceType value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        File schemaFile;
        gen.writeStartObject();
        gen.writeStringField("id", value.getId());
        gen.writeStringField("name", value.getName());
        gen.writeStringField("description", value.getDescription());
        if (!value.getConfigParamDescriptors().isEmpty()) {
            gen.writeObjectField("parameterDescriptors", (Object)value.getConfigParamDescriptors());
        }
        if ((schemaFile = value.getSchemaFile()) != null) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileInputStream inputStream = new FileInputStream(schemaFile);){
                ObjectMapper mapper = new ObjectMapper();
                JsonNode schema = mapper.readTree((InputStream)inputStream);
                gen.writeFieldName("schema");
                gen.writeTree((TreeNode)schema);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        gen.writeEndObject();
    }
}

