/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceCPUDataPage;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceEventFormat;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceEventSystem;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFileCPU;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFormatField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFunctionAddressNameMapping;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFunctionType;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceHeaderEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceOption;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceVersion;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceVersionHeader;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser.BinaryFTraceByteBuffer;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser.BinaryFTraceParsingUtils;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;

public abstract class AbstractBinaryFTraceFileParser {
    protected AbstractBinaryFTraceFileParser() {
    }

    protected static BinaryFTraceVersionHeader getMagicValuesAndFtraceVersion(byte[] magicValues, String strVersion) throws TmfTraceException {
        try {
            int ftraceVersionInt = Integer.parseInt(strVersion.trim());
            BinaryFTraceVersion ftraceVersionEnum = BinaryFTraceVersion.getVersionAsEnum(ftraceVersionInt);
            return new BinaryFTraceVersionHeader(magicValues, ftraceVersionEnum);
        }
        catch (NumberFormatException e) {
            throw new TmfTraceException("Cannot parse the magic values and FTrace version. Make sure you use trace-cmd v.2.9 and above. strVersion=" + strVersion, (Throwable)e);
        }
    }

    protected static ByteOrder getFileEndianess(BinaryFTraceByteBuffer buffer) {
        byte endianess = buffer.getNextBytes(1)[0];
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        if (endianess == 0) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        }
        return byteOrder;
    }

    protected static int getLongValueSize(BinaryFTraceByteBuffer buffer) throws TmfTraceException {
        byte longValueSize = buffer.getNextBytes(1)[0];
        if (longValueSize != 4 && longValueSize != 8) {
            throw new TmfTraceException("Invalid size for long value, must be either 4 or 8 bytes, got " + longValueSize);
        }
        return longValueSize;
    }

    protected static int getHostPageSize(BinaryFTraceByteBuffer buffer) {
        return buffer.getNextInt();
    }

    protected static List<BinaryFTraceFormatField> extractHeaderPageContent(String content) {
        String[] strFields = content.split("\n");
        return BinaryFTraceParsingUtils.parseEventFormatFields(strFields);
    }

    protected static BinaryFTraceHeaderEvent extractHeaderEventContent(String content) {
        String[] arrInfo;
        BinaryFTraceHeaderEvent.BinaryFTraceHeaderEventBuilder builder = new BinaryFTraceHeaderEvent.BinaryFTraceHeaderEventBuilder();
        String[] stringArray = arrInfo = content.split("\n");
        int n = arrInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String info = stringArray[n2];
            if (info.contains("==")) {
                keyValuePair = info.split("==");
                key = keyValuePair[0];
                int value = Integer.parseInt(keyValuePair[1].trim());
                if (key.contains("padding")) {
                    builder.paddingTypeLen(value);
                } else if (key.contains("time_extend")) {
                    builder.timeExtendedTypeLen(value);
                } else if (key.contains("time_stamp")) {
                    builder.timeStampTypeLen(value);
                } else if (key.contains("data max type_len")) {
                    builder.dataMaxTypeLen(value);
                }
            } else if (info.contains(":")) {
                keyValuePair = info.split(":");
                key = keyValuePair[0].trim();
                String value = keyValuePair[1].trim();
                int numOfBits = Integer.parseInt(value.split(" ")[0]);
                if (key.contains("type_len")) {
                    builder.typeLen(numOfBits);
                } else if (key.contains("time_delta")) {
                    builder.timeDelta(numOfBits);
                }
            }
            ++n2;
        }
        return builder.build();
    }

    protected static Map<String, BinaryFTraceFunctionAddressNameMapping> extractFunctionMappingContent(String content) {
        String[] mappings;
        HashMap<String, BinaryFTraceFunctionAddressNameMapping> hashMap = new HashMap<String, BinaryFTraceFunctionAddressNameMapping>();
        String[] stringArray = mappings = content.split("\n");
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            String mapping = stringArray[n2];
            String[] values = mapping.split(" ");
            String functionAddress = values[0];
            String functionName = values[2];
            BinaryFTraceFunctionAddressNameMapping objMapping = new BinaryFTraceFunctionAddressNameMapping(functionAddress, BinaryFTraceFunctionType.UNKNOWN, functionName);
            hashMap.put(functionAddress, objMapping);
            ++n2;
        }
        return hashMap;
    }

    protected static Map<String, String> extractPrintKContent(String content) {
        String[] arrMappings;
        HashMap<String, String> addressStringMapping = new HashMap<String, String>();
        String[] stringArray = arrMappings = content.split("\n");
        int n = arrMappings.length;
        int n2 = 0;
        while (n2 < n) {
            String mapping = stringArray[n2];
            String[] keyValuePair = mapping.split(":");
            String address = keyValuePair[0].trim();
            keyValuePair[1] = keyValuePair[1].trim();
            String mappedString = keyValuePair[1].substring(1, keyValuePair[1].length() - 1);
            addressStringMapping.put(address, mappedString);
            ++n2;
        }
        return addressStringMapping;
    }

    protected static Map<Integer, String> extractFunctionNameMapping(String content) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (!content.trim().isEmpty()) {
            String[] arrMappings;
            String[] stringArray = arrMappings = content.trim().split("\n");
            int n = arrMappings.length;
            int n2 = 0;
            while (n2 < n) {
                String mapping = stringArray[n2];
                String[] keyValuePair = mapping.split(" ");
                hashMap.put(Integer.parseInt(keyValuePair[0]), keyValuePair[1]);
                ++n2;
            }
        }
        return hashMap;
    }

    protected static List<BinaryFTraceOption> extractOptionsSection(List<Short> optionTypes, List<String> optionData) {
        ArrayList<BinaryFTraceOption> listOptions = new ArrayList<BinaryFTraceOption>();
        if (optionTypes.size() != optionData.size()) {
            return listOptions;
        }
        int i = 0;
        while (i < optionTypes.size()) {
            BinaryFTraceOption newOption = new BinaryFTraceOption(optionTypes.get(i), optionData.get(i));
            listOptions.add(newOption);
            ++i;
        }
        return listOptions;
    }

    protected static Map<Integer, BinaryFTraceEventFormat> extractTraceEventsFormat(List<String> eventFormatData) {
        HashMap<Integer, BinaryFTraceEventFormat> listEventFormats = new HashMap<Integer, BinaryFTraceEventFormat>();
        int i = 0;
        while (i < eventFormatData.size()) {
            BinaryFTraceEventFormat eventFormat = BinaryFTraceParsingUtils.parseEventFormat(eventFormatData.get(i));
            listEventFormats.put(eventFormat.getEventFormatID(), eventFormat);
            ++i;
        }
        return listEventFormats;
    }

    protected static List<BinaryFTraceEventSystem> extractEventSystemsAndFormats(Map<String, List<String>> data) {
        ArrayList<BinaryFTraceEventSystem> listEventSystems = new ArrayList<BinaryFTraceEventSystem>();
        for (Map.Entry<String, List<String>> systemData : data.entrySet()) {
            String systemName = systemData.getKey();
            Map<Integer, BinaryFTraceEventFormat> listEventFormat = AbstractBinaryFTraceFileParser.extractTraceEventsFormat(systemData.getValue());
            BinaryFTraceEventSystem eventSystem = new BinaryFTraceEventSystem(systemName, listEventFormat);
            listEventSystems.add(eventSystem);
        }
        return listEventSystems;
    }

    protected static BinaryFTraceEventFormat parseEventFormat(String content) {
        return BinaryFTraceParsingUtils.parseEventFormat(content);
    }

    protected static List<BinaryFTraceCPUDataPage> initializePages(List<Long> listTimeStamp, List<Long> listFlag, long sectionStartingOffset, long sectionSize, int pageSize, int cpuNumber) {
        int pageCount = listTimeStamp.size();
        BinaryFTraceCPUDataPage nextPage = null;
        BinaryFTraceCPUDataPage.BinaryFTraceCPUDataPageBuilder pageBuilder = new BinaryFTraceCPUDataPage.BinaryFTraceCPUDataPageBuilder();
        ArrayList<BinaryFTraceCPUDataPage> listPages = new ArrayList<BinaryFTraceCPUDataPage>();
        long pageStartingOffset = sectionStartingOffset + sectionSize - (long)pageSize;
        int i = pageCount - 1;
        while (i >= 0) {
            long timestamp = listTimeStamp.get(i);
            long flags = listFlag.get(i);
            long dataStartingOffset = pageStartingOffset + 16L;
            BinaryFTraceCPUDataPage currentPage = pageBuilder.pageStartingOffset(pageStartingOffset).pageDataStartingOffset(dataStartingOffset).timeStamp(timestamp).flags(flags).cpu(cpuNumber).nextPage(nextPage).size(pageSize).build();
            listPages.add(0, currentPage);
            nextPage = currentPage;
            pageStartingOffset -= (long)pageSize;
            --i;
        }
        return listPages;
    }

    protected static List<BinaryFTraceFileCPU> initializeCPUs(Map<Integer, List<Long>> mapTimeStamp, Map<Integer, List<Long>> mapFlag, long[] listStartingOffset, long[] listSectionSize, int pageSize) {
        ArrayList<BinaryFTraceFileCPU> listCPU = new ArrayList<BinaryFTraceFileCPU>();
        int cpuCount = listStartingOffset.length;
        int cpuNumber = 0;
        while (cpuNumber < cpuCount) {
            List<BinaryFTraceCPUDataPage> listPages = AbstractBinaryFTraceFileParser.initializePages(mapTimeStamp.get(cpuNumber), mapFlag.get(cpuNumber), listStartingOffset[cpuNumber], listSectionSize[cpuNumber], pageSize, cpuNumber);
            BinaryFTraceFileCPU cpu = new BinaryFTraceFileCPU(listStartingOffset[cpuNumber], listSectionSize[cpuNumber], cpuNumber, listPages);
            listCPU.add(cpu);
            ++cpuNumber;
        }
        return listCPU;
    }
}

