/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.nio.channels.ReadPendingException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentSourceTransformer
implements Content.Source {
    private static final Logger LOG = LoggerFactory.getLogger(ContentSourceTransformer.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
    private final Content.Source rawSource;
    private volatile Content.Chunk rawChunk;
    private volatile boolean needsRawRead;

    protected ContentSourceTransformer(Content.Source rawSource) {
        this.rawSource = rawSource;
        this.needsRawRead = true;
    }

    protected Content.Source getContentSource() {
        return this.rawSource;
    }

    private Content.Chunk beforeRead() {
        while (true) {
            State current = this.state.get();
            switch (current.type.ordinal()) {
                case 0: {
                    if (!this.state.compareAndSet(current, State.READING)) break;
                    return null;
                }
                case 1: {
                    throw new ReadPendingException();
                }
                case 2: {
                    return Content.Chunk.EOF;
                }
                case 3: {
                    throw new IllegalStateException();
                }
                case 4: {
                    return ((State.Failed)current).chunk;
                }
            }
        }
    }

    @Override
    public Content.Chunk read() {
        Content.Chunk chunk;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading {}", (Object)this);
        }
        if ((chunk = this.beforeRead()) != null) {
            return chunk;
        }
        while (true) {
            if (this.needsRawRead) {
                this.rawChunk = this.rawSource.read();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Raw chunk {} {}", (Object)this.rawChunk, (Object)this);
                }
                boolean bl = this.needsRawRead = this.rawChunk == null;
                if (this.rawChunk == null) {
                    return this.afterRead(State.Type.IDLE, null);
                }
            }
            if (Content.Chunk.isFailure(this.rawChunk)) {
                Content.Chunk failureChunk = this.rawChunk;
                Content.Chunk nextChunk = Content.Chunk.next(failureChunk);
                this.needsRawRead = nextChunk == null;
                this.afterRead(nextChunk == null ? State.Type.IDLE : State.Type.FAILED, nextChunk);
                return failureChunk;
            }
            boolean rawLast = this.rawChunk != null && this.rawChunk.isLast();
            Content.Chunk transformedChunk = this.process(this.rawChunk != null ? this.rawChunk : Content.Chunk.EMPTY);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Transformed chunk {} {}", (Object)transformedChunk, (Object)this);
            }
            if (this.rawChunk == null && (transformedChunk == null || transformedChunk == Content.Chunk.EMPTY)) {
                this.needsRawRead = true;
                continue;
            }
            if (transformedChunk == this.rawChunk) {
                this.rawChunk = null;
            }
            if (this.rawChunk != null && this.rawChunk.isEmpty()) {
                this.rawChunk.release();
                this.rawChunk = Content.Chunk.next(this.rawChunk);
            }
            if (transformedChunk != null) {
                boolean transformedLast = transformedChunk.isLast();
                boolean transformedFailure = Content.Chunk.isFailure(transformedChunk);
                if (transformedLast && !transformedFailure && !rawLast) {
                    transformedChunk = transformedChunk.isEmpty() ? Content.Chunk.EMPTY : Content.Chunk.asChunk(transformedChunk.getByteBuffer(), false, transformedChunk);
                }
                if (transformedFailure && transformedLast) {
                    return this.afterRead(State.Type.FAILED, transformedChunk);
                }
                if (rawLast && transformedLast) {
                    return this.afterRead(State.Type.EOF, transformedChunk);
                }
                return this.afterRead(State.Type.IDLE, transformedChunk);
            }
            this.needsRawRead = this.rawChunk == null;
        }
    }

    private Content.Chunk afterRead(State.Type targetType, Content.Chunk chunk) {
        while (true) {
            State current = this.state.get();
            block0 : switch (current.type.ordinal()) {
                case 0: 
                case 2: 
                case 4: {
                    throw new IllegalStateException();
                }
                case 1: {
                    switch (targetType.ordinal()) {
                        case 0: {
                            if (!this.state.compareAndSet(current, State.IDLE)) break block0;
                            return chunk;
                        }
                        case 4: {
                            if (!this.state.compareAndSet(current, new State.Failed(chunk))) break block0;
                            this.dispose(chunk.getFailure());
                            return chunk;
                        }
                        case 2: {
                            if (!this.state.compareAndSet(current, State.EOF)) break block0;
                            this.release();
                            return chunk;
                        }
                    }
                    throw new IllegalStateException();
                }
                case 3: {
                    Content.Chunk failedChunk = ((State.Failing)current).chunk;
                    Throwable failure = failedChunk.getFailure();
                    if (Content.Chunk.isFailure(chunk)) {
                        ExceptionUtil.addSuppressedIfNotAssociated((Throwable)failure, (Throwable)chunk.getFailure());
                    }
                    if (!this.state.compareAndSet(current, new State.Failed(failedChunk))) break;
                    this.dispose(failure);
                    return chunk;
                }
            }
        }
    }

    @Override
    public void demand(Runnable demandCallback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Demanding {} {}", (Object)demandCallback, (Object)this);
        }
        if (this.needsRawRead) {
            this.rawSource.demand(demandCallback);
        } else {
            ExceptionUtil.run((Runnable)demandCallback, this::fail);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fail(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failing {}", (Object)this, (Object)failure);
        }
        block4: while (true) {
            State current = this.state.get();
            switch (current.type.ordinal()) {
                case 0: {
                    if (!this.state.compareAndSet(current, new State.Failed(Content.Chunk.from(failure, true)))) continue block4;
                    this.dispose(failure);
                    return;
                }
                case 1: {
                    if (this.state.compareAndSet(current, new State.Failing(Content.Chunk.from(failure, true)))) return;
                    continue block4;
                }
            }
            break;
        }
    }

    private void dispose(Throwable failure) {
        this.rawSource.fail(failure);
        this.needsRawRead = false;
        if (this.rawChunk != null) {
            this.rawChunk.release();
        }
        this.rawChunk = Content.Chunk.from(failure, true);
        this.release();
    }

    private Content.Chunk process(Content.Chunk rawChunk) {
        try {
            return this.transform(rawChunk);
        }
        catch (Throwable x) {
            this.fail(x);
            return Content.Chunk.from(x);
        }
    }

    protected abstract Content.Chunk transform(Content.Chunk var1);

    protected void release() {
    }

    public boolean isComplete() {
        return switch (this.state.get().type.ordinal()) {
            case 2, 4 -> true;
            default -> false;
        };
    }

    public String toString() {
        return "%s@%x[state=%s,source=%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.state.get(), this.rawSource);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static class State {
        private static final State IDLE = new Idle();
        private static final State READING = new Reading();
        private static final State EOF = new EOF();
        private final Type type;

        private State(Type type) {
            this.type = type;
        }

        private static enum Type {
            IDLE,
            READING,
            EOF,
            FAILING,
            FAILED;

        }

        private static final class Idle
        extends State {
            private Idle() {
                super(Type.IDLE);
            }
        }

        private static final class Reading
        extends State {
            private Reading() {
                super(Type.READING);
            }
        }

        private static final class EOF
        extends State {
            private EOF() {
                super(Type.EOF);
            }
        }

        private static final class Failed
        extends State {
            private final Content.Chunk chunk;

            private Failed(Content.Chunk chunk) {
                super(Type.FAILED);
                this.chunk = chunk;
            }
        }

        private static final class Failing
        extends State {
            private final Content.Chunk chunk;

            private Failing(Content.Chunk chunk) {
                super(Type.FAILING);
                this.chunk = chunk;
            }
        }
    }
}

