/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.lami.core.tests.aspects;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiDurationAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiEmptyAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiIRQNameAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiIRQNumberAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiMixedAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiProcessNameAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiProcessPIDAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiProcessTIDAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTimeRangeBeginAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTimeRangeDurationAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTimeRangeEndAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTimestampAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class LamiAspectTest {
    private static final @NonNull String ASPECT_NAME = "aspect_name";

    private static @NonNull LamiTableEntry createLamiData(int i) throws JSONException {
        ArrayList<@NonNull LamiData> data = new ArrayList<LamiData>();
        Object nullObject = JSONObject.NULL;
        Assert.assertNotNull((Object)nullObject);
        data.add(LamiData.createFromObject((Object)nullObject));
        data.add(LamiData.createFromObject((Object)(i % 2 == 1 ? "hot" : "cold")));
        Boolean boolValue = i % 2 == 1;
        Assert.assertNotNull((Object)boolValue);
        data.add(LamiData.createFromObject((Object)boolValue));
        Integer intValue = i;
        Assert.assertNotNull((Object)intValue);
        data.add(LamiData.createFromObject((Object)intValue));
        Double doubleValue = i;
        Assert.assertNotNull((Object)doubleValue);
        data.add(LamiData.createFromObject((Object)doubleValue));
        String timerangeString = "{\n \"begin\": " + i + ",\n \"class\": \"time-range\",\n \"end\": " + i + "2\n}";
        data.add(LamiData.createFromObject((Object)new JSONObject(timerangeString)));
        return new LamiTableEntry(data);
    }

    @Test
    public void lamiDurationAspectTest() throws JSONException {
        LamiDurationAspect aspect = new LamiDurationAspect(ASPECT_NAME, 3);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"aspect_name (ns)", (Object)aspect.getLabel());
        Assert.assertEquals((Object)ASPECT_NAME, (Object)aspect.getName());
        Assert.assertEquals((long)0L, (long)aspect.getComparator().compare(entry1, entry2));
        Assert.assertEquals((Object)"1", (Object)aspect.resolveString(entry1));
        Assert.assertNull((Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiEmptyAspectTest() throws JSONException {
        LamiEmptyAspect aspect = LamiEmptyAspect.INSTANCE;
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"", (Object)aspect.getLabel());
        Assert.assertEquals((Object)"", (Object)aspect.getName());
        Assert.assertEquals((long)0L, (long)aspect.getComparator().compare(entry1, entry2));
        Assert.assertNull((Object)aspect.resolveString(entry1));
        Assert.assertNull((Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiGenericAspectTest() throws JSONException {
        LamiGenericAspect aspect = new LamiGenericAspect(ASPECT_NAME, "gigaTeacups", 3, true, false);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"aspect_name (gigaTeacups)", (Object)aspect.getLabel());
        Assert.assertEquals((Object)ASPECT_NAME, (Object)aspect.getName());
        Assert.assertEquals((long)-1L, (long)aspect.getComparator().compare(entry1, entry2));
        Assert.assertEquals((Object)"1", (Object)aspect.resolveString(entry1));
        Assert.assertEquals((Object)1.0, (Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiIRQNameAspectTest() throws JSONException {
        LamiIRQNameAspect aspect = new LamiIRQNameAspect(ASPECT_NAME, 3);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"aspect_name (name)", (Object)aspect.getLabel());
        Assert.assertEquals((Object)"aspect_name (name)", (Object)aspect.getName());
        Assert.assertEquals((long)-1L, (long)aspect.getComparator().compare(entry1, entry2));
        Assert.assertEquals((Object)"1", (Object)aspect.resolveString(entry1));
        Assert.assertNull((Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiIRQNumberAspectTest() throws JSONException {
        LamiIRQNumberAspect aspect = new LamiIRQNumberAspect(ASPECT_NAME, 3);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"aspect_name (#)", (Object)aspect.getLabel());
        Assert.assertEquals((Object)"aspect_name (#)", (Object)aspect.getName());
        Assert.assertEquals((long)0L, (long)aspect.getComparator().compare(entry1, entry2));
        Assert.assertEquals((Object)"1", (Object)aspect.resolveString(entry1));
        Assert.assertNull((Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiMixedAspectTest() throws JSONException {
        LamiMixedAspect aspect = new LamiMixedAspect(ASPECT_NAME, 0);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)ASPECT_NAME, (Object)aspect.getLabel());
        Assert.assertEquals((Object)ASPECT_NAME, (Object)aspect.getName());
        Assert.assertEquals((long)0L, (long)aspect.getComparator().compare(entry1, entry2));
        Assert.assertNull((Object)aspect.resolveString(entry1));
        Assert.assertNull((Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiProcessNameAspectTest() throws JSONException {
        LamiProcessNameAspect aspect = new LamiProcessNameAspect(ASPECT_NAME, 0);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"aspect_name (name)", (Object)aspect.getLabel());
        Assert.assertEquals((Object)"aspect_name (name)", (Object)aspect.getName());
        Assert.assertEquals((long)0L, (long)aspect.getComparator().compare(entry1, entry2));
        Assert.assertNull((Object)aspect.resolveString(entry1));
        Assert.assertNull((Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiProcessPIDAspectTest() throws JSONException {
        LamiProcessPIDAspect aspect = new LamiProcessPIDAspect(ASPECT_NAME, 0);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"aspect_name (PID)", (Object)aspect.getLabel());
        Assert.assertEquals((Object)"aspect_name (PID)", (Object)aspect.getName());
        Assert.assertEquals((long)0L, (long)aspect.getComparator().compare(entry1, entry2));
        Assert.assertNull((Object)aspect.resolveString(entry1));
        Assert.assertNull((Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiProcessTIDAspectTest() throws JSONException {
        LamiProcessTIDAspect aspect = new LamiProcessTIDAspect(ASPECT_NAME, 0);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"aspect_name (TID)", (Object)aspect.getLabel());
        Assert.assertEquals((Object)"aspect_name (TID)", (Object)aspect.getName());
        Assert.assertEquals((long)0L, (long)aspect.getComparator().compare(entry1, entry2));
        Assert.assertNull((Object)aspect.resolveString(entry1));
        Assert.assertNull((Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiTimeRangeBeginAspectTest() throws JSONException {
        LamiTimeRangeBeginAspect aspect = new LamiTimeRangeBeginAspect(ASPECT_NAME, 5);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"aspect_name (begin)", (Object)aspect.getLabel());
        Assert.assertEquals((Object)"aspect_name (begin)", (Object)aspect.getName());
        Assert.assertEquals((long)-1L, (long)aspect.getComparator().compare(entry1, entry2));
        String timeRangeString = aspect.resolveString(entry1);
        Assert.assertNotNull((Object)timeRangeString);
        timeRangeString = timeRangeString.substring(timeRangeString.indexOf(".") + 1, timeRangeString.length());
        Assert.assertEquals((Object)"000 000 001", (Object)timeRangeString);
        Assert.assertEquals((Object)1L, (Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiTimeRangeDurationAspectTest() throws JSONException {
        LamiTimeRangeDurationAspect aspect = new LamiTimeRangeDurationAspect(ASPECT_NAME, 5);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"aspect_name (duration) (ns)", (Object)aspect.getLabel());
        Assert.assertEquals((Object)"aspect_name (duration)", (Object)aspect.getName());
        Assert.assertEquals((long)-1L, (long)aspect.getComparator().compare(entry1, entry2));
        String timeRangeString = aspect.resolveString(entry1);
        Assert.assertNotNull((Object)timeRangeString);
        Assert.assertEquals((Object)"11", (Object)timeRangeString);
        Assert.assertEquals((Object)11L, (Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiTimeRangeEndAspectTest() throws JSONException {
        LamiTimeRangeEndAspect aspect = new LamiTimeRangeEndAspect(ASPECT_NAME, 5);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)"aspect_name (end)", (Object)aspect.getLabel());
        Assert.assertEquals((Object)"aspect_name (end)", (Object)aspect.getName());
        Assert.assertEquals((long)-1L, (long)aspect.getComparator().compare(entry1, entry2));
        String timeRangeString = aspect.resolveString(entry1);
        Assert.assertNotNull((Object)timeRangeString);
        timeRangeString = timeRangeString.substring(timeRangeString.indexOf(".") + 1, timeRangeString.length());
        Assert.assertEquals((Object)"000 000 012", (Object)timeRangeString);
        Assert.assertEquals((Object)12L, (Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void lamiTimestampAspectTest() throws JSONException {
        LamiTimestampAspect aspect = new LamiTimestampAspect(ASPECT_NAME, 0);
        LamiTableEntry entry1 = LamiAspectTest.createLamiData(1);
        LamiTableEntry entry2 = LamiAspectTest.createLamiData(2);
        Assert.assertEquals((Object)ASPECT_NAME, (Object)aspect.getLabel());
        Assert.assertEquals((Object)ASPECT_NAME, (Object)aspect.getName());
        Assert.assertEquals((long)0L, (long)aspect.getComparator().compare(entry1, entry2));
        Assert.assertNull((Object)aspect.resolveString(entry1));
        Assert.assertNull((Object)aspect.resolveNumber(entry1));
    }

    @Test
    public void testAspectEquality() {
        LamiTimestampAspect aspect1 = new LamiTimestampAspect(ASPECT_NAME, 0);
        LamiTimeRangeEndAspect aspect2 = new LamiTimeRangeEndAspect(ASPECT_NAME, 5);
        LamiProcessTIDAspect aspect3 = new LamiProcessTIDAspect(ASPECT_NAME, 0);
        Assert.assertTrue((boolean)aspect1.arePropertiesEqual((LamiTableEntryAspect)aspect1));
        Assert.assertTrue((boolean)aspect1.arePropertiesEqual((LamiTableEntryAspect)aspect2));
        Assert.assertFalse((boolean)aspect1.arePropertiesEqual((LamiTableEntryAspect)aspect3));
        Assert.assertTrue((boolean)aspect2.arePropertiesEqual((LamiTableEntryAspect)aspect1));
        Assert.assertTrue((boolean)aspect2.arePropertiesEqual((LamiTableEntryAspect)aspect2));
        Assert.assertFalse((boolean)aspect2.arePropertiesEqual((LamiTableEntryAspect)aspect3));
        Assert.assertFalse((boolean)aspect3.arePropertiesEqual((LamiTableEntryAspect)aspect1));
        Assert.assertFalse((boolean)aspect3.arePropertiesEqual((LamiTableEntryAspect)aspect2));
        Assert.assertTrue((boolean)aspect3.arePropertiesEqual((LamiTableEntryAspect)aspect3));
    }
}

