/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.latency;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.latency.KernelCtfTraceStub;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.SystemCallLatencyAnalysis;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyscallAnalysisTest {
    private ITmfTrace fTestTrace;
    private SystemCallLatencyAnalysis fSyscallModule;

    @Before
    public void setUp() {
        KernelCtfTraceStub trace = KernelCtfTraceStub.getTrace(CtfTestTrace.ARM_64_BIT_HEADER);
        this.fTestTrace = trace;
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        for (IAnalysisModule mod : TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, SystemCallLatencyAnalysis.class)) {
            this.fSyscallModule = (SystemCallLatencyAnalysis)mod;
        }
        Assert.assertNotNull((Object)this.fSyscallModule);
        this.fSyscallModule.schedule();
        this.fSyscallModule.waitForCompletion();
    }

    @After
    public void cleanup() {
        ITmfTrace testTrace = this.fTestTrace;
        if (testTrace != null) {
            testTrace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testSmallTraceSequential() {
        SystemCallLatencyAnalysis syscallModule = this.fSyscallModule;
        Assert.assertNotNull((Object)syscallModule);
        @NonNull ISegmentStore segmentStore = syscallModule.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        Assert.assertEquals((long)1801L, (long)segmentStore.size());
    }
}

