/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands;

import com.google.common.collect.ImmutableList;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.IRelayResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.SessionResponse;

public class ListSessionsResponse
implements IRelayResponse {
    public static final int PACKET_FIXED_SIZE = 4;
    private final List<SessionResponse> fSessionList;

    public ListSessionsResponse(DataInputStream inNet) throws IOException {
        byte[] data = new byte[4];
        inNet.readFully(data);
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.BIG_ENDIAN);
        int nbSessions = bb.getInt();
        ImmutableList.Builder sl = new ImmutableList.Builder();
        int session = 0;
        while (session < nbSessions) {
            sl.add((Object)new SessionResponse(inNet));
            ++session;
        }
        this.fSessionList = sl.build();
    }

    public List<SessionResponse> getSessionsList() {
        return this.fSessionList;
    }
}

