/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.StubPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class TimeGraphViewWithTooManyMarkersStub
extends AbstractTimeGraphView {
    private static final int NB_MARKERS = 1000;
    private static final int MARKER_STEP = 30;
    private static final int NB_ENTRIES = 1000;
    public static final String ID = "org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.timegraph.stub2";
    private static final String MARKER_GROUP = "sample";
    private final List<@NonNull TimeGraphEntry> fEntries = new ArrayList<TimeGraphEntry>();

    public TimeGraphViewWithTooManyMarkersStub() {
        super(ID, (TimeGraphPresentationProvider)new StubPresentationProvider());
        int i = 0;
        while (i < 1000) {
            this.fEntries.add(new TimeGraphEntry(String.format("entry %d", i), 0L, 1000L));
            ++i;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void buildEntryList(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, @NonNull IProgressMonitor monitor) {
        @NonNull List entryList = this.getEntryList(parentTrace);
        if (entryList == null || entryList.isEmpty()) {
            this.addToEntryList(parentTrace, this.fEntries);
        }
        this.refresh();
    }

    protected @NonNull List<String> getMarkerCategories() {
        return Collections.singletonList(MARKER_GROUP);
    }

    protected @NonNull List<IMarkerEvent> getViewMarkerList(Iterable<@NonNull TimeGraphEntry> entries, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptyList();
        }
        RGBA fromInt = new RGBA(0, 0, 0, 255);
        long start = trace.getStartTime().toNanos();
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        for (TimeGraphEntry row : entries) {
            int rowId = this.fEntries.indexOf(row);
            int offset = (int)(15.0 * Math.sin((double)rowId * Math.PI / 30.0)) + 15;
            long i = 0L;
            while (i < 1000L) {
                long time = start + i + (long)offset;
                if (time >= startTime && time <= endTime) {
                    markers.add((IMarkerEvent)new MarkerEvent((ITimeGraphEntry)row, time, 0L, "", fromInt, "", true, rowId / 30 % 7));
                }
                i += 30L;
            }
        }
        return markers;
    }
}

