/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.jsontrace.core.job;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.internal.jsontrace.core.Messages;
import org.eclipse.tracecompass.internal.provisional.jsontrace.core.trace.JsonTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class SortingJob
extends Job {
    private static final char CLOSE_BRACKET = ']';
    private static final char OPEN_BRACKET = '[';
    private static final int CHARS_PER_LINE_ESTIMATE = 50;
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(SortingJob.class);
    private static final int CHUNK_SIZE = 65535;
    private static final int METADATA_MAX_SIZE = 10000000;
    private static final Comparator<PartiallyParsedEvent> EVENT_COMPARATOR = Comparator.comparing(PartiallyParsedEvent::getTs);
    private final Integer fBracketsToSkip;
    private final String fTsKey;
    private final String fPath;
    private final List<String> fPathToEvents;
    private String fMetadata;
    private final ITmfTrace fTrace;

    protected SortingJob(ITmfTrace trace, String path, String tsKey, int bracketsToSkip) {
        super(Messages.SortingJob_description);
        this.fTrace = trace;
        this.fPath = path;
        this.fTsKey = tsKey;
        this.fBracketsToSkip = bracketsToSkip;
        this.fPathToEvents = Collections.emptyList();
    }

    protected SortingJob(ITmfTrace trace, String path, String tsKey, List<String> pathToEvents) {
        super(Messages.SortingJob_description);
        this.fTrace = trace;
        this.fPath = path;
        this.fTsKey = tsKey;
        this.fBracketsToSkip = -1;
        this.fPathToEvents = pathToEvents;
    }

    public String getPath() {
        return this.fPath;
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IStatus goToEventArray(BufferedInputStream parser, IProgressMonitor monitor) throws IOException {
        if (this.fBracketsToSkip >= 0) {
            return this.goToEventArrayBracket(parser);
        }
        if (!this.fPathToEvents.isEmpty()) {
            return this.goToEventArrayPath(parser, monitor);
        }
        return null;
    }

    private IStatus goToEventArrayBracket(BufferedInputStream parser) throws IOException {
        int data = 0;
        int nbBracket = 0;
        while (nbBracket < this.fBracketsToSkip) {
            data = parser.read();
            while (data != 91) {
                data = parser.read();
                if (data != -1) continue;
                return new Status(4, "org.eclipse.tracecompass.jsontrace.core", "Missing symbol '[' or ']' in " + this.fPath);
            }
            ++nbBracket;
        }
        return null;
    }

    private IStatus goToEventArrayPath(BufferedInputStream parser, IProgressMonitor monitor) throws IOException {
        JsonFactory factory = new JsonFactory();
        long byteOffset = 0L;
        Throwable throwable = null;
        Object var7_7 = null;
        try (JsonParser jsonParser = factory.createParser(new File(this.fPath));){
            int depth = 0;
            while (!jsonParser.isClosed() && jsonParser.currentLocation().getByteOffset() < 10000000L) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                JsonToken token = jsonParser.nextToken();
                if (token != JsonToken.FIELD_NAME) continue;
                String fieldName = jsonParser.currentName();
                if (fieldName.equals(this.fPathToEvents.get(depth)) && ++depth == this.fPathToEvents.size()) break;
                jsonParser.nextToken();
            }
            byteOffset = jsonParser.currentLocation().getByteOffset();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.fMetadata = new String(parser.readNBytes((int)byteOffset), StandardCharsets.UTF_8) + "]";
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private IStatus splitTrace(BufferedInputStream parser, IProgressMonitor monitor, File tempDirectory, List<File> tracelings) throws IOException {
        data = 0;
        events = new ArrayList<PartiallyParsedEvent>(65535);
        eventString = JsonTrace.readNextEventString((JsonTrace.IReaderWrapper)LambdaMetafactory.metafactory(null, null, null, ()I, read(), ()I)((BufferedInputStream)parser));
        if (eventString == null) {
            return new Status(4, "org.eclipse.tracecompass.jsontrace.core", "Empty event in " + this.fPath);
        }
        line = new PartiallyParsedEvent(this.fTsKey, eventString, 0);
        line.fLine = data + 34 + line.fLine;
        cnt = 0;
        filen = 0;
        ** GOTO lbl61
        {
            events.add(line);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            eventString = JsonTrace.readNextEventString((JsonTrace.IReaderWrapper)LambdaMetafactory.metafactory(null, null, null, ()I, read(), ()I)((BufferedInputStream)parser));
            if (eventString == null) ** GOTO lbl25
            line = new PartiallyParsedEvent(this.fTsKey, eventString, 0);
            ++cnt;
            do {
                if (cnt < 65535) continue block5;
lbl25:
                // 2 sources

                events.sort(SortingJob.EVENT_COMPARATOR);
                cnt = 0;
                traceling = new File(String.valueOf(tempDirectory) + File.separator + "test" + filen + ".json");
                tracelings.add(traceling);
                success = traceling.createNewFile();
                if (!success) {
                    return new Status(4, "org.eclipse.tracecompass.jsontrace.core", "Could not create partial file " + traceling.getAbsolutePath());
                }
                var15_13 = null;
                var16_15 = null;
                try {
                    fs = new PrintWriter(traceling);
                    try {
                        fs.println('[');
                        for (PartiallyParsedEvent sortedEvent : events) {
                            fs.println(sortedEvent.fLine + ",");
                        }
                        fs.println(']');
                    }
                    finally {
                        if (fs != null) {
                            fs.close();
                        }
                    }
                }
                catch (Throwable var16_16) {
                    if (var15_13 == null) {
                        var15_13 = var16_16;
                    } else if (var15_13 != var16_16) {
                        var15_13.addSuppressed(var16_16);
                    }
                    throw var15_13;
                }
                events.clear();
                ++filen;
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
lbl61:
                // 2 sources

            } while (eventString != null);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private IStatus mergeChunks(IProgressMonitor monitor, List<File> tracelings, File resultTrace) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 22[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void processMetadata(ITmfTrace trace, String dir, BufferedInputStream parser) throws IOException {
        this.processMetadata(trace, dir);
        this.processMetadataJson(trace, this.fMetadata);
    }

    protected void processMetadataJson(ITmfTrace trace, String metadata) {
    }

    protected abstract void processMetadata(ITmfTrace var1, String var2) throws IOException;

    private static @Nullable PartiallyParsedEvent readNextEvent(BufferedInputStream parser, String key, int i) throws IOException {
        String event = JsonTrace.readNextEventString(parser::read);
        return event == null ? null : new PartiallyParsedEvent(key, event, i);
    }

    private static final class PartiallyParsedEvent {
        private static final @NonNull BigDecimal MINUS_ONE = BigDecimal.valueOf(-1L);
        private final BigDecimal fTs;
        private String fLine;
        private final int fPos;

        public PartiallyParsedEvent(String key, String string, int i) {
            this.fLine = string;
            int indexOf = string.indexOf(key);
            this.fPos = i;
            if (indexOf < 0) {
                this.fTs = MINUS_ONE;
            } else {
                BigDecimal ts;
                String number;
                int index = indexOf + key.length();
                int end = string.indexOf(44, index);
                if (end == -1) {
                    end = string.indexOf(125, index);
                }
                if (!(number = string.substring(index, end).trim().replace("\"", "")).isEmpty()) {
                    try {
                        ts = new BigDecimal(number);
                    }
                    catch (NumberFormatException e) {
                        ts = MINUS_ONE;
                    }
                } else {
                    ts = MINUS_ONE;
                }
                this.fTs = ts;
            }
        }

        public BigDecimal getTs() {
            return this.fTs;
        }
    }
}

