/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.property;

import java.util.ArrayList;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.BasePropertySource;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class BaseEventPropertySource
extends BasePropertySource {
    public static final String BASE_EVENT_NAME_PROPERTY_ID = "base.event.name";
    public static final String BASE_EVENT_TYPE_PROPERTY_ID = "base.event.type";
    public static final String BASE_EVENT_LOGLEVEL_PROPERTY_ID = "base.event.loglevel";
    public static final String BASE_EVENT_FIELDS_PROPERTY_ID = "base.event.fields";
    public static final String BASE_EVENT_NAME_PROPERTY_NAME = Messages.TraceControl_EventNamePropertyName;
    public static final String BASE_EVENT_TYPE_PROPERTY_NAME = Messages.TraceControl_EventTypePropertyName;
    public static final String BASE_EVENT_LOGLEVEL_PROPERTY_NAME = Messages.TraceControl_LogLevelPropertyName;
    public static final String BASE_EVENT_FIELDS_PROPERTY_NAME = Messages.TraceControl_FieldsPropertyName;
    private final BaseEventComponent fBaseEvent;

    public BaseEventPropertySource(BaseEventComponent component) {
        this.fBaseEvent = component;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<ReadOnlyTextPropertyDescriptor> list = new ArrayList<ReadOnlyTextPropertyDescriptor>();
        list.add(new ReadOnlyTextPropertyDescriptor((Object)BASE_EVENT_NAME_PROPERTY_ID, BASE_EVENT_NAME_PROPERTY_NAME));
        list.add(new ReadOnlyTextPropertyDescriptor((Object)BASE_EVENT_TYPE_PROPERTY_ID, BASE_EVENT_TYPE_PROPERTY_NAME));
        if (this.fBaseEvent.getLogLevel() != TraceLogLevel.LEVEL_UNKNOWN) {
            list.add(new ReadOnlyTextPropertyDescriptor((Object)BASE_EVENT_LOGLEVEL_PROPERTY_ID, BASE_EVENT_LOGLEVEL_PROPERTY_NAME));
        }
        if (this.fBaseEvent.getFieldString() != null) {
            list.add(new ReadOnlyTextPropertyDescriptor((Object)BASE_EVENT_FIELDS_PROPERTY_ID, BASE_EVENT_FIELDS_PROPERTY_NAME));
        }
        return list.toArray(new IPropertyDescriptor[list.size()]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (BASE_EVENT_NAME_PROPERTY_ID.equals(id)) {
            return this.fBaseEvent.getName();
        }
        if (BASE_EVENT_TYPE_PROPERTY_ID.equals(id)) {
            return this.fBaseEvent.getEventType().name();
        }
        if (BASE_EVENT_LOGLEVEL_PROPERTY_ID.equals(id)) {
            return this.fBaseEvent.getLogLevel().name();
        }
        if (BASE_EVENT_FIELDS_PROPERTY_ID.equals(id)) {
            return this.fBaseEvent.getFieldString();
        }
        return null;
    }
}

