/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;

public final class FactoryRegistry {
    private List factories;

    FactoryRegistry() {
    }

    private List _getFactories() {
        if (this.factories == null) {
            this.factories = new ArrayList();
        }
        return this.factories;
    }

    public void addFactory(INodeAdapterFactory factory) {
        this._getFactories().add(factory);
    }

    public void clearFactories() {
        this.factories.clear();
    }

    public boolean contains(Object type) {
        boolean result = false;
        List internalList = this._getFactories();
        int i = 0;
        while (i < internalList.size()) {
            INodeAdapterFactory factory = (INodeAdapterFactory)internalList.get(i);
            if (factory.isFactoryForType(type)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public List getFactories() {
        ArrayList factoryList = new ArrayList(this._getFactories());
        return factoryList;
    }

    public INodeAdapterFactory getFactoryFor(Object type) {
        INodeAdapterFactory result = null;
        if (this.factories == null) {
            return null;
        }
        int listSize = this.factories.size();
        int i = listSize - 1;
        while (i >= 0) {
            INodeAdapterFactory a = (INodeAdapterFactory)this.factories.get(i);
            if (a.isFactoryForType(type)) {
                result = a;
                break;
            }
            --i;
        }
        return result;
    }

    public void release() {
        List localList = this.getFactories();
        int i = 0;
        while (i < localList.size()) {
            INodeAdapterFactory a = (INodeAdapterFactory)localList.get(i);
            try {
                a.release();
            }
            catch (Exception e) {
                Logger.logException("Program problem releasing factory" + a, e);
            }
            ++i;
        }
    }

    public void removeFactoriesFor(Object type) {
        if (this.factories != null) {
            int listSize = this.factories.size();
            int i = listSize - 1;
            while (i >= 0) {
                INodeAdapterFactory a = (INodeAdapterFactory)this.factories.get(i);
                if (a.isFactoryForType(type)) {
                    this.factories.remove(a);
                }
                --i;
            }
        }
    }

    public void removeFactory(INodeAdapterFactory factory) {
        this._getFactories().remove(factory);
    }
}

