/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.viewers.xychart;

import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.model.CartesianSeriesModel;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IXYSeries;

public class XYSeries
implements IXYSeries {
    private final ISeries<Integer> fSeries;

    public static @Nullable XYSeries create(Object series) {
        if (series instanceof ISeries) {
            return new XYSeries((ISeries<Integer>)((ISeries)series));
        }
        return null;
    }

    private XYSeries(ISeries<Integer> series) {
        this.fSeries = series;
    }

    @Override
    public String getId() {
        return this.fSeries.getId();
    }

    @Override
    public boolean isVisible() {
        return this.fSeries.isVisible();
    }

    @Override
    public double[] getXSeries() {
        CartesianSeriesModel dataModel = this.fSeries.getDataModel();
        if (dataModel == null) {
            return new double[0];
        }
        return StreamSupport.stream(dataModel.spliterator(), false).filter(t -> dataModel.getX(t) != null).mapToDouble(value -> dataModel.getX(value).doubleValue()).toArray();
    }

    @Override
    public double[] getYSeries() {
        CartesianSeriesModel dataModel = this.fSeries.getDataModel();
        if (dataModel == null) {
            return new double[0];
        }
        return StreamSupport.stream(dataModel.spliterator(), false).filter(t -> dataModel.getY(t) != null).mapToDouble(value -> dataModel.getY(value).doubleValue()).toArray();
    }

    @Override
    public @Nullable Color getColor() {
        if (this.fSeries instanceof IBarSeries) {
            return ((IBarSeries)this.fSeries).getBarColor();
        }
        if (this.fSeries instanceof ILineSeries) {
            return ((ILineSeries)this.fSeries).getLineColor();
        }
        return null;
    }
}

