/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.KernelEventLayoutStub;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class StubEventMatching
implements ITmfMatchEventDefinition {
    public @Nullable IEventMatchingKey getEventKey(@Nullable ITmfEvent event) {
        if (event == null) {
            return null;
        }
        Integer fieldValue = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"msgid"});
        if (fieldValue == null) {
            return null;
        }
        return new StubEventKey(fieldValue);
    }

    public boolean canMatchTrace(@Nullable ITmfTrace trace) {
        return trace instanceof TmfXmlKernelTraceStub;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TmfEventMatching.Direction getDirection(@Nullable ITmfEvent event) {
        if (event == null) {
            return null;
        }
        String evname = event.getName();
        if (KernelEventLayoutStub.getInstance().eventsNetworkReceive().contains(evname)) {
            return TmfEventMatching.Direction.EFFECT;
        }
        if (KernelEventLayoutStub.getInstance().eventsNetworkSend().contains(evname)) {
            return TmfEventMatching.Direction.CAUSE;
        }
        return null;
    }

    protected static class StubEventKey
    implements IEventMatchingKey {
        private final int fMsgId;

        public StubEventKey(int msgId) {
            this.fMsgId = msgId;
        }

        public int hashCode() {
            return Objects.hash(this.fMsgId);
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof StubEventKey) {
                StubEventKey key = (StubEventKey)o;
                return key.fMsgId == this.fMsgId;
            }
            return false;
        }
    }
}

