/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string.EncodingParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class StringDeclarationParser
implements ICommonTreeParser {
    public static final StringDeclarationParser INSTANCE = new StringDeclarationParser();
    private static final @NonNull String ENCODING = "encoding";

    private StringDeclarationParser() {
    }

    @Override
    public StringDeclaration parse(ICTFMetadataNode string, ICommonTreeParser.ICommonTreeParserParameter unused) throws ParseException {
        List<ICTFMetadataNode> children = string.getChildren();
        StringDeclaration stringDeclaration = null;
        if (string instanceof JsonStructureFieldMemberMetadataNode || children == null) {
            stringDeclaration = StringDeclaration.getStringDeclaration(Encoding.UTF8);
        } else {
            Encoding encoding = Encoding.UTF8;
            for (ICTFMetadataNode child : children) {
                String type = child.getType();
                if (CTFParser.tokenNames[86].equals(type)) {
                    ICTFMetadataNode leftNode = child.getChild(0);
                    ICTFMetadataNode rightNode = child.getChild(1);
                    List<ICTFMetadataNode> leftStrings = leftNode.getChildren();
                    if (!TsdlUtils.isAnyUnaryString(leftStrings.get(0))) {
                        throw new ParseException("Left side of ctf expression must be a string");
                    }
                    String left = TsdlUtils.concatenateUnaryStrings(leftStrings);
                    if (left.equals(ENCODING)) {
                        encoding = EncodingParser.INSTANCE.parse(rightNode, null);
                        continue;
                    }
                    throw new ParseException("String: unknown attribute " + left);
                }
                throw TsdlUtils.childTypeError(child);
            }
            stringDeclaration = StringDeclaration.getStringDeclaration(encoding);
        }
        return stringDeclaration;
    }
}

