/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.protocol.unknown;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class UnknownPacketTest {
    private static final Map<String, String> EXPECTED_FIELDS = ImmutableMap.of((Object)"Binary", (Object)"00 01 02 31 32 33 41 42 43 61 62 63 fd fe ff", (Object)"Character", (Object)"\u00b7\u00b7\u00b7123ABCabc\u00b7\u00b7\u00b7");
    private static final String fToString = "Payload: 00 01 02 31 32 33 41 42 43 61 62 63 fd fe ff";
    private ByteBuffer fPacket;

    @Before
    public void initialize() {
        this.fPacket = ByteBuffer.allocate(15);
        this.fPacket.order(ByteOrder.BIG_ENDIAN);
        this.fPacket.put((byte)0);
        this.fPacket.put((byte)1);
        this.fPacket.put((byte)2);
        this.fPacket.put((byte)49);
        this.fPacket.put((byte)50);
        this.fPacket.put((byte)51);
        this.fPacket.put((byte)65);
        this.fPacket.put((byte)66);
        this.fPacket.put((byte)67);
        this.fPacket.put((byte)97);
        this.fPacket.put((byte)98);
        this.fPacket.put((byte)99);
        this.fPacket.put((byte)-3);
        this.fPacket.put((byte)-2);
        this.fPacket.put((byte)-1);
        this.fPacket.flip();
    }

    @Test
    public void CompleteUnknownPacketTest() throws IOException, BadPcapFileException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapFile dummy = trace.getTrace();){
            ByteBuffer byteBuffer = this.fPacket;
            if (byteBuffer == null) {
                Assert.fail((String)"CompleteUnknownPacketTest has failed!");
                return;
            }
            UnknownPacket packet = new UnknownPacket(dummy, null, byteBuffer);
            Assert.assertEquals((Object)PcapProtocol.UNKNOWN, (Object)packet.getProtocol());
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.UNKNOWN));
            Assert.assertFalse((boolean)packet.hasProtocol(PcapProtocol.UDP));
            Assert.assertTrue((boolean)packet.validate());
            Assert.assertFalse((boolean)packet.equals(null));
            Assert.assertEquals((Object)new UnknownPacket(dummy, null, byteBuffer), (Object)packet);
            Assert.assertEquals((long)new UnknownPacket(dummy, null, byteBuffer).hashCode(), (long)packet.hashCode());
            Assert.assertEquals(EXPECTED_FIELDS, (Object)packet.getFields());
            Assert.assertEquals((Object)fToString, (Object)packet.toString());
            Assert.assertEquals((Object)"Len: 15 bytes", (Object)packet.getLocalSummaryString());
            Assert.assertEquals((Object)"Data: 15 bytes", (Object)packet.getGlobalSummaryString());
            Assert.assertFalse((boolean)packet.getSourceEndpoint().equals((Object)new UnknownEndpoint(packet, true)));
            Assert.assertFalse((boolean)packet.getDestinationEndpoint().equals((Object)new UnknownEndpoint(packet, false)));
            this.fPacket.position(0);
            byte[] payload = new byte[15];
            this.fPacket.get(payload);
            ByteBuffer payloadBB = ByteBuffer.wrap(payload);
            payloadBB.flip();
            Assert.assertEquals((Object)payloadBB, (Object)packet.getPayload());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

