/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.BlockIO;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.DiskWriteModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IoOperationType;

public class Request {
    private Long fSector;
    private int fNrSector;
    private final DiskWriteModel fDisk;
    private final List<BlockIO> fBios = new ArrayList<BlockIO>();
    private @Nullable Integer fIssuedFrom = null;
    private IoOperationType fType;

    public Request(DiskWriteModel disk, Long sector, int rwbs) {
        this.fSector = sector;
        this.fNrSector = 0;
        this.fDisk = disk;
        this.fType = IoOperationType.getType(rwbs);
    }

    public Request(BlockIO bio) {
        this.fSector = bio.getSector();
        this.fNrSector = bio.getNrSector();
        this.fType = bio.getType();
        this.fBios.add(0, bio);
        this.fDisk = bio.getDisk();
    }

    public Long getSector() {
        return this.fSector;
    }

    public int getNrSector() {
        return this.fNrSector;
    }

    public void setNrSector(int nrSector) {
        this.fNrSector = nrSector;
    }

    public DiskWriteModel getDisk() {
        return this.fDisk;
    }

    public IoOperationType getType() {
        return this.fType;
    }

    public void setType(int rwbs) {
        this.fType = IoOperationType.getType(rwbs);
    }

    public List<BlockIO> getBios() {
        return Collections.unmodifiableList(this.fBios);
    }

    public @Nullable Integer getIssuedFrom() {
        return this.fIssuedFrom;
    }

    public void insertBio(BlockIO bio) {
        this.fBios.add(bio);
        this.fNrSector += bio.getNrSector();
        if (bio.getSector() < this.getSector()) {
            this.fSector = bio.getSector();
        }
    }

    public void mergeRequest(Request request) {
        this.fBios.addAll(request.getBios());
        this.fNrSector = this.getNrSector() + request.getNrSector();
    }

    public boolean includes(Request request) {
        return this.getType() == request.getType() && this.getSector() <= request.getSector() && this.getSector() + (long)this.getNrSector() >= request.getSector() + (long)request.getNrSector();
    }
}

