/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console.ansi.participants;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.internal.console.ansi.participants.AnsiConsoleStyleListener;
import org.eclipse.ui.part.IPageBookViewPage;

public class AnsiConsolePageParticipant
implements IConsolePageParticipant {
    private static final Map<StyledText, IConsolePageParticipant> viewers = new HashMap<StyledText, IConsolePageParticipant>();

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @Override
    public void activated() {
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void dispose() {
        this.removeViewerWithPageParticipant(this);
    }

    @Override
    public void init(IPageBookViewPage page, IConsole console) {
        if (page.getControl() instanceof StyledText) {
            StyledText viewer = (StyledText)page.getControl();
            IDocument document = AnsiConsolePageParticipant.getDocument(viewer);
            if (document == null) {
                return;
            }
            AnsiConsoleStyleListener myListener = new AnsiConsoleStyleListener(document);
            viewer.addLineStyleListener((LineStyleListener)myListener);
            this.addViewer(viewer, this);
        }
    }

    static IDocument getDocument(StyledText viewer) {
        Listener[] listenerArray = viewer.getListeners(3002);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTEventListener evenListener;
            Listener listener = listenerArray[n2];
            if (listener instanceof TypedListener && (evenListener = ((TypedListener)listener).getEventListener()) instanceof ITextViewer) {
                return ((ITextViewer)evenListener).getDocument();
            }
            ++n2;
        }
        return null;
    }

    private void addViewer(StyledText viewer, IConsolePageParticipant participant) {
        viewers.put(viewer, participant);
    }

    private void removeViewerWithPageParticipant(IConsolePageParticipant participant) {
        HashSet<StyledText> toRemove = new HashSet<StyledText>();
        for (Map.Entry<StyledText, IConsolePageParticipant> entry : viewers.entrySet()) {
            if (entry.getValue() != participant) continue;
            toRemove.add(entry.getKey());
        }
        for (StyledText viewer : toRemove) {
            viewers.remove(viewer);
        }
    }
}

