/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.repository;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.gpg.keybox.KeyBlob;
import org.bouncycastle.gpg.keybox.PublicKeyRingBlob;
import org.bouncycastle.gpg.keybox.jcajce.JcaKeyBox;
import org.bouncycastle.gpg.keybox.jcajce.JcaKeyBoxBuilder;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.repository.helpers.DebugHelper;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;

public class DefaultPGPPublicKeyService
extends PGPPublicKeyService {
    private static final boolean DEBUG_KEY_SERVICE = DebugHelper.DEBUG_KEY_SERVICE || Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("p2.keyserver.debug"));
    private static final String KEY_SERVERS_PROPERTY = "p2.keyservers";
    private static final String GPG_HOME_PROPERTY = "p2.gpg.home";
    private static final String GPG_PROPERTY = "p2.gpg";
    private static final long STALE_AFTER_MILLIS = Long.getLong("p2.keyserver.cache.stale", 24L) * 1000L * 60L * 60L;
    private final Transport transport;
    private final Map<Long, LocalKeyCache> localKeys = new LinkedHashMap<Long, LocalKeyCache>();
    private final Path keyCache;
    private final Map<String, PGPKeyServer> keyServers = new LinkedHashMap<String, PGPKeyServer>();
    private boolean gpg;

    public DefaultPGPPublicKeyService(IProvisioningAgent agent) {
        String keyServersProperty;
        IAgentLocation agentLocation = (IAgentLocation)agent.getService(IAgentLocation.class);
        URI dataArea = agentLocation.getDataArea("org.eclipse.equinox.p2.repository");
        this.keyCache = Paths.get(dataArea).resolve("pgp");
        try {
            Files.createDirectories(this.keyCache, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (DEBUG_KEY_SERVICE) {
            DebugHelper.debug("KeyServer", "Cache", "location", this.keyCache);
        }
        if (!(keyServersProperty = System.getProperty(KEY_SERVERS_PROPERTY, "")).isBlank()) {
            LinkedHashSet<String> keyServersSet = new LinkedHashSet<String>();
            String[] stringArray = keyServersProperty.split("[,; \t]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyServer = stringArray[n2];
                if (!keyServer.isEmpty()) {
                    keyServersSet.add(keyServer);
                }
                ++n2;
            }
            this.setKeyServers(keyServersSet);
        }
        this.setGPG(Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty(GPG_PROPERTY, Boolean.TRUE.toString())) || !System.getProperty(GPG_HOME_PROPERTY, "").isBlank());
        this.transport = (Transport)agent.getService(Transport.class);
    }

    public Set<String> getKeyServers() {
        return Collections.unmodifiableSet(this.keyServers.keySet());
    }

    public void setKeyServers(Set<String> keyServers) {
        LinkedHashMap<String, PGPKeyServer> newKeyServers = new LinkedHashMap<String, PGPKeyServer>();
        for (String keyServer : keyServers) {
            PGPKeyServer pgpKeyServer = this.keyServers.get(keyServer);
            if (pgpKeyServer == null) {
                pgpKeyServer = new PGPKeyServer(keyServer, this.keyCache){

                    @Override
                    protected boolean isStale(Path path) {
                        return DefaultPGPPublicKeyService.this.isStale(path);
                    }

                    @Override
                    protected IStatus download(URI uri, OutputStream receiver, IProgressMonitor monitor) {
                        return DefaultPGPPublicKeyService.this.download(uri, receiver, monitor);
                    }

                    @Override
                    protected void log(Throwable throwable) {
                        DefaultPGPPublicKeyService.this.log(throwable);
                    }
                };
            }
            newKeyServers.put(keyServer, pgpKeyServer);
        }
        this.keyServers.clear();
        this.keyServers.putAll(newKeyServers);
    }

    @Override
    public PGPPublicKey getKey(String fingerprint) {
        int length = fingerprint.length();
        if (length >= 16) {
            long keyID = Long.parseUnsignedLong(fingerprint.substring(length - 16, length), 16);
            Collection<PGPPublicKey> keys = this.getKeys(keyID);
            for (PGPPublicKey key : keys) {
                if (!DefaultPGPPublicKeyService.toHexFingerprint(key).equalsIgnoreCase(fingerprint)) continue;
                return key;
            }
        }
        return null;
    }

    @Override
    public Collection<PGPPublicKey> getKeys(long keyID) {
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>();
        for (PGPKeyServer keyServer : this.keyServers.values()) {
            keys.addAll(keyServer.getKeys(keyID));
        }
        keys.addAll(this.getLocalKeyCache(keyID).get());
        keys.addAll(this.getDefaultKeys(keyID));
        return this.reconcileKeys(keys);
    }

    public boolean isGGP() {
        return this.gpg;
    }

    public void setGPG(boolean gpg) {
        this.gpg = gpg;
    }

    protected List<PGPPublicKey> getDefaultKeys(long keyID) {
        return this.gpg ? DefaultPGPPublicKeyService.getGPGPubringKeys(keyID) : Collections.emptyList();
    }

    protected List<PGPPublicKey> reconcileKeys(List<PGPPublicKey> keys) {
        if (keys.size() <= 1) {
            return new ArrayList<PGPPublicKey>(keys);
        }
        LinkedHashMap<ByteBuffer, PGPPublicKey> encodings = new LinkedHashMap<ByteBuffer, PGPPublicKey>();
        LinkedHashMap<ByteBuffer, PGPPublicKey> fingerprints = new LinkedHashMap<ByteBuffer, PGPPublicKey>();
        for (PGPPublicKey key : keys) {
            try {
                ByteBuffer fingerprint;
                PGPPublicKey otherKey;
                ByteBuffer encoding = ByteBuffer.wrap(key.getEncoded());
                PGPPublicKey existingKey = encodings.put(encoding, key);
                if (existingKey != null || (otherKey = fingerprints.put(fingerprint = ByteBuffer.wrap(key.getFingerprint()), key)) == null) continue;
                fingerprints.put(fingerprint, this.choose(otherKey, key));
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        return new ArrayList<PGPPublicKey>(fingerprints.values());
    }

    protected PGPPublicKey choose(PGPPublicKey key1, PGPPublicKey key2) {
        int signatureCount2;
        long signatureTime2;
        long signatureTime1 = DefaultPGPPublicKeyService.getNewestSignature(key1);
        if (signatureTime1 > (signatureTime2 = DefaultPGPPublicKeyService.getNewestSignature(key2))) {
            return key1;
        }
        if (signatureTime1 < signatureTime2) {
            return key2;
        }
        int signatureCount1 = DefaultPGPPublicKeyService.getSignatureCount(key1);
        if (signatureCount1 > (signatureCount2 = DefaultPGPPublicKeyService.getSignatureCount(key2))) {
            return key1;
        }
        if (signatureCount1 < signatureCount2) {
            return key2;
        }
        return key1;
    }

    protected static int getSignatureCount(PGPPublicKey key) {
        int result = 0;
        Iterator signatures = key.getSignatures();
        while (signatures.hasNext()) {
            ++result;
            signatures.next();
        }
        signatures = key.getKeySignatures();
        while (signatures.hasNext()) {
            ++result;
            signatures.next();
        }
        return result;
    }

    protected static long getNewestSignature(PGPPublicKey key) {
        long time;
        PGPSignature signature;
        long result = 0L;
        Iterator signatures = key.getSignatures();
        while (signatures.hasNext()) {
            signature = (PGPSignature)signatures.next();
            time = signature.getCreationTime().getTime();
            result = Math.max(result, time);
        }
        signatures = key.getKeySignatures();
        while (signatures.hasNext()) {
            signature = (PGPSignature)signatures.next();
            time = signature.getCreationTime().getTime();
            result = Math.max(result, time);
        }
        return result;
    }

    @Override
    public PGPPublicKey addKey(PGPPublicKey key) {
        long keyID = key.getKeyID();
        LocalKeyCache localKeyCache = this.getLocalKeyCache(keyID);
        localKeyCache.add(key);
        Collection<PGPPublicKey> keys = this.getKeys(keyID);
        byte[] fingerprint = key.getFingerprint();
        for (PGPPublicKey otherKey : keys) {
            if (!Arrays.equals(otherKey.getFingerprint(), fingerprint)) continue;
            return otherKey;
        }
        return key;
    }

    protected boolean isStale(Path path) {
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
            long lastModified = lastModifiedTime.toMillis();
            long currentTime = System.currentTimeMillis();
            return currentTime - lastModified > STALE_AFTER_MILLIS;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<PGPPublicKey> getVerifiedCertifications(PGPPublicKey key) {
        LinkedHashSet<PGPPublicKey> certifications = new LinkedHashSet<PGPPublicKey>();
        Iterator signatures = key.getSignatures();
        block8: while (signatures.hasNext()) {
            PGPSignature signature = (PGPSignature)signatures.next();
            long signingKeyID = signature.getKeyID();
            for (PGPPublicKey signingKey : this.getKeys(signingKeyID)) {
                switch (signature.getSignatureType()) {
                    case 24: 
                    case 25: {
                        try {
                            signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), signingKey);
                            if (!signature.verifyCertification(signingKey, key) || !this.isCreatedBeforeRevocation(signature, signingKey)) break;
                            certifications.add(signingKey);
                            continue block8;
                        }
                        catch (PGPException pGPException) {
                            break;
                        }
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        Iterator userIDs = key.getUserIDs();
                        while (userIDs.hasNext()) {
                            String userID = (String)userIDs.next();
                            try {
                                signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), signingKey);
                                if (!signature.verifyCertification(userID, key) || !this.isCreatedBeforeRevocation(signature, signingKey)) continue;
                                certifications.add(signingKey);
                                continue block8;
                            }
                            catch (PGPException pGPException) {}
                        }
                        break block2;
                    }
                }
            }
        }
        return certifications;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Date getVerifiedRevocationDate(PGPPublicKey key) {
        signatures = key.getSignatures();
        while (signatures.hasNext()) {
            signature = (PGPSignature)signatures.next();
            signingKeyID = signature.getKeyID();
            block6: for (PGPPublicKey signingKey : this.getKeys(signingKeyID)) {
                switch (signature.getSignatureType()) {
                    case 32: 
                    case 48: {
                        try {
                            signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), signingKey);
                            if (!signature.verifyCertification(key)) ** break;
                            return signature.getCreationTime();
                            continue block6;
                        }
                        catch (PGPException v0) {
                            return new Date(0L);
                        }
                    }
                }
            }
        }
        return null;
    }

    private LocalKeyCache getLocalKeyCache(long keyID) {
        LocalKeyCache localKeyCache = this.localKeys.get(keyID);
        if (localKeyCache == null) {
            String hexKeyID = DefaultPGPPublicKeyService.toHex(keyID);
            Path cache = this.keyCache.resolve(String.valueOf(hexKeyID) + ".asc");
            localKeyCache = new LocalKeyCache(cache){

                @Override
                protected List<PGPPublicKey> reconcileKeys(List<PGPPublicKey> keys) {
                    return DefaultPGPPublicKeyService.this.reconcileKeys(keys);
                }

                @Override
                protected void log(Throwable throwable) {
                    DefaultPGPPublicKeyService.this.log(throwable);
                }
            };
            this.localKeys.put(keyID, localKeyCache);
        }
        return localKeyCache;
    }

    protected Collection<PGPPublicKey> fetchKeys(URI uri, Path cache) throws IOException {
        try {
            ByteArrayOutputStream reciever = new ByteArrayOutputStream();
            IStatus download = this.download(uri, reciever, (IProgressMonitor)new NullProgressMonitor());
            if (!download.isOK()) {
                Throwable exception = download.getException();
                if (exception != null) {
                    throw new IOException(download.getMessage(), exception);
                }
                throw new IOException(download.getMessage());
            }
            ArrayList<PGPPublicKey> result22 = new ArrayList<PGPPublicKey>();
            byte[] bytes = reciever.toByteArray();
            Throwable throwable = null;
            Object var8_19 = null;
            try (ArmoredInputStream input = new ArmoredInputStream((InputStream)new ByteArrayInputStream(bytes));){
                result22.addAll(DefaultPGPPublicKeyService.loadKeys((InputStream)input));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var8_19 = null;
            try (OutputStream out = DefaultPGPPublicKeyService.newAtomicOutputStream(cache);){
                out.write(bytes);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            return result22;
        }
        catch (IOException ex) {
            if (Files.isRegularFile(cache, new LinkOption[0])) {
                try {
                    Throwable download = null;
                    Object result22 = null;
                    try (ArmoredInputStream input = new ArmoredInputStream((InputStream)new BufferedInputStream(Files.newInputStream(cache, new OpenOption[0])));){
                        return DefaultPGPPublicKeyService.loadKeys((InputStream)input);
                    }
                    catch (Throwable result22) {
                        if (download == null) {
                            download = result22;
                        } else if (download != result22) {
                            download.addSuppressed(result22);
                        }
                        throw download;
                    }
                }
                catch (IOException ex1) {
                    try {
                        Files.delete(cache);
                    }
                    catch (IOException ex2) {
                        this.log(ex2);
                    }
                    throw new IOException("Error while processing " + uri + " as well while processing the cache " + cache + ": " + ex1.getMessage(), ex);
                }
            }
            throw new IOException("Error while processing " + uri, ex);
        }
    }

    protected IStatus download(URI uri, OutputStream receiver, IProgressMonitor monitor) {
        return this.transport.download(uri, receiver, monitor);
    }

    protected void log(Throwable throwable) {
        if (DEBUG_KEY_SERVICE) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", throwable.getMessage(), throwable));
        }
    }

    protected static OutputStream newAtomicOutputStream(final Path cache) throws IOException {
        final Path temp = Files.createTempFile(cache.getParent(), "out", ".tmp", new FileAttribute[0]);
        return new BufferedOutputStream(Files.newOutputStream(temp, new OpenOption[0])){

            @Override
            public void close() throws IOException {
                super.close();
                Files.move(temp, cache, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
        };
    }

    protected static List<PGPPublicKey> loadKeys(InputStream input) throws IOException {
        try {
            ArrayList<PGPPublicKey> result = new ArrayList<PGPPublicKey>();
            for (Object o : new JcaPGPObjectFactory(input)) {
                if (o instanceof PGPPublicKeyRingCollection) {
                    DefaultPGPPublicKeyService.collectKeys((PGPPublicKeyRingCollection)o, result::add);
                    continue;
                }
                if (o instanceof PGPPublicKeyRing) {
                    DefaultPGPPublicKeyService.collectKeys((PGPPublicKeyRing)o, result::add);
                    continue;
                }
                if (!(o instanceof PGPPublicKey)) continue;
                result.add((PGPPublicKey)o);
            }
            return result;
        }
        catch (RuntimeException ex) {
            throw new IOException(ex);
        }
    }

    private static void collectKeys(PGPPublicKeyRingCollection pgpPublicKeyRingCollection, Consumer<PGPPublicKey> collector) {
        pgpPublicKeyRingCollection.forEach(keyring -> DefaultPGPPublicKeyService.collectKeys(keyring, collector));
    }

    private static void collectKeys(PGPPublicKeyRing pgpPublicKeyRing, Consumer<PGPPublicKey> collector) {
        pgpPublicKeyRing.getPublicKeys().forEachRemaining(collector::accept);
    }

    private static List<PGPPublicKey> getGPGPubringKeys(long keyID) {
        return GPGPubringCache.getKeys(keyID);
    }

    private static Supplier<PGPPublicKeyRingCollection> getGPGPubring() {
        PGPPublicKeyRingCollection empty;
        Path gpgDirectory = DefaultPGPPublicKeyService.getGPPDirectory();
        final Path pubringGpg = gpgDirectory.resolve("pubring.gpg");
        final Path pubringKbx = gpgDirectory.resolve("pubring.kbx");
        if (Files.isRegularFile(pubringGpg, new LinkOption[0])) {
            return new GPGPubringSupplier(pubringGpg){

                @Override
                protected PGPPublicKeyRingCollection buildPubring() throws Exception {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(pubringGpg, new OpenOption[0]));){
                        PGPPublicKeyRingCollection keyRingCollection = new PGPPublicKeyRingCollection((InputStream)input, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                        return keyRingCollection;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            };
        }
        if (Files.isRegularFile(pubringKbx, new LinkOption[0])) {
            return new GPGPubringSupplier(pubringKbx){

                @Override
                protected PGPPublicKeyRingCollection buildPubring() throws Exception {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(pubringKbx, new OpenOption[0]));){
                        JcaKeyBox keyBox = new JcaKeyBoxBuilder().build((InputStream)input);
                        ArrayList<PGPPublicKeyRing> pgpPublicKeyRings = new ArrayList<PGPPublicKeyRing>();
                        for (KeyBlob keyBlob : keyBox.getKeyBlobs()) {
                            switch (keyBlob.getType()) {
                                case OPEN_PGP_BLOB: {
                                    PGPPublicKeyRing pgpPublicKeyRing = ((PublicKeyRingBlob)keyBlob).getPGPPublicKeyRing();
                                    pgpPublicKeyRings.add(pgpPublicKeyRing);
                                }
                            }
                        }
                        PGPPublicKeyRingCollection keyRingCollection = new PGPPublicKeyRingCollection(pgpPublicKeyRings);
                        return keyRingCollection;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            };
        }
        try {
            empty = new PGPPublicKeyRingCollection(Collections.emptyList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return () -> empty;
    }

    private static Path getGPPDirectory() {
        Function<String, Path> resolveTilde = s -> {
            if (s.startsWith("~/") || s.startsWith("~" + File.separatorChar)) {
                return new File(System.getProperty("user.home"), s.substring(2)).getAbsoluteFile().toPath();
            }
            return Paths.get(s, new String[0]);
        };
        Path path = DefaultPGPPublicKeyService.checkDirectory(System.getProperty(GPG_HOME_PROPERTY), resolveTilde);
        if (path != null) {
            return path;
        }
        path = DefaultPGPPublicKeyService.checkDirectory(System.getenv("GNUPGHOME"), resolveTilde);
        if (path != null) {
            return path;
        }
        if ("win32".equals(System.getProperty("osgi.os")) && (path = DefaultPGPPublicKeyService.checkDirectory(System.getenv("APPDATA"), s -> Paths.get(s, new String[0]).resolve("gnupg"))) != null) {
            return path;
        }
        return resolveTilde.apply("~/.gnupg");
    }

    private static Path checkDirectory(String dir, Function<String, Path> toPath) {
        if (dir != null && !dir.isBlank()) {
            try {
                Path directory = toPath.apply(dir);
                if (Files.isDirectory(directory, new LinkOption[0])) {
                    return directory;
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        return null;
    }

    private static class GPGPubringCache {
        private static final Supplier<PGPPublicKeyRingCollection> GPG_PUBRING = DefaultPGPPublicKeyService.getGPGPubring();
        private static volatile PGPPublicKeyRingCollection cachePubring;
        private static volatile Map<Long, List<PGPPublicKey>> cache;

        private GPGPubringCache() {
        }

        public static List<PGPPublicKey> getKeys(long keyID) {
            List<PGPPublicKey> result;
            PGPPublicKeyRingCollection pubring = GPG_PUBRING.get();
            if (pubring != cachePubring) {
                LinkedHashMap<Long, List<PGPPublicKey>> newCache = new LinkedHashMap<Long, List<PGPPublicKey>>();
                Iterator keyRings = pubring.getKeyRings();
                while (keyRings.hasNext()) {
                    for (PGPPublicKey key : (PGPPublicKeyRing)keyRings.next()) {
                        long keyID2 = key.getKeyID();
                        List keys = newCache.computeIfAbsent(keyID2, it -> new ArrayList());
                        keys.add(key);
                    }
                }
                cache = newCache;
                cachePubring = pubring;
            }
            return (result = cache.get(keyID)) == null ? List.of() : result;
        }
    }

    private static abstract class GPGPubringSupplier
    implements Supplier<PGPPublicKeyRingCollection> {
        private final Path pubring;
        private PGPPublicKeyRingCollection keyRingCollection;
        private FileTime lastModifiedTime;

        public GPGPubringSupplier(Path pubring) {
            this.pubring = pubring;
            this.keyRingCollection = new PGPPublicKeyRingCollection(Collections.emptyList());
        }

        @Override
        public PGPPublicKeyRingCollection get() {
            try {
                FileTime newLastModifiedTime = Files.getLastModifiedTime(this.pubring, new LinkOption[0]);
                if (this.lastModifiedTime == null || this.lastModifiedTime.compareTo(newLastModifiedTime) < 0) {
                    this.lastModifiedTime = newLastModifiedTime;
                    this.keyRingCollection = this.buildPubring();
                }
            }
            catch (Exception exception) {}
            return this.keyRingCollection;
        }

        protected abstract PGPPublicKeyRingCollection buildPubring() throws Exception;
    }

    private static abstract class LocalKeyCache {
        private Path cache;
        private FileTime lastModifiedTime;
        private List<PGPPublicKey> keys;

        public LocalKeyCache(Path cache) {
            this.cache = cache;
        }

        protected abstract void log(Throwable var1);

        protected abstract List<PGPPublicKey> reconcileKeys(List<PGPPublicKey> var1);

        public List<PGPPublicKey> get() {
            Object newLastModifiedTime;
            if (this.keys != null) {
                try {
                    newLastModifiedTime = Files.getLastModifiedTime(this.cache, new LinkOption[0]);
                    if (this.lastModifiedTime != null && this.lastModifiedTime.compareTo((FileTime)newLastModifiedTime) >= 0) {
                        return this.keys;
                    }
                    this.lastModifiedTime = newLastModifiedTime;
                }
                catch (Exception exception) {}
            }
            if (!Files.isRegularFile(this.cache, new LinkOption[0])) {
                return List.of();
            }
            try {
                newLastModifiedTime = null;
                Object var2_4 = null;
                try (ArmoredInputStream input = new ArmoredInputStream((InputStream)new BufferedInputStream(Files.newInputStream(this.cache, new OpenOption[0])));){
                    this.keys = DefaultPGPPublicKeyService.loadKeys((InputStream)input);
                    return this.keys;
                }
                catch (Throwable throwable) {
                    if (newLastModifiedTime == null) {
                        newLastModifiedTime = throwable;
                    } else if (newLastModifiedTime != throwable) {
                        ((Throwable)newLastModifiedTime).addSuppressed(throwable);
                    }
                    throw newLastModifiedTime;
                }
            }
            catch (IOException ex) {
                this.log(ex);
                try {
                    Files.delete(this.cache);
                }
                catch (IOException ex2) {
                    this.log(ex2);
                }
                return List.of();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void add(PGPPublicKey key) {
            List<PGPPublicKey> newKeys;
            block16: {
                List<PGPPublicKey> oldKeys = this.get();
                newKeys = new ArrayList<PGPPublicKey>(oldKeys);
                newKeys.add(key);
                newKeys = this.reconcileKeys(newKeys);
                if (oldKeys.equals(newKeys)) return;
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try {
                        OutputStream underlyingStream = DefaultPGPPublicKeyService.newAtomicOutputStream(this.cache);
                        try {
                            try (ArmoredOutputStream output = new ArmoredOutputStream(underlyingStream);){
                                for (PGPPublicKey newKey : newKeys) {
                                    newKey.encode((OutputStream)output);
                                }
                            }
                            if (underlyingStream == null) break block16;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (underlyingStream == null) throw throwable;
                            underlyingStream.close();
                            throw throwable;
                        }
                        underlyingStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.log(e);
                    return;
                }
            }
            this.keys = newKeys;
        }
    }

    private static abstract class PGPKeyServer {
        private final Map<Long, List<PGPPublicKey>> keyIDMap = new LinkedHashMap<Long, List<PGPPublicKey>>();
        private final String keyServer;
        private final Path keyCache;

        public PGPKeyServer(String keyServer, Path baseCache) {
            this.keyServer = keyServer;
            this.keyCache = baseCache.resolve(keyServer.replace(':', '_'));
            if (!Files.isDirectory(this.keyCache, new LinkOption[0])) {
                try {
                    Files.createDirectories(this.keyCache, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        protected abstract boolean isStale(Path var1);

        protected abstract IStatus download(URI var1, OutputStream var2, IProgressMonitor var3);

        protected abstract void log(Throwable var1);

        public List<PGPPublicKey> getKeys(long keyID) {
            List<Object> keys;
            block17: {
                boolean needsRemoteFetch;
                keys = this.keyIDMap.get(keyID);
                String hexKeyID = DefaultPGPPublicKeyService.toHex(keyID);
                Path cache = this.keyCache.resolve(String.valueOf(hexKeyID) + ".asc");
                boolean bl = needsRemoteFetch = !Files.isRegularFile(cache, new LinkOption[0]) || this.isStale(cache);
                if (keys == null || needsRemoteFetch) {
                    try {
                        Collection<PGPPublicKey> fetchedKeys;
                        if (needsRemoteFetch) {
                            link = "https://" + this.keyServer + "/pks/lookup?op=get&search=0x" + hexKeyID;
                            if (DEBUG_KEY_SERVICE) {
                                DebugHelper.debug("KeyServer", "Searching", "uri", link);
                            }
                            uri2 = new URI((String)link);
                            fetchedKeys = this.fetchKeys(uri2, cache);
                        } else {
                            link = null;
                            uri2 = null;
                            try (ArmoredInputStream input = new ArmoredInputStream((InputStream)new BufferedInputStream(Files.newInputStream(cache, new OpenOption[0])));){
                                fetchedKeys = DefaultPGPPublicKeyService.loadKeys((InputStream)input);
                            }
                            catch (Throwable uri2) {
                                if (link == null) {
                                    link = uri2;
                                } else if (link != uri2) {
                                    ((Throwable)link).addSuppressed(uri2);
                                }
                                throw link;
                            }
                        }
                        ArrayList<PGPPublicKey> newKeys = new ArrayList<PGPPublicKey>();
                        for (PGPPublicKey fetchedKey : fetchedKeys) {
                            long fetchedKeyID = fetchedKey.getKeyID();
                            if (fetchedKeyID != keyID) continue;
                            newKeys.add(fetchedKey);
                        }
                        this.keyIDMap.put(keyID, newKeys);
                        keys = newKeys;
                    }
                    catch (IOException | URISyntaxException e) {
                        this.log(e);
                        if (keys != null && !keys.isEmpty()) break block17;
                        List newKeys = List.of();
                        this.keyIDMap.put(keyID, newKeys);
                        keys = newKeys;
                    }
                }
            }
            return Collections.unmodifiableList(keys);
        }

        protected Collection<PGPPublicKey> fetchKeys(URI uri, Path cache) throws IOException {
            try {
                List<PGPPublicKey> result22;
                Object var8_19;
                Throwable throwable;
                ByteArrayOutputStream reciever = new ByteArrayOutputStream();
                IStatus download = this.download(uri, reciever, (IProgressMonitor)new NullProgressMonitor());
                if (!download.isOK()) {
                    Throwable exception = download.getException();
                    if (exception instanceof FileNotFoundException) {
                        this.log(exception);
                    } else {
                        if (exception != null) {
                            throw new IOException(download.getMessage(), exception);
                        }
                        throw new IOException(download.getMessage());
                    }
                }
                byte[] bytes = reciever.toByteArray();
                try {
                    throwable = null;
                    var8_19 = null;
                    try (ArmoredInputStream input = new ArmoredInputStream((InputStream)new ByteArrayInputStream(bytes));){
                        result22 = DefaultPGPPublicKeyService.loadKeys((InputStream)input);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    this.log(ex);
                    bytes = new byte[]{};
                    result22 = List.of();
                }
                throwable = null;
                var8_19 = null;
                try (OutputStream out = DefaultPGPPublicKeyService.newAtomicOutputStream(cache);){
                    out.write(bytes);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                return result22;
            }
            catch (IOException ex) {
                if (Files.isRegularFile(cache, new LinkOption[0])) {
                    try {
                        Throwable download = null;
                        Object result22 = null;
                        try (ArmoredInputStream input = new ArmoredInputStream((InputStream)new BufferedInputStream(Files.newInputStream(cache, new OpenOption[0])));){
                            return DefaultPGPPublicKeyService.loadKeys((InputStream)input);
                        }
                        catch (Throwable result22) {
                            if (download == null) {
                                download = result22;
                            } else if (download != result22) {
                                download.addSuppressed(result22);
                            }
                            throw download;
                        }
                    }
                    catch (IOException ex1) {
                        try {
                            Files.delete(cache);
                        }
                        catch (IOException ex2) {
                            this.log(ex2);
                        }
                        throw new IOException("Error while processing " + uri + " as well while processing the cache " + cache + ": " + ex1.getMessage(), ex);
                    }
                }
                throw new IOException("Error while processing " + uri, ex);
            }
        }
    }
}

