/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal.launcher;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.launchview.IBackgroundLaunchExecutor;
import org.eclipse.debug.ui.launchview.internal.FileLogger;
import org.eclipse.debug.ui.launchview.internal.LaunchViewMessages;
import org.eclipse.debug.ui.launchview.internal.SpecificLaunchListener;
import org.eclipse.debug.ui.launchview.internal.StreamHelper;
import org.eclipse.osgi.util.NLS;

public class StandaloneLaunchConfigExecutor
implements IBackgroundLaunchExecutor {
    @Override
    public int launchProcess(ILaunchConfiguration launchConf, String mode, boolean build, boolean wait, File logFile) {
        StandaloneLauncherJob launch = new StandaloneLauncherJob(launchConf, mode, build, wait, logFile);
        launch.setPriority(20);
        launch.schedule();
        if (wait) {
            try {
                launch.join();
            }
            catch (InterruptedException interruptedException) {
                return -1;
            }
        }
        return launch.getProcessResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ILaunch launch(ILaunchConfiguration launchConfig, String mode, IProgressMonitor monitor, long timeout, File logFile, boolean build, boolean wait) throws Exception {
        final FileLogger logger = logFile != null ? new FileLogger(logFile) : null;
        final Object lock = new Object();
        final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchesListener)new SpecificLaunchListener(launchConfig){
            private final Set<IProcess> attached;
            {
                super($anonymous0);
                this.attached = new HashSet<IProcess>();
            }

            @Override
            public void launchChanged(ILaunch launch) {
                if (logger == null) {
                    return;
                }
                IProcess[] iProcessArray = launch.getProcesses();
                int n = iProcessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess p = iProcessArray[n2];
                    if (!this.attached.contains(p)) {
                        p.getStreamsProxy().getOutputStreamMonitor().addListener((IStreamListener)logger);
                        p.getStreamsProxy().getErrorStreamMonitor().addListener((IStreamListener)logger);
                        this.attached.add(p);
                    }
                    ++n2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void launchTerminated(ILaunch l) {
                StreamHelper.closeQuietly(logger);
                launchManager.removeLaunchListener((ILaunchesListener)this);
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        });
        ILaunch launch = launchConfig.launch(mode, monitor, build, true);
        monitor.subTask(LaunchViewMessages.StandaloneLaunchConfigExecutor_Waiting);
        if (wait) {
            long timeRunning = 0L;
            while (launch.hasChildren() && !launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                }
                if (timeout > 0L && timeRunning > timeout) {
                    launch.terminate();
                    StreamHelper.closeQuietly(logger);
                    throw new InterruptedException(NLS.bind((String)LaunchViewMessages.StandaloneLaunchConfigExecutor_Timeout, (Object)timeout));
                }
                Object object = lock;
                synchronized (object) {
                    lock.wait(500L);
                }
                timeRunning += 500L;
            }
        }
        return launch;
    }

    private static class StandaloneLauncherJob
    extends Job {
        private final ILaunchConfiguration config;
        private int result = 0;
        private final String mode;
        private final boolean build;
        private final boolean wait;
        private final File logFile;

        StandaloneLauncherJob(ILaunchConfiguration config, String mode, boolean build, boolean wait, File logFile) {
            super(NLS.bind((String)LaunchViewMessages.StandaloneLaunchConfigExecutor_Launch, (Object)config.getName()));
            this.config = config;
            this.build = build;
            this.wait = wait;
            this.logFile = logFile;
            this.mode = mode;
        }

        int getProcessResult() {
            return this.result;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    monitor.beginTask(NLS.bind((String)LaunchViewMessages.StandaloneLaunchConfigExecutor_Launching, (Object)this.config.getName()), -1);
                    ILaunch launch = StandaloneLaunchConfigExecutor.launch(this.config, this.mode, monitor, 0L, this.logFile, this.build, this.wait);
                    if (this.wait) {
                        IProcess[] ps;
                        IProcess[] iProcessArray = ps = launch.getProcesses();
                        int n = ps.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProcess p = iProcessArray[n2];
                            if (p.getExitValue() != 0) {
                                this.result = p.getExitValue();
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    ILog.of(((Object)((Object)this)).getClass()).error(NLS.bind((String)LaunchViewMessages.StandaloneLaunchConfigExecutor_FailedLaunching, (Object)this.config.getName()), (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

