/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.search.matching.ClasspathSourceDirectory;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaSearchNameEnvironment
implements IModuleAwareNameEnvironment,
SuffixConstants {
    protected LinkedHashSet<ClasspathLocation> locationSet;
    Map<String, IModuleDescription> modules;
    private boolean modulesComputed = false;
    Map<String, ClasspathLocation> moduleLocations;
    Map<String, LinkedHashSet<ClasspathLocation>> moduleToClassPathLocations;
    protected Map<String, LinkedHashSet<ClasspathLocation>> packageNameToClassPathLocations;
    Map<String, org.eclipse.jdt.core.ICompilationUnit> workingCopies;

    public JavaSearchNameEnvironment(IJavaProject javaProject, org.eclipse.jdt.core.ICompilationUnit[] copies) {
        if (JavaSearchNameEnvironment.isComplianceJava9OrHigher(javaProject)) {
            this.moduleLocations = new HashMap<String, ClasspathLocation>();
            this.moduleToClassPathLocations = new HashMap<String, LinkedHashSet<ClasspathLocation>>();
        }
        this.modules = new HashMap<String, IModuleDescription>();
        this.packageNameToClassPathLocations = new HashMap<String, LinkedHashSet<ClasspathLocation>>();
        long start = 0L;
        if (NameLookup.VERBOSE) {
            JavaModelManager.trace(" BUILDING JavaSearchNameEnvironment");
            JavaModelManager.trace(" -> project: " + String.valueOf(javaProject));
            JavaModelManager.trace(" -> working copy size: " + (copies == null ? 0 : copies.length));
            start = System.currentTimeMillis();
        }
        this.locationSet = this.computeClasspathLocations((JavaProject)javaProject);
        this.workingCopies = JavaSearchNameEnvironment.getWorkingCopyMap(copies);
        if (this.workingCopies.size() > 0) {
            Optional<ClasspathLocation> firstSrcLocation = this.locationSet.stream().filter(cp -> cp instanceof ClasspathSourceDirectory).findFirst();
            if (!firstSrcLocation.isPresent()) {
                if (NameLookup.VERBOSE) {
                    JavaModelManager.trace(" -> ignoring working copies; no ClasspathSourceDirectory on project classpath ");
                }
            } else {
                for (String qualifiedMainTypeName : this.workingCopies.keySet()) {
                    int typeNameStart = qualifiedMainTypeName.lastIndexOf(47);
                    if (typeNameStart > 0) {
                        String pkgName = qualifiedMainTypeName.substring(0, typeNameStart);
                        this.addPackageNameToIndex(firstSrcLocation.get(), pkgName);
                        continue;
                    }
                    this.addPackageNameToIndex(firstSrcLocation.get(), "");
                }
            }
        }
        if (NameLookup.VERBOSE) {
            JavaModelManager.trace(" -> pkg roots size: " + (this.locationSet == null ? 0 : this.locationSet.size()));
            JavaModelManager.trace(" -> pkgs size: " + this.packageNameToClassPathLocations.size());
            JavaModelManager.trace(" -> spent: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public static Map<String, org.eclipse.jdt.core.ICompilationUnit> getWorkingCopyMap(org.eclipse.jdt.core.ICompilationUnit[] copies) {
        int length = copies == null ? 0 : copies.length;
        HashMap<String, org.eclipse.jdt.core.ICompilationUnit> result = new HashMap<String, org.eclipse.jdt.core.ICompilationUnit>(length);
        try {
            if (copies != null) {
                int i = 0;
                while (i < length) {
                    org.eclipse.jdt.core.ICompilationUnit workingCopy = copies[i];
                    IPackageDeclaration[] pkgs = workingCopy.getPackageDeclarations();
                    String pkg = pkgs.length > 0 ? pkgs[0].getElementName() : "";
                    String cuName = workingCopy.getElementName();
                    String mainTypeName = Util.getNameWithoutJavaLikeExtension(cuName);
                    String qualifiedMainTypeName = pkg.length() == 0 ? mainTypeName : pkg.replace('.', '/') + "/" + mainTypeName;
                    result.put(qualifiedMainTypeName, workingCopy);
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    public void cleanup() {
        this.locationSet.clear();
        this.packageNameToClassPathLocations.clear();
    }

    protected void addProjectClassPath(JavaProject javaProject) {
        this.addProjectClassPath(javaProject, false);
    }

    void addProjectClassPath(JavaProject javaProject, boolean onlyExported) {
        LinkedHashSet<ClasspathLocation> locations;
        long start = 0L;
        if (NameLookup.VERBOSE) {
            JavaModelManager.trace(" EXTENDING JavaSearchNameEnvironment");
            JavaModelManager.trace(" -> project: " + String.valueOf(javaProject));
            start = System.currentTimeMillis();
        }
        if ((locations = this.computeClasspathLocations(javaProject, onlyExported)) != null) {
            this.locationSet.addAll(locations);
        }
        if (NameLookup.VERBOSE) {
            JavaModelManager.trace(" -> pkg roots size: " + (this.locationSet == null ? 0 : this.locationSet.size()));
            JavaModelManager.trace(" -> pkgs size: " + this.packageNameToClassPathLocations.size());
            JavaModelManager.trace(" -> spent: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    private LinkedHashSet<ClasspathLocation> computeClasspathLocations(JavaProject javaProject) {
        return this.computeClasspathLocations(javaProject, false);
    }

    private LinkedHashSet<ClasspathLocation> computeClasspathLocations(JavaProject javaProject, boolean onlyExported) {
        IModuleDescription projectModule;
        IPackageFragmentRoot[] roots;
        block8: {
            roots = null;
            try {
                roots = javaProject.getAllPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
            projectModule = null;
            try {
                projectModule = javaProject.getModuleDescription();
            }
            catch (JavaModelException e) {
                if (!JobManager.VERBOSE) break block8;
                JavaModelManager.trace("", (Exception)((Object)e));
            }
        }
        LinkedHashSet<ClasspathLocation> locations = new LinkedHashSet<ClasspathLocation>();
        int length = roots.length;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        while (i < length) {
            ClasspathLocation cp;
            PackageFragmentRoot root = (PackageFragmentRoot)roots[i];
            if ((!onlyExported || JavaSearchNameEnvironment.isSourceOrExported(root)) && (cp = this.mapToClassPathLocation(manager, root, projectModule)) != null) {
                try {
                    this.indexPackageNames(cp, roots[i]);
                    locations.add(cp);
                }
                catch (JavaModelException e) {
                    Util.log((Throwable)((Object)e), "Error indexing package names!");
                }
            }
            ++i;
        }
        return locations;
    }

    private void indexPackageNames(ClasspathLocation cp, IPackageFragmentRoot root) throws JavaModelException {
        IJavaElement[] iJavaElementArray = root.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement c = iJavaElementArray[n2];
            String qualifiedPackageName = c.getElementName().replace('.', '/');
            this.addPackageNameToIndex(cp, qualifiedPackageName);
            ++n2;
        }
        char[][] packages = cp.listPackages();
        if (packages != null) {
            char[][] cArray = packages;
            int n3 = packages.length;
            n = 0;
            while (n < n3) {
                char[] packageName = cArray[n];
                String qualifiedPackageName = CharOperation.charToString((char[])packageName).replace('.', '/');
                this.addPackageNameToIndex(cp, qualifiedPackageName);
                ++n;
            }
        }
    }

    private void addPackageNameToIndex(ClasspathLocation cp, String qualifiedPackageName) {
        LinkedHashSet<ClasspathLocation> cpl = this.packageNameToClassPathLocations.get(qualifiedPackageName);
        if (cpl == null) {
            cpl = new LinkedHashSet();
            this.packageNameToClassPathLocations.put(qualifiedPackageName, cpl);
        }
        cpl.add(cp);
    }

    private void computeModules() {
        if (!this.modulesComputed) {
            this.modulesComputed = true;
            JavaElementRequestor requestor = new JavaElementRequestor();
            try {
                IModuleDescription[] mods;
                JavaModelManager.getModulePathManager().seekModule(CharOperation.ALL_PREFIX, true, requestor);
                IModuleDescription[] iModuleDescriptionArray = mods = requestor.getModules();
                int n = mods.length;
                int n2 = 0;
                while (n2 < n) {
                    IModuleDescription mod = iModuleDescriptionArray[n2];
                    this.modules.putIfAbsent(mod.getElementName(), mod);
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private ClasspathLocation mapToClassPathLocation(JavaModelManager manager, PackageFragmentRoot root, IModuleDescription defaultModule) {
        IModuleDescription module;
        ClasspathLocation cp = null;
        IPath path = root.getPath();
        try {
            if (root.isArchive()) {
                ClasspathEntry rawClasspathEntry = (ClasspathEntry)root.getRawClasspathEntry();
                IJavaProject project = (IJavaProject)((Object)root.getParent());
                String compliance = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
                cp = root instanceof JrtPackageFragmentRoot ? ClasspathLocation.forJrtSystem(path.toOSString(), rawClasspathEntry.getAccessRuleSet(), null, compliance) : ClasspathLocation.forLibrary(manager.getZipFile(path), rawClasspathEntry.getAccessRuleSet(), rawClasspathEntry.isModular(), compliance);
            } else {
                Object target = JavaModel.getTarget(path, true);
                if (target != null) {
                    if (root.getKind() == 1) {
                        cp = new ClasspathSourceDirectory((IContainer)target, root.fullExclusionPatternChars(), root.fullInclusionPatternChars());
                    } else {
                        ClasspathEntry rawClasspathEntry = (ClasspathEntry)root.getRawClasspathEntry();
                        cp = ClasspathLocation.forBinaryFolder((IContainer)target, false, rawClasspathEntry.getAccessRuleSet(), null, rawClasspathEntry.isModular());
                    }
                }
            }
        }
        catch (CoreException coreException) {}
        JavaProject javaProject = root.getJavaProject();
        if (JavaSearchNameEnvironment.isComplianceJava9OrHigher(javaProject) && (module = JavaSearchNameEnvironment.computeModuleFor(root, defaultModule)) != null) {
            this.addModuleClassPathInfo(module, cp);
        }
        return cp;
    }

    private void addModuleClassPathInfo(IModuleDescription module, ClasspathLocation cp) {
        String moduleName = this.addModuleClassPathInfo(cp, module);
        if (moduleName != null) {
            this.modules.put(moduleName, module);
        }
        if (this.moduleLocations != null) {
            this.moduleLocations.put(moduleName, cp);
        }
    }

    private String addModuleClassPathInfo(ClasspathLocation cp, IModuleDescription imd) {
        char[] name;
        IModule mod = NameLookup.getModuleDescriptionInfo(imd);
        String moduleName = null;
        if (mod != null && cp != null && (name = mod.name()) != null) {
            moduleName = new String(name);
            cp.setModule(mod);
            this.addClassPathToModule(moduleName, cp);
        }
        return moduleName;
    }

    private void addClassPathToModule(String moduleName, ClasspathLocation cp) {
        if (this.moduleToClassPathLocations != null) {
            LinkedHashSet<ClasspathLocation> l = this.moduleToClassPathLocations.get(moduleName);
            if (l == null) {
                l = new LinkedHashSet();
                this.moduleToClassPathLocations.put(moduleName, l);
            }
            l.add(cp);
        }
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName, IModuleAwareNameEnvironment.LookupStrategy strategy, String moduleName) {
        String qPackageName;
        int typeNameStart;
        Object binaryFileName = null;
        String qBinaryFileName = null;
        String sourceFileName = null;
        String qSourceFileName = null;
        if (qualifiedTypeName.length() > typeName.length) {
            typeNameStart = qualifiedTypeName.length() - typeName.length;
            qPackageName = qualifiedTypeName.substring(0, typeNameStart - 1);
        } else {
            typeNameStart = 0;
            qPackageName = "";
        }
        NameEnvironmentAnswer suggestedAnswer = null;
        for (ClasspathLocation location : this.getLocationsFor(moduleName, qPackageName)) {
            NameEnvironmentAnswer answer;
            if (!strategy.matches((Object)location, ClasspathLocation::hasModule)) continue;
            if (location instanceof ClasspathSourceDirectory) {
                ICompilationUnit workingCopy;
                if (sourceFileName == null) {
                    sourceFileName = qSourceFileName = qualifiedTypeName;
                    if (typeNameStart > 0) {
                        sourceFileName = qSourceFileName.substring(typeNameStart);
                    }
                }
                answer = (workingCopy = (ICompilationUnit)this.workingCopies.get(qualifiedTypeName)) != null ? new NameEnvironmentAnswer(workingCopy, null) : location.findClass(sourceFileName, qPackageName, moduleName, qSourceFileName, false, null);
            } else {
                if (binaryFileName == null) {
                    qBinaryFileName = qualifiedTypeName + ".class";
                    binaryFileName = qBinaryFileName;
                    if (typeNameStart > 0) {
                        binaryFileName = qBinaryFileName.substring(typeNameStart);
                    }
                }
                answer = location.findClass((String)binaryFileName, qPackageName, moduleName, qBinaryFileName, false, this.moduleLocations != null ? this.moduleLocations::containsKey : null);
            }
            if (answer == null) continue;
            if (!answer.ignoreIfBetter()) {
                if (!answer.isBetter(suggestedAnswer)) continue;
                if (NameLookup.VERBOSE) {
                    JavaModelManager.trace(" Result for JavaSearchNameEnvironment#findClass( " + qualifiedTypeName + ", " + CharOperation.charToString((char[])typeName) + ", " + String.valueOf(strategy) + ", " + moduleName + ")");
                    JavaModelManager.trace(" -> answer: " + String.valueOf(answer));
                    JavaModelManager.trace(" -> location: " + String.valueOf(location));
                }
                return answer;
            }
            if (!answer.isBetter(suggestedAnswer)) continue;
            suggestedAnswer = answer;
            if (!NameLookup.VERBOSE) continue;
            JavaModelManager.trace(" Potential answer for JavaSearchNameEnvironment#findClass( " + qualifiedTypeName + ", " + CharOperation.charToString((char[])typeName) + ", " + String.valueOf(strategy) + ", " + moduleName + ")");
            JavaModelManager.trace(" -> answer: " + String.valueOf(answer));
            JavaModelManager.trace(" -> location: " + String.valueOf(location));
        }
        if (suggestedAnswer != null) {
            return suggestedAnswer;
        }
        if (NameLookup.VERBOSE) {
            JavaModelManager.trace(" NO result for JavaSearchNameEnvironment#findClass( " + qualifiedTypeName + ", " + CharOperation.charToString((char[])typeName) + ", " + String.valueOf(strategy) + ", " + moduleName + ")");
        }
        return null;
    }

    protected Iterable<ClasspathLocation> getLocationsFor(String moduleName, String qualifiedPackageName) {
        LinkedHashSet<ClasspathLocation> l;
        if (moduleName != null && (l = this.moduleToClassPathLocations.get(moduleName)) != null) {
            return l;
        }
        if (qualifiedPackageName != null) {
            LinkedHashSet<ClasspathLocation> cpls = this.packageNameToClassPathLocations.get(qualifiedPackageName);
            if (cpls == null) {
                if (NameLookup.VERBOSE) {
                    JavaModelManager.trace(" No result for JavaSearchNameEnvironment#getLocationsFor( " + moduleName + ", " + qualifiedPackageName + ")");
                }
                return Collections.emptySet();
            }
            if (NameLookup.VERBOSE) {
                JavaModelManager.trace(" Result for JavaSearchNameEnvironment#getLocationsFor( " + moduleName + ", " + qualifiedPackageName + ")");
                JavaModelManager.trace(" -> " + cpls.stream().map(Object::toString).collect(Collectors.joining(" | ")));
            }
            return cpls;
        }
        if (NameLookup.VERBOSE) {
            JavaModelManager.trace(" Potentially expensive search in JavaSearchNameEnvironment#getLocationsFor( " + moduleName + ", " + qualifiedPackageName + ")");
        }
        return this.locationSet;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith((char[][])packageName, (char[])typeName, (char)'/')), typeName, IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName((char[])moduleName));
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName, char[] moduleName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith((char[][])compoundName, (char)'/')), compoundName[compoundName.length - 1], IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName((char[])moduleName));
        }
        return null;
    }

    public char[][] getModulesDeclaringPackage(char[][] packageName, char[] moduleName) {
        String qualifiedPackageName = String.valueOf(CharOperation.concatWith((char[][])packageName, (char)'/'));
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName);
        if (strategy == IModuleAwareNameEnvironment.LookupStrategy.Named) {
            String moduleNameString;
            LinkedHashSet<ClasspathLocation> cpl;
            if (this.moduleToClassPathLocations != null && (cpl = this.moduleToClassPathLocations.get(moduleNameString = String.valueOf(moduleName))) != null) {
                for (ClasspathLocation cp : cpl) {
                    if (!cp.isPackage(qualifiedPackageName, moduleNameString)) continue;
                    return new char[][]{moduleName};
                }
            }
            return null;
        }
        char[][] moduleNames = CharOperation.NO_CHAR_CHAR;
        for (ClasspathLocation location : this.getLocationsFor(null, qualifiedPackageName)) {
            char[][] mNames;
            if (!strategy.matches((Object)location, ClasspathLocation::hasModule) || !location.isPackage(qualifiedPackageName, null) || (mNames = location.getModulesDeclaringPackage(qualifiedPackageName, null)) == null || mNames.length == 0) continue;
            moduleNames = CharOperation.arrayConcat((char[][])moduleNames, (char[][])mNames);
        }
        if (NameLookup.VERBOSE) {
            JavaModelManager.trace(" Result for JavaSearchNameEnvironment#getModulesDeclaringPackage( " + qualifiedPackageName + ", " + CharOperation.charToString((char[])moduleName) + ")");
            JavaModelManager.trace(" -> " + CharOperation.toString((char[][])moduleNames));
        }
        return moduleNames == CharOperation.NO_CHAR_CHAR ? null : moduleNames;
    }

    public char[][] listPackages(char[] moduleName) {
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName);
        switch (strategy) {
            case Named: {
                if (this.moduleLocations != null) {
                    ClasspathLocation location = this.moduleLocations.get(String.valueOf(moduleName));
                    if (location == null) {
                        return CharOperation.NO_CHAR_CHAR;
                    }
                    return location.listPackages();
                }
                return CharOperation.NO_CHAR_CHAR;
            }
        }
        throw new UnsupportedOperationException("can list packages only of a named module");
    }

    public boolean hasCompilationUnit(char[][] qualifiedPackageName, char[] moduleName, boolean checkCUs) {
        String qualifiedPackageNameString = String.valueOf(CharOperation.concatWith((char[][])qualifiedPackageName, (char)'/'));
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName);
        String moduleNameString = IModuleAwareNameEnvironment.LookupStrategy.getStringName((char[])moduleName);
        if (strategy == IModuleAwareNameEnvironment.LookupStrategy.Named) {
            ClasspathLocation location;
            if (this.moduleLocations != null && (location = this.moduleLocations.get(moduleNameString)) != null) {
                return location.hasCompilationUnit(qualifiedPackageNameString, moduleNameString);
            }
        } else {
            for (ClasspathLocation location : this.getLocationsFor(null, qualifiedPackageNameString)) {
                if (!strategy.matches((Object)location, ClasspathLocation::hasModule) || !location.hasCompilationUnit(qualifiedPackageNameString, moduleNameString)) continue;
                if (NameLookup.VERBOSE) {
                    JavaModelManager.trace(" Result for JavaSearchNameEnvironment#hasCompilationUnit( " + qualifiedPackageNameString + ", " + moduleNameString + ")");
                    JavaModelManager.trace(" -> " + String.valueOf(location));
                }
                return true;
            }
        }
        return false;
    }

    public IModule getModule(char[] moduleName) {
        this.computeModules();
        IModuleDescription moduleDesc = this.modules.get(new String(moduleName));
        IModule module = null;
        try {
            if (moduleDesc != null) {
                module = (IModule)((JavaElement)((Object)moduleDesc)).getElementInfo();
            }
        }
        catch (JavaModelException javaModelException) {}
        return module;
    }

    public char[][] getAllAutomaticModules() {
        if (this.moduleLocations == null || this.moduleLocations.size() == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        Set set = this.moduleLocations.values().stream().map(e -> e.getModule()).filter(m -> m != null && m.isAutomatic()).map(m -> m.name()).collect(Collectors.toSet());
        return (char[][])set.toArray((T[])new char[set.size()][]);
    }

    public static INameEnvironment createWithReferencedProjects(IJavaProject javaProject, List<IJavaProject> referencedProjects, org.eclipse.jdt.core.ICompilationUnit[] copies) {
        JavaSearchNameEnvironment result = new JavaSearchNameEnvironment(javaProject, copies);
        Iterator<IJavaProject> next = referencedProjects.iterator();
        while (next.hasNext()) {
            result.addProjectClassPath((JavaProject)next.next(), true);
        }
        return result;
    }

    private static boolean isComplianceJava9OrHigher(IJavaProject javaProject) {
        if (javaProject == null) {
            return false;
        }
        return CompilerOptions.versionToJdkLevel((String)javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)) >= 0x350000L;
    }

    private static IModuleDescription computeModuleFor(PackageFragmentRoot root, IModuleDescription defaultModule) {
        IModuleDescription rootModule = root.getModuleDescription();
        if (rootModule != null && rootModule.isSystemModule()) {
            return rootModule;
        }
        try {
            IClasspathEntry classpathEntry = root.getRawClasspathEntry();
            if (ClasspathEntry.isModular(classpathEntry)) {
                return rootModule != null ? rootModule : defaultModule;
            }
            int entryKind = classpathEntry.getEntryKind();
            if (entryKind == 3 || entryKind == 5) {
                return rootModule != null ? rootModule : defaultModule;
            }
        }
        catch (JavaModelException e) {
            Util.log((Throwable)((Object)e), "Error checking whether PackageFragmentRoot is on module path!");
        }
        return defaultModule;
    }

    private static boolean isSourceOrExported(PackageFragmentRoot root) {
        boolean isExported = true;
        try {
            IClasspathEntry entry = root.getRawClasspathEntry();
            isExported = entry.getEntryKind() == 3 || entry.isExported();
        }
        catch (JavaModelException e) {
            Util.log((Throwable)((Object)e), "Error checking whether package fragment root is exported!");
        }
        return isExported;
    }

    static boolean isOnModulePath(PackageFragmentRoot root) {
        boolean isOnModulePath;
        try {
            JavaProject javaProject = root.getJavaProject();
            IModuleDescription defaultModule = javaProject.getModuleDescription();
            IModuleDescription moduleForRoot = JavaSearchNameEnvironment.computeModuleFor(root, defaultModule);
            isOnModulePath = moduleForRoot != null;
        }
        catch (JavaModelException e) {
            isOnModulePath = true;
            Util.log((Throwable)((Object)e), "Error checking whether PackageFragmentRoot is on module path!");
        }
        return isOnModulePath;
    }
}

