/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tracing.rcp.ui;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliCommandLine;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliParserException;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliParserManager;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.ApplicationWorkbenchAdvisor;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.TracingRcpPlugin;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.messages.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Application
implements IApplication {
    private Location fInstanceLoc = null;

    /*
     * Loose catch block
     */
    public Object start(IApplicationContext context) throws Exception {
        Display display = PlatformUI.createDisplay();
        try {
            this.fInstanceLoc = Platform.getInstanceLocation();
            if (!this.fInstanceLoc.allowsDefault() && !this.fInstanceLoc.isSet()) {
                File workspaceRoot = new File(TracingRcpPlugin.getWorkspaceRoot());
                if (!workspaceRoot.exists()) {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.Application_WorkspaceCreationError, (String)MessageFormat.format(Messages.Application_WorkspaceRootNotExistError, TracingRcpPlugin.getWorkspaceRoot()));
                    Integer n = IApplication.EXIT_OK;
                    return n;
                }
                if (!workspaceRoot.canWrite()) {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.Application_WorkspaceCreationError, (String)MessageFormat.format(Messages.Application_WorkspaceRootPermissionError, TracingRcpPlugin.getWorkspaceRoot()));
                    Integer n = IApplication.EXIT_OK;
                    return n;
                }
                String workspace = TracingRcpPlugin.getWorkspaceRoot() + File.separator + ".tracecompass";
                this.fInstanceLoc.set(new URL("file", null, workspace), false);
            }
            try {
                CliCommandLine cmdLine = CliParserManager.getInstance().parse(Platform.getCommandLineArgs());
                TracingRcpPlugin.getDefault().setCommandLine(cmdLine);
                if (cmdLine != null && CliParserManager.applicationStartup((CliCommandLine)cmdLine)) {
                    Integer n = IApplication.EXIT_OK;
                    return n;
                }
            }
            catch (CliParserException e) {
                TracingRcpPlugin.getDefault().logError("Error parsing command line arguments", (Exception)((Object)e));
                Integer n = IApplication.EXIT_OK;
                display.dispose();
                return n;
            }
            if (!this.fInstanceLoc.lock()) {
                MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.Application_WorkspaceCreationError, (String)MessageFormat.format(Messages.Application_WorkspaceInUseError, this.fInstanceLoc.getURL().getPath()));
                Integer n = IApplication.EXIT_OK;
                return n;
            }
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        this.fInstanceLoc.release();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                workbench.close();
            }
        });
    }
}

