/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.Objects;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;

public final class KeySequenceBinding
implements IKeySequenceBinding {
    public static final String DEFAULT_CONTEXT_ID = "org.eclipse.ui.contexts.window";
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = KeySequenceBinding.class.getName().hashCode();
    private transient int hashCode;
    private transient boolean hashCodeComputed;
    private KeySequence keySequence;
    private int match;
    private transient String string;

    public KeySequenceBinding(KeySequence keySequence, int match) {
        if (keySequence == null) {
            throw new NullPointerException();
        }
        if (match < 0) {
            throw new IllegalArgumentException();
        }
        this.keySequence = keySequence;
        this.match = match;
    }

    public int compareTo(Object object) {
        KeySequenceBinding castedObject = (KeySequenceBinding)object;
        int compareTo = Util.compare(this.match, castedObject.match);
        if (compareTo == 0) {
            compareTo = Util.compare(this.keySequence, castedObject.keySequence);
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeySequenceBinding)) {
            return false;
        }
        KeySequenceBinding castedObject = (KeySequenceBinding)object;
        return Objects.equals(this.keySequence, castedObject.keySequence) && this.match == castedObject.match;
    }

    @Override
    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    public int getMatch() {
        return this.match;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.keySequence);
            this.hashCode = this.hashCode * 89 + Integer.hashCode(this.match);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append('[');
            stringBuffer.append(this.keySequence);
            stringBuffer.append(',');
            stringBuffer.append(this.match);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

