/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.model;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.NullStreamsProxy;
import org.eclipse.debug.internal.core.StreamsProxy;

public class RuntimeProcess
extends PlatformObject
implements IProcess {
    private static final int TERMINATION_TIMEOUT = 5000;
    private ILaunch fLaunch;
    private Process fProcess;
    private int fExitValue;
    private final ProcessMonitorThread fMonitor;
    private final IStreamsProxy fStreamsProxy;
    private final String fName;
    private boolean fTerminated;
    private Map<String, String> fAttributes;
    private boolean fCaptureOutput = true;
    private boolean fTerminateDescendants = true;
    private final String fThreadNameSuffix;

    public RuntimeProcess(ILaunch launch, Process process, String name, Map<String, String> attributes) {
        this.setLaunch(launch);
        this.initializeAttributes(attributes);
        this.fProcess = process;
        try {
            this.setAttribute(IProcess.ATTR_PROCESS_ID, Long.toString(process.pid()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.fName = name;
        this.fTerminated = true;
        try {
            this.fExitValue = process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            this.fTerminated = false;
        }
        String captureOutput = launch.getAttribute("org.eclipse.debug.core.capture_output");
        this.fCaptureOutput = !"false".equals(captureOutput);
        try {
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            if (launchConfiguration != null) {
                this.fTerminateDescendants = launchConfiguration.getAttribute("org.eclipse.debug.core.TERMINATE_DESCENDANTS", true);
            }
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
        this.fThreadNameSuffix = RuntimeProcess.getPidInfo(process, launch);
        this.fStreamsProxy = this.createStreamsProxy();
        this.fMonitor = new ProcessMonitorThread(this.fThreadNameSuffix);
        launch.addProcess(this);
        this.fMonitor.start();
        this.fireCreationEvent();
    }

    private static String getPidInfo(Process process, ILaunch launch) {
        Object pid;
        ILaunchConfiguration lc = launch == null ? null : launch.getLaunchConfiguration();
        String name = lc == null ? "" : " " + lc.getName();
        try {
            pid = " for PID " + process.pid();
        }
        catch (Exception e) {
            pid = "";
        }
        return (String)pid + name;
    }

    private void initializeAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            attributes.forEach(this::setAttribute);
        }
    }

    @Override
    public synchronized boolean canTerminate() {
        return !this.fTerminated;
    }

    @Override
    public String getLabel() {
        return this.fName;
    }

    protected void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    protected Process getSystemProcess() {
        return this.fProcess;
    }

    @Override
    public synchronized boolean isTerminated() {
        return this.fTerminated;
    }

    @Override
    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            try {
                Process process = this.getSystemProcess();
                if (process == null) {
                    return;
                }
                List<ProcessHandle> descendants = Collections.emptyList();
                if (this.fTerminateDescendants) {
                    try {
                        descendants = process.descendants().collect(Collectors.toList());
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                process.destroy();
                descendants.forEach(ProcessHandle::destroy);
                try {
                    long waitStart = System.currentTimeMillis();
                    if (process.waitFor(5000L, TimeUnit.MILLISECONDS)) {
                        this.fExitValue = process.exitValue();
                        if (this.waitFor(descendants, waitStart)) {
                            return;
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                if (this.fStreamsProxy instanceof StreamsProxy) {
                    ((StreamsProxy)this.fStreamsProxy).kill();
                }
            }
            this.fMonitor.killThread();
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, DebugCoreMessages.RuntimeProcess_terminate_failed, null);
            throw new DebugException((IStatus)status);
        }
    }

    private boolean waitFor(List<ProcessHandle> descendants, long waitStart) throws InterruptedException {
        try {
            for (ProcessHandle handle : descendants) {
                long remainingTime = 5000L - (System.currentTimeMillis() - waitStart);
                handle.onExit().get(remainingTime, TimeUnit.MILLISECONDS);
            }
            return true;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminated() {
        this.setAttribute("org.eclipse.debug.core.terminate.timestamp", Long.toString(System.currentTimeMillis()));
        if (this.fStreamsProxy instanceof StreamsProxy) {
            ((StreamsProxy)this.fStreamsProxy).close();
        }
        int exitValue = -1;
        boolean running = false;
        try {
            exitValue = this.fProcess.exitValue();
        }
        catch (IllegalThreadStateException ie) {
            running = true;
        }
        RuntimeProcess runtimeProcess = this;
        synchronized (runtimeProcess) {
            this.fTerminated = true;
            if (!running) {
                this.fExitValue = exitValue;
            }
            this.fProcess = null;
        }
        this.fireTerminateEvent();
    }

    @Override
    public IStreamsProxy getStreamsProxy() {
        if (!this.fCaptureOutput) {
            return null;
        }
        return this.fStreamsProxy;
    }

    protected IStreamsProxy createStreamsProxy() {
        if (!this.fCaptureOutput) {
            return new NullStreamsProxy(this.getSystemProcess());
        }
        String encoding = this.getLaunch().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        Charset charset = null;
        if (encoding != null) {
            try {
                charset = Charset.forName(encoding);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                DebugPlugin.log(e);
            }
        }
        if (charset == null) {
            charset = Platform.getSystemCharset();
        }
        return new StreamsProxy(this.getSystemProcess(), charset, this.fThreadNameSuffix);
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent(this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent(this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent(this, 16));
    }

    @Override
    public void setAttribute(String key, String value) {
        String origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, String>(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
        this.fireChangeEvent();
    }

    @Override
    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return this.fAttributes.get(key);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IProcess.class)) {
            return (T)this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            IDebugTarget[] targets;
            ILaunch launch = this.getLaunch();
            IDebugTarget[] iDebugTargetArray = targets = launch.getDebugTargets();
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget target = iDebugTargetArray[n2];
                if (this.equals(target.getProcess())) {
                    return (T)target;
                }
                ++n2;
            }
            return null;
        }
        if (adapter.equals(ILaunch.class)) {
            return (T)this.getLaunch();
        }
        if (adapter.equals(ILaunchConfiguration.class)) {
            return (T)this.getLaunch().getLaunchConfiguration();
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public synchronized int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.fExitValue;
        }
        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, DebugCoreMessages.RuntimeProcess_Exit_value_not_available_until_process_terminates__1, null));
    }

    private class ProcessMonitorThread
    extends Thread {
        private volatile boolean fExit;

        @Override
        public void run() {
            Process fOSProcess = RuntimeProcess.this.getSystemProcess();
            if (!this.fExit && fOSProcess != null) {
                try {
                    try {
                        fOSProcess.waitFor();
                    }
                    catch (InterruptedException ie) {
                        Thread.interrupted();
                        RuntimeProcess.this.terminated();
                    }
                }
                finally {
                    RuntimeProcess.this.terminated();
                }
            }
        }

        private ProcessMonitorThread(String suffix) {
            super(DebugCoreMessages.ProcessMonitorJob_0 + suffix);
            this.setDaemon(true);
        }

        private void killThread() {
            this.fExit = true;
            this.interrupt();
        }
    }
}

