/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl.fix;

import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.vertx.core.dns.impl.fix.DnsNameResolver;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DnsNameResolverBuilder {
    private static final List<String> DEFAULT_SEACH_DOMAINS;
    private final EventLoop eventLoop;
    private ChannelFactory<? extends DatagramChannel> channelFactory;
    private InetSocketAddress localAddress = DnsNameResolver.ANY_LOCAL_ADDR;
    private DnsServerAddresses nameServerAddresses = DnsServerAddresses.defaultAddresses();
    private DnsCache resolveCache;
    private Integer minTtl;
    private Integer maxTtl;
    private Integer negativeTtl;
    private long queryTimeoutMillis = 5000L;
    private InternetProtocolFamily[] resolvedAddressTypes = DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES;
    private boolean recursionDesired = true;
    private int maxQueriesPerResolve = 16;
    private boolean traceEnabled;
    private int maxPayloadSize = 4096;
    private boolean optResourceEnabled = true;
    private HostsFileEntriesResolver hostsFileEntriesResolver = HostsFileEntriesResolver.DEFAULT;
    private List<String> searchDomains = DEFAULT_SEACH_DOMAINS;
    private int ndots = 1;

    public DnsNameResolverBuilder(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public DnsNameResolverBuilder() {
        this.eventLoop = null;
    }

    public DnsNameResolverBuilder channelFactory(ChannelFactory<? extends DatagramChannel> channelFactory) {
        this.channelFactory = channelFactory;
        return this;
    }

    public DnsNameResolverBuilder channelType(Class<? extends DatagramChannel> channelType) {
        return this.channelFactory((ChannelFactory<? extends DatagramChannel>)new ReflectiveChannelFactory(channelType));
    }

    public DnsNameResolverBuilder localAddress(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public DnsNameResolverBuilder nameServerAddresses(DnsServerAddresses nameServerAddresses) {
        this.nameServerAddresses = nameServerAddresses;
        return this;
    }

    public DnsNameResolverBuilder resolveCache(DnsCache resolveCache) {
        this.resolveCache = resolveCache;
        return this;
    }

    public DnsNameResolverBuilder ttl(int minTtl, int maxTtl) {
        this.maxTtl = maxTtl;
        this.minTtl = minTtl;
        return this;
    }

    public DnsNameResolverBuilder negativeTtl(int negativeTtl) {
        this.negativeTtl = negativeTtl;
        return this;
    }

    public DnsNameResolverBuilder queryTimeoutMillis(long queryTimeoutMillis) {
        this.queryTimeoutMillis = queryTimeoutMillis;
        return this;
    }

    public DnsNameResolverBuilder resolvedAddressTypes(InternetProtocolFamily ... resolvedAddressTypes) {
        ObjectUtil.checkNotNull((Object)resolvedAddressTypes, (String)"resolvedAddressTypes");
        ArrayList list = InternalThreadLocalMap.get().arrayList(InternetProtocolFamily.values().length);
        for (InternetProtocolFamily f : resolvedAddressTypes) {
            if (f == null) break;
            if (list.contains(f)) continue;
            list.add(f);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolvedAddressTypes = list.toArray(new InternetProtocolFamily[list.size()]);
        return this;
    }

    public DnsNameResolverBuilder resolvedAddressTypes(Iterable<InternetProtocolFamily> resolvedAddressTypes) {
        ObjectUtil.checkNotNull(resolvedAddressTypes, (String)"resolveAddressTypes");
        ArrayList list = InternalThreadLocalMap.get().arrayList(InternetProtocolFamily.values().length);
        for (InternetProtocolFamily f : resolvedAddressTypes) {
            if (f == null) break;
            if (list.contains(f)) continue;
            list.add(f);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolvedAddressTypes = list.toArray(new InternetProtocolFamily[list.size()]);
        return this;
    }

    public DnsNameResolverBuilder recursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this;
    }

    public DnsNameResolverBuilder maxQueriesPerResolve(int maxQueriesPerResolve) {
        this.maxQueriesPerResolve = maxQueriesPerResolve;
        return this;
    }

    public DnsNameResolverBuilder traceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this;
    }

    public DnsNameResolverBuilder maxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
        return this;
    }

    public DnsNameResolverBuilder optResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this;
    }

    public DnsNameResolverBuilder hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
        this.hostsFileEntriesResolver = hostsFileEntriesResolver;
        return this;
    }

    public List<String> searchDomains() {
        return this.searchDomains;
    }

    public DnsNameResolverBuilder searchDomains(List<String> searchDomains) {
        this.searchDomains = searchDomains;
        return this;
    }

    public int ndots() {
        return this.ndots;
    }

    public DnsNameResolverBuilder ndots(int ndots) {
        this.ndots = ndots;
        return this;
    }

    public DnsNameResolver build() {
        return this.build(this.eventLoop);
    }

    public DnsNameResolver build(EventLoop eventLoop) {
        if (this.resolveCache != null && (this.minTtl != null || this.maxTtl != null || this.negativeTtl != null)) {
            throw new IllegalStateException("resolveCache and TTLs are mutually exclusive");
        }
        DnsCache cache = this.resolveCache != null ? this.resolveCache : new DefaultDnsCache(ObjectUtil.intValue((Integer)this.minTtl, (int)0), ObjectUtil.intValue((Integer)this.maxTtl, (int)Integer.MAX_VALUE), ObjectUtil.intValue((Integer)this.negativeTtl, (int)0));
        return new DnsNameResolver(eventLoop, this.channelFactory, this.localAddress, this.nameServerAddresses, cache, this.queryTimeoutMillis, this.resolvedAddressTypes, this.recursionDesired, this.maxQueriesPerResolve, this.traceEnabled, this.maxPayloadSize, this.optResourceEnabled, this.hostsFileEntriesResolver, this.searchDomains, this.ndots);
    }

    static {
        ArrayList searchDomains = new ArrayList();
        try {
            Class<?> configClass = Class.forName("sun.net.dns.ResolverConfiguration");
            Method open = configClass.getMethod("open", new Class[0]);
            Method nameservers = configClass.getMethod("searchlist", new Class[0]);
            Object instance = open.invoke(null, new Object[0]);
            List list = (List)nameservers.invoke(instance, new Object[0]);
            searchDomains.addAll(list);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_SEACH_DOMAINS = Collections.unmodifiableList(searchDomains);
    }
}

