/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableFloatObjectMapFactory;
import org.eclipse.collections.api.map.primitive.FloatObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatObjectMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatObjectSingletonMap;

public enum ImmutableFloatObjectMapFactoryImpl implements ImmutableFloatObjectMapFactory
{
    INSTANCE;


    @Override
    public <V> ImmutableFloatObjectMap<V> empty() {
        return ImmutableFloatObjectEmptyMap.INSTANCE;
    }

    @Override
    public <V> ImmutableFloatObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> ImmutableFloatObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> ImmutableFloatObjectMap<V> of(float key, V value) {
        return this.with(key, value);
    }

    @Override
    public <V> ImmutableFloatObjectMap<V> with(float key, V value) {
        return new ImmutableFloatObjectSingletonMap<V>(key, value);
    }

    @Override
    public <V> ImmutableFloatObjectMap<V> ofAll(FloatObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    @Override
    public <V> ImmutableFloatObjectMap<V> withAll(FloatObjectMap<? extends V> map) {
        if (map instanceof ImmutableFloatObjectMap) {
            return (ImmutableFloatObjectMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            float[] array = new float[1];
            map.forEachKey(each -> {
                array[0] = each;
            });
            return new ImmutableFloatObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableFloatObjectHashMap<V>(map);
    }
}

