/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.view;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.SpaceTreeLayoutAlgorithm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.viatra.addon.viewers.runtime.model.ViatraViewerDataModel;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.zest.ViatraGraphViewers;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.presentation.CyberPhysicalSystemEditor;
import org.eclipse.viatra.integration.zest.viewer.ModifiableZestContentViewer;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.ViatraQueryRuntimeException;

public abstract class AbstractCpsViewPart
extends ViewPart
implements IPartListener2 {
    private ModifiableZestContentViewer viewer;
    private ViatraQueryEngine engine = null;
    protected IEditorPart activeEditor;

    public AbstractCpsViewPart() {
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        workbenchPage.addPartListener((IPartListener2)this);
    }

    protected ViatraQueryEngine getEngine() {
        return this.engine;
    }

    protected abstract Collection<IQuerySpecification<?>> getSpecifications();

    public void createPartControl(Composite parent) {
        this.viewer = new ModifiableZestContentViewer();
        this.viewer.createControl(parent, 2048);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected void engineUpdated() {
        try {
            ViewerState state = ViatraViewerDataModel.newViewerState((ViatraQueryEngine)this.getEngine(), this.getSpecifications(), (ViewerDataFilter)ViewerDataFilter.UNFILTERED, (Collection)ImmutableSet.of((Object)ViewerState.ViewerStateFeature.EDGE, (Object)ViewerState.ViewerStateFeature.CONTAINMENT));
            ViatraGraphViewers.bind((ModifiableZestContentViewer)this.viewer, (ViewerState)state, (boolean)true);
            this.viewer.setLayoutAlgorithm(this.getLayout());
        }
        catch (ViatraQueryRuntimeException e) {
            e.printStackTrace();
        }
    }

    protected ILayoutAlgorithm getLayout() {
        return new SpaceTreeLayoutAlgorithm();
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.activeEditor instanceof CyberPhysicalSystemEditor) {
            CyberPhysicalSystemEditor edp = (CyberPhysicalSystemEditor)this.activeEditor;
            ResourceSet resourceSet = edp.getEditingDomain().getResourceSet();
            if (this.engine != null && resourceSet == this.engine.getScope()) {
                return;
            }
            try {
                this.engine = ViatraQueryEngine.on((QueryScope)new EMFScope((Notifier)resourceSet));
            }
            catch (ViatraQueryRuntimeException e) {
                e.printStackTrace();
            }
            this.engineUpdated();
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

