/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.MappedTransitionMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.MappedTransitionSourceTargetMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.MonitoredTransitionMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.AbstractRule;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TransitionUpdate
extends AbstractRule<MonitoredTransitionMatch> {
    public TransitionUpdate(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public RuleSpecification<MonitoredTransitionMatch> getSpecification() {
        Job<MonitoredTransitionMatch> _appearedJob = this.getAppearedJob();
        Job<MonitoredTransitionMatch> _disappearedJob = this.getDisappearedJob();
        Job<MonitoredTransitionMatch> _updatedJob = this.getUpdatedJob();
        return Rules.newMatcherRuleSpecification((IQuerySpecification)this.cpsXformM2M.getMonitoredTransition(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _disappearedJob, _updatedJob})));
    }

    private Job<MonitoredTransitionMatch> getAppearedJob() {
        IMatchProcessor _function = match -> {
            String trId = match.getTransition().getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Starting monitoring mapped transition with ID: ");
            _builder.append(trId);
            this.logger.debug((Object)_builder);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<MonitoredTransitionMatch> getDisappearedJob() {
        IMatchProcessor _function = match -> {
            String trId = match.getTransition().getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Stopped monitoring mapped transition with ID: ");
            _builder.append(trId);
            this.logger.debug((Object)_builder);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }

    private Job<MonitoredTransitionMatch> getUpdatedJob() {
        IMatchProcessor _function = match -> {
            Transition transition = match.getTransition();
            String trId = transition.getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Updating mapped transition with ID: ");
            _builder.append(trId);
            this.logger.debug((Object)_builder);
            Collection<MappedTransitionMatch> depTransitionMatches = this.cpsXformM2M.getMappedTransition(this.engine).getAllMatches(transition, null, null);
            Consumer<MappedTransitionMatch> _function_1 = it -> {
                Collection<MappedTransitionSourceTargetMatch> matches;
                boolean _isEmpty;
                boolean _not;
                boolean _notEquals;
                String oldDesc = it.getDepTransition().getDescription();
                boolean bl = _notEquals = !Objects.equal((Object)oldDesc, (Object)trId);
                if (_notEquals) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("ID changed to ");
                    _builder_1.append(oldDesc);
                    this.logger.trace((Object)_builder_1);
                    BehaviorTransition _depTransition = it.getDepTransition();
                    _depTransition.setDescription(trId);
                }
                boolean bl2 = _not = !(_isEmpty = (matches = this.cpsXformM2M.getMappedTransitionSourceTarget(this.engine).getAllMatches(transition, null, null, it.getDepBehavior())).isEmpty());
                if (_not) {
                    boolean _notEquals_1;
                    boolean _not_1;
                    MappedTransitionSourceTargetMatch sourceTargetMatch = (MappedTransitionSourceTargetMatch)((Object)((Object)((Object)IterableExtensions.head(matches))));
                    BehaviorState newSource = sourceTargetMatch.getDepSource();
                    boolean _contains = newSource.getOutgoing().contains((Object)it.getDepTransition());
                    boolean bl3 = _not_1 = !_contains;
                    if (_not_1) {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("Source state changed to ");
                        String _description = newSource.getDescription();
                        _builder_2.append(_description);
                        this.logger.trace((Object)_builder_2);
                        EList _outgoing = newSource.getOutgoing();
                        BehaviorTransition _depTransition_1 = it.getDepTransition();
                        _outgoing.add((Object)_depTransition_1);
                    }
                    BehaviorState newTarget = sourceTargetMatch.getDepTarget();
                    BehaviorState _to = it.getDepTransition().getTo();
                    boolean bl4 = _notEquals_1 = !Objects.equal((Object)_to, (Object)newTarget);
                    if (_notEquals_1) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("Target state changed to ");
                        String _description_1 = newTarget.getDescription();
                        _builder_3.append(_description_1);
                        this.logger.trace((Object)_builder_3);
                        BehaviorTransition _depTransition_2 = it.getDepTransition();
                        _depTransition_2.setTo(newTarget);
                    }
                }
            };
            depTransitionMatches.forEach(_function_1);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Updated mapped transition with ID: ");
            _builder_1.append(trId);
            this.logger.debug((Object)_builder_1);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }
}

