/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.dred;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.dred.DRedTcRelation;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.DFSPathFinder;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.IGraphPathFinder;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.Tuple;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.dfs.DFSAlg;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcObserver;

public class DRedAlg<V>
implements IGraphObserver<V>,
ITcDataSource<V> {
    private IGraphDataSource<V> graphDataSource = null;
    private DRedTcRelation<V> tc = null;
    private DRedTcRelation<V> dtc = null;
    private List<ITcObserver<V>> observers;

    public DRedAlg(IGraphDataSource<V> gds) {
        this.observers = new ArrayList<ITcObserver<V>>();
        this.graphDataSource = gds;
        this.tc = new DRedTcRelation();
        this.dtc = new DRedTcRelation();
        this.initTc();
        this.graphDataSource.attachObserver(this);
    }

    public DRedAlg(IGraphDataSource<V> gds, DRedTcRelation<V> tc) {
        this.graphDataSource = gds;
        this.tc = tc;
        this.dtc = new DRedTcRelation();
        this.graphDataSource.attachObserver(this);
    }

    private void initTc() {
        DFSAlg<V> dfsa = new DFSAlg<V>(this.graphDataSource);
        this.setTcRelation(dfsa.getTcRelation());
        this.graphDataSource.detachObserver(dfsa);
    }

    @Override
    public void edgeInserted(V source, V target) {
        if (!source.equals(target)) {
            Set<V> tupStarts = null;
            Set<V> tupEnds = null;
            HashSet<Tuple<V>> tuples = new HashSet<Tuple<V>>();
            if (!source.equals(target) && this.tc.addTuple(source, target)) {
                tuples.add(new Tuple<V>(source, target));
            }
            tupStarts = this.tc.getTupleStarts(source);
            tupEnds = this.tc.getTupleEnds(target);
            for (V s : tupStarts) {
                for (V t : tupEnds) {
                    if (s.equals(t) || !this.tc.addTuple(s, t)) continue;
                    tuples.add(new Tuple<V>(s, t));
                }
            }
            for (V s : tupStarts) {
                if (s.equals(target) || !this.tc.addTuple(s, target)) continue;
                tuples.add(new Tuple<V>(s, target));
            }
            for (V t : tupEnds) {
                if (source.equals(t) || !this.tc.addTuple(source, t)) continue;
                tuples.add(new Tuple<V>(source, t));
            }
            this.notifyTcObservers(tuples, 1);
        }
    }

    @Override
    public void edgeDeleted(V source, V target) {
        if (!source.equals(target)) {
            HashMap<Tuple<V>, Integer> tuples = new HashMap<Tuple<V>, Integer>();
            Set<V> sources = this.tc.getTupleStarts(source);
            Set<V> targets = this.tc.getTupleEnds(target);
            this.tc.removeTuple(source, target);
            tuples.put(new Tuple<V>(source, target), -1);
            for (V s : sources) {
                for (V t : targets) {
                    if (s.equals(t)) continue;
                    this.tc.removeTuple(s, t);
                    tuples.put(new Tuple<V>(s, t), -1);
                }
            }
            for (V s : sources) {
                if (s.equals(target)) continue;
                this.tc.removeTuple(s, target);
                tuples.put(new Tuple<V>(s, target), -1);
            }
            for (V t : targets) {
                if (source.equals(t)) continue;
                this.tc.removeTuple(source, t);
                tuples.put(new Tuple<V>(source, t), -1);
            }
            for (V s : this.graphDataSource.getAllNodes()) {
                Map<V, Integer> targetNodes = this.graphDataSource.getTargetNodes(s);
                for (Map.Entry<V, Integer> entry : targetNodes.entrySet()) {
                    int i = 0;
                    while (i < entry.getValue()) {
                        V t = entry.getKey();
                        if (!s.equals(t)) {
                            this.tc.addTuple(s, t);
                            Tuple<V> tuple = new Tuple<V>(s, t);
                            Integer count = (Integer)tuples.get(tuple);
                            if (count != null && count == -1) {
                                tuples.remove(tuple);
                            }
                        }
                        ++i;
                    }
                }
            }
            DRedTcRelation newTups = new DRedTcRelation();
            this.dtc.clear();
            this.dtc.union(this.tc);
            while (!this.dtc.isEmpty()) {
                newTups.clear();
                newTups.union(this.dtc);
                this.dtc.clear();
                for (Object s : newTups.getTupleStarts()) {
                    for (Object t : newTups.getTupleEnds(s)) {
                        Map<Object, Integer> targetNodes = this.graphDataSource.getTargetNodes(t);
                        if (targetNodes == null) continue;
                        for (Map.Entry<Object, Integer> entry : targetNodes.entrySet()) {
                            int i = 0;
                            while (i < entry.getValue()) {
                                Object tn = entry.getKey();
                                if (!s.equals(tn) && this.tc.addTuple(s, tn)) {
                                    this.dtc.addTuple(s, tn);
                                    tuples.remove(new Tuple<Object>(s, tn));
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
            this.notifyTcObservers(tuples.keySet(), -1);
        }
    }

    @Override
    public void nodeInserted(V n) {
    }

    @Override
    public void nodeDeleted(V n) {
        Set<V> set = this.tc.getTupleEnds(n);
        HashSet<V> modSet = null;
        modSet = new HashSet<V>(set);
        for (Object tn : modSet) {
            this.tc.removeTuple(n, tn);
        }
        set = this.tc.getTupleStarts(n);
        modSet = new HashSet<V>(set);
        for (Object sn : modSet) {
            this.tc.removeTuple(sn, n);
        }
    }

    public DRedTcRelation<V> getTcRelation() {
        return this.tc;
    }

    public void setTcRelation(DRedTcRelation<V> tc) {
        this.tc = tc;
    }

    @Override
    public boolean isReachable(V source, V target) {
        return this.tc.containsTuple(source, target);
    }

    @Override
    public void attachObserver(ITcObserver<V> to) {
        this.observers.add(to);
    }

    @Override
    public void detachObserver(ITcObserver<V> to) {
        this.observers.remove(to);
    }

    @Override
    public Set<V> getAllReachableTargets(V source) {
        return this.tc.getTupleEnds(source);
    }

    @Override
    public Set<V> getAllReachableSources(V target) {
        return this.tc.getTupleStarts(target);
    }

    protected void notifyTcObservers(Set<Tuple<V>> tuples, int dir) {
        for (ITcObserver<V> o : this.observers) {
            for (Tuple<V> t : tuples) {
                if (t.getSource().equals(t.getTarget())) continue;
                if (dir == 1) {
                    o.tupleInserted(t.getSource(), t.getTarget());
                }
                if (dir != -1) continue;
                o.tupleDeleted(t.getSource(), t.getTarget());
            }
        }
    }

    @Override
    public void dispose() {
        this.tc = null;
        this.dtc = null;
    }

    @Override
    public IGraphPathFinder<V> getPathFinder() {
        return new DFSPathFinder<V>(this.graphDataSource, this);
    }
}

