/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.api;

import java.util.Objects;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexFeatureFilter;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexResourceFilter;

public class BaseIndexOptions {
    protected static final IndexingLevel WILDCARD_MODE_DEFAULT = IndexingLevel.NONE;
    private static final boolean TRAVERSE_ONLY_WELLBEHAVING_DERIVED_FEATURES_DEFAULT = true;
    protected static final boolean DYNAMIC_EMF_MODE_DEFAULT = false;
    protected static final boolean DANGLING_FREE_ASSUMPTION_DEFAULT = true;
    protected static final boolean STRICT_NOTIFICATION_MODE_DEFAULT = true;
    protected boolean danglingFreeAssumption = true;
    protected boolean dynamicEMFMode = false;
    protected boolean traverseOnlyWellBehavingDerivedFeatures = true;
    protected IndexingLevel wildcardMode = WILDCARD_MODE_DEFAULT;
    protected IBaseIndexObjectFilter notifierFilterConfiguration;
    protected IBaseIndexResourceFilter resourceFilterConfiguration;
    protected IBaseIndexFeatureFilter featureFilterConfiguration;
    protected boolean strictNotificationMode = true;

    public BaseIndexOptions() {
    }

    public BaseIndexOptions(boolean dynamicEMFMode, IndexingLevel wildcardMode) {
        this.dynamicEMFMode = dynamicEMFMode;
        this.wildcardMode = wildcardMode;
    }

    public BaseIndexOptions withDynamicEMFMode(boolean dynamicEMFMode) {
        BaseIndexOptions result = this.copy();
        result.dynamicEMFMode = dynamicEMFMode;
        return result;
    }

    public BaseIndexOptions withDanglingFreeAssumption(boolean danglingFreeAssumption) {
        BaseIndexOptions result = this.copy();
        result.danglingFreeAssumption = danglingFreeAssumption;
        return result;
    }

    public BaseIndexOptions withObjectFilterConfiguration(IBaseIndexObjectFilter filter) {
        BaseIndexOptions result = this.copy();
        result.notifierFilterConfiguration = filter;
        return result;
    }

    public IBaseIndexObjectFilter getObjectFilterConfiguration() {
        return this.notifierFilterConfiguration;
    }

    public BaseIndexOptions withResourceFilterConfiguration(IBaseIndexResourceFilter filter) {
        BaseIndexOptions result = this.copy();
        result.resourceFilterConfiguration = filter;
        return result;
    }

    public IBaseIndexResourceFilter getResourceFilterConfiguration() {
        return this.resourceFilterConfiguration;
    }

    public BaseIndexOptions withFeatureFilterConfiguration(IBaseIndexFeatureFilter filter) {
        BaseIndexOptions result = this.copy();
        result.featureFilterConfiguration = filter;
        return result;
    }

    public IBaseIndexFeatureFilter getFeatureFilterConfiguration() {
        return this.featureFilterConfiguration;
    }

    public boolean isDynamicEMFMode() {
        return this.dynamicEMFMode;
    }

    public boolean isDanglingFreeAssumption() {
        return this.danglingFreeAssumption;
    }

    public boolean isTraverseOnlyWellBehavingDerivedFeatures() {
        return this.traverseOnlyWellBehavingDerivedFeatures;
    }

    public BaseIndexOptions withWildcardLevel(IndexingLevel wildcardLevel) {
        BaseIndexOptions result = this.copy();
        result.wildcardMode = wildcardLevel;
        return result;
    }

    public BaseIndexOptions withStrictNotificationMode(boolean strictNotificationMode) {
        BaseIndexOptions result = this.copy();
        result.strictNotificationMode = strictNotificationMode;
        return result;
    }

    public boolean isWildcardMode() {
        return this.wildcardMode == IndexingLevel.FULL;
    }

    public IndexingLevel getWildcardLevel() {
        return this.wildcardMode;
    }

    public boolean isStrictNotificationMode() {
        return this.strictNotificationMode;
    }

    public BaseIndexOptions copy() {
        BaseIndexOptions baseIndexOptions = new BaseIndexOptions(this.dynamicEMFMode, this.wildcardMode);
        baseIndexOptions.danglingFreeAssumption = this.danglingFreeAssumption;
        baseIndexOptions.traverseOnlyWellBehavingDerivedFeatures = this.traverseOnlyWellBehavingDerivedFeatures;
        baseIndexOptions.notifierFilterConfiguration = this.notifierFilterConfiguration;
        baseIndexOptions.resourceFilterConfiguration = this.resourceFilterConfiguration;
        baseIndexOptions.featureFilterConfiguration = this.featureFilterConfiguration;
        baseIndexOptions.strictNotificationMode = this.strictNotificationMode;
        return baseIndexOptions;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dynamicEMFMode, this.notifierFilterConfiguration, this.resourceFilterConfiguration, this.featureFilterConfiguration, this.traverseOnlyWellBehavingDerivedFeatures, this.wildcardMode, this.strictNotificationMode, this.danglingFreeAssumption});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseIndexOptions)) {
            return false;
        }
        BaseIndexOptions other = (BaseIndexOptions)obj;
        if (this.dynamicEMFMode != other.dynamicEMFMode) {
            return false;
        }
        if (this.danglingFreeAssumption != other.danglingFreeAssumption) {
            return false;
        }
        if (this.notifierFilterConfiguration == null ? other.notifierFilterConfiguration != null : !this.notifierFilterConfiguration.equals(other.notifierFilterConfiguration)) {
            return false;
        }
        if (this.resourceFilterConfiguration == null ? other.resourceFilterConfiguration != null : !this.resourceFilterConfiguration.equals(other.resourceFilterConfiguration)) {
            return false;
        }
        if (this.featureFilterConfiguration == null ? other.featureFilterConfiguration != null : !this.featureFilterConfiguration.equals(other.featureFilterConfiguration)) {
            return false;
        }
        if (this.traverseOnlyWellBehavingDerivedFeatures != other.traverseOnlyWellBehavingDerivedFeatures) {
            return false;
        }
        if (this.wildcardMode != other.wildcardMode) {
            return false;
        }
        return this.strictNotificationMode == other.strictNotificationMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        BaseIndexOptions.appendModifier(sb, this.dynamicEMFMode, false, "dynamicEMF");
        BaseIndexOptions.appendModifier(sb, (Object)this.wildcardMode, (Object)WILDCARD_MODE_DEFAULT, "wildcard");
        BaseIndexOptions.appendModifier(sb, this.danglingFreeAssumption, true, "danglingFreeAssumption");
        BaseIndexOptions.appendModifier(sb, this.traverseOnlyWellBehavingDerivedFeatures, true, "wellBehavingOnly");
        BaseIndexOptions.appendModifier(sb, this.strictNotificationMode, true, "strictNotificationMode");
        BaseIndexOptions.appendModifier(sb, this.notifierFilterConfiguration, null, "notifierFilter=");
        BaseIndexOptions.appendModifier(sb, this.resourceFilterConfiguration, null, "resourceFilter=");
        BaseIndexOptions.appendModifier(sb, this.featureFilterConfiguration, null, "featureFilterConfiguration=");
        String result = sb.toString();
        return result.isEmpty() ? "defaults" : result;
    }

    private static void appendModifier(StringBuilder sb, Object actualValue, Object expectedValue, String switchName) {
        if (!Objects.equals(expectedValue, actualValue)) {
            sb.append(Boolean.FALSE.equals(actualValue) ? (char)'-' : '+');
            sb.append(switchName);
            if (!(actualValue instanceof Boolean)) {
                sb.append(actualValue);
            }
        }
    }
}

