/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public abstract class ExtendBinaryTransitiveClosure
extends ExtendOperation
implements IPatternMatcherOperation {
    private final int seedPosition;
    private final CallInformation information;

    protected ExtendBinaryTransitiveClosure(CallInformation information, int seedPosition, int targetPosition) {
        super(targetPosition);
        this.information = information;
        this.seedPosition = seedPosition;
    }

    protected abstract Object[] calculateCallFrame(Object var1);

    protected abstract Object getTarget(Tuple var1);

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        IQueryResultProvider matcher = context.getMatcher(this.information.getReference());
        LinkedList<Object> seedsToEvaluate = new LinkedList<Object>();
        seedsToEvaluate.add(frame.get(this.seedPosition));
        HashSet seedsEvaluated = new HashSet();
        HashSet<Object> targetsFound = new HashSet<Object>();
        while (!seedsToEvaluate.isEmpty()) {
            Object currentValue = seedsToEvaluate.poll();
            seedsEvaluated.add(currentValue);
            Object[] mappedFrame = this.calculateCallFrame(currentValue);
            for (Tuple match : matcher.getAllMatches(mappedFrame)) {
                Object foundTarget = this.getTarget(match);
                targetsFound.add(foundTarget);
                if (seedsEvaluated.contains(foundTarget)) continue;
                seedsToEvaluate.add(foundTarget);
            }
        }
        this.it = targetsFound.iterator();
    }

    public String toString() {
        String c = this.information.toString();
        int p = c.indexOf(40);
        return "extend    find " + c.substring(0, p) + "+" + c.substring(p);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.seedPosition, this.position);
    }

    public static class Backward
    extends ExtendBinaryTransitiveClosure {
        private Object[] seedFrame = new Object[2];

        public Backward(CallInformation information, int sourcePosition, int targetPosition) {
            super(information, targetPosition, sourcePosition);
        }

        @Override
        protected Object[] calculateCallFrame(Object seed) {
            this.seedFrame[0] = null;
            this.seedFrame[1] = seed;
            return this.seedFrame;
        }

        @Override
        protected Object getTarget(Tuple frame) {
            return frame.get(0);
        }
    }

    public static class Forward
    extends ExtendBinaryTransitiveClosure {
        private Object[] seedFrame = new Object[2];

        public Forward(CallInformation information, int sourcePosition, int targetPosition) {
            super(information, sourcePosition, targetPosition);
        }

        @Override
        protected Object[] calculateCallFrame(Object seed) {
            this.seedFrame[0] = seed;
            this.seedFrame[1] = null;
            return this.seedFrame;
        }

        @Override
        protected Object getTarget(Tuple frame) {
            return frame.get(1);
        }
    }
}

