/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase.AbstractIteratingExtendOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;

public class IterateOverEDatatypeInstances
extends AbstractIteratingExtendOperation
implements IIteratingSearchOperation {
    private EDataType dataType;

    public IterateOverEDatatypeInstances(int position, EDataType dataType, EMFScope scope) {
        super(position, scope);
        this.dataType = dataType;
    }

    protected Stream<EAttribute> doGetEAttributes(EClass eclass, ISearchContext context) {
        Table cache = context.accessBackendLevelCache(this.getClass(), Table.class, HashBasedTable::create);
        if (!cache.contains((Object)this.dataType, (Object)eclass)) {
            EList eAllAttributes = eclass.getEAllAttributes();
            cache.put((Object)this.dataType, (Object)eclass, eAllAttributes.stream().filter(input -> Objects.equals(input.getEType(), this.dataType)).collect(Collectors.toSet()));
        }
        return ((Set)cache.get((Object)this.dataType, (Object)eclass)).stream();
    }

    public EDataType getDataType() {
        return this.dataType;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        this.it = this.getModelContents().filter(EObject.class::isInstance).map(EObject.class::cast).map(input -> this.doGetEAttributes(input.eClass(), context).map(attribute -> {
            if (attribute.isMany()) {
                return ((List)input.eGet((EStructuralFeature)attribute)).stream();
            }
            Object o = input.eGet((EStructuralFeature)attribute);
            return o == null ? Stream.empty() : Stream.of(o);
        })).flatMap(i -> i).flatMap(i -> i).iterator();
    }

    public String toString() {
        return "extend    " + this.dataType.getName() + "(-" + this.position + ") iterating";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Collections.singletonList(this.position);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return new EDataTypeInSlotsKey(this.dataType);
    }
}

