/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.job;

import java.util.Objects;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.Context;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;

public class StatelessJob<Match extends IPatternMatch>
extends Job<Match> {
    private IMatchProcessor<Match> matchProcessor;

    public IMatchProcessor<Match> getMatchProcessor() {
        return this.matchProcessor;
    }

    public StatelessJob(CRUDActivationStateEnum activationStateEnum, IMatchProcessor<Match> matchProcessor) {
        super(activationStateEnum);
        this.matchProcessor = Objects.requireNonNull(matchProcessor, "StatelessJob cannot be instantiated with null match processor");
    }

    @Override
    protected void execute(Activation<? extends Match> activation, Context context) {
        this.matchProcessor.process((IPatternMatch)activation.getAtom());
    }

    @Override
    protected void handleError(Activation<? extends Match> activation, Exception exception, Context context) {
        throw new IllegalStateException("Exception " + exception.getMessage() + " was thrown when executing " + activation + "! Stateless job doesn't handle errors!", exception);
    }
}

