/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineLifecycleListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineManager;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineOptions;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexResourceFilter;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.EngineError;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class ViatraQueryEngineContentProvider
implements ITreeContentProvider {
    protected AdapterFactoryContentProvider adapterFactoryContentProvider;
    @Accessors
    protected boolean traverseResources = true;
    @Accessors
    protected boolean traverseEObjects = true;
    private TreeViewer viewer;
    private List<EngineListener> listeners = new ArrayList<EngineListener>();

    public ViatraQueryEngineContentProvider() {
        AdapterFactoryContentProvider _adapterFactoryContentProvider;
        AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
        this.adapterFactoryContentProvider = _adapterFactoryContentProvider = new AdapterFactoryContentProvider(adapterFactory);
    }

    public Object[] getChildren(Object parentElement) {
        return (Object[])Conversions.unwrapArray(this.getChildrenInternal(parentElement), Object.class);
    }

    protected List<?> _getChildrenInternal(Object parentElement) {
        return IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)this.adapterFactoryContentProvider.getChildren(parentElement))));
    }

    protected List<?> _getChildrenInternal(EObject parentElement) {
        if (this.traverseEObjects) {
            return IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)this.adapterFactoryContentProvider.getChildren((Object)parentElement))));
        }
        return CollectionLiterals.emptyList();
    }

    protected List<?> _getChildrenInternal(Resource parentElement) {
        if (this.traverseResources) {
            return IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)this.adapterFactoryContentProvider.getChildren((Object)parentElement))));
        }
        return CollectionLiterals.emptyList();
    }

    protected List<?> _getChildrenInternal(ViatraQueryEngineManager parentElement) {
        return IterableExtensions.toList((Iterable)parentElement.getExistingQueryEngines());
    }

    protected List<?> _getChildrenInternal(AdvancedViatraQueryEngine parentElement) {
        ViatraQueryEngineOptions engineOptions = parentElement.getEngineOptions();
        QueryScope scope = parentElement.getScope();
        EngineListener _engineListener = new EngineListener(parentElement, this.viewer);
        this.listeners.add(_engineListener);
        if (scope instanceof EMFScope) {
            Set roots = ((EMFScope)scope).getScopeRoots();
            BaseIndexOptions options = ((EMFScope)scope).getOptions();
            return ImmutableList.builder().addAll((Iterable)roots).add((Object)engineOptions).add((Object)options).build();
        }
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{scope, engineOptions}));
    }

    protected List<?> _getChildrenInternal(BaseIndexOptions parentElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Dynamic EMF mode");
        boolean _isDynamicEMFMode = parentElement.isDynamicEMFMode();
        Pair _mappedTo = Pair.of((Object)_builder.toString(), (Object)_isDynamicEMFMode);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Wildcard mode");
        boolean _isWildcardMode = parentElement.isWildcardMode();
        Pair _mappedTo_1 = Pair.of((Object)_builder_1.toString(), (Object)_isWildcardMode);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("Traverse only well-behaving features");
        boolean _isTraverseOnlyWellBehavingDerivedFeatures = parentElement.isTraverseOnlyWellBehavingDerivedFeatures();
        Pair _mappedTo_2 = Pair.of((Object)_builder_2.toString(), (Object)_isTraverseOnlyWellBehavingDerivedFeatures);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("Resource filter");
        IBaseIndexResourceFilter _resourceFilterConfiguration = parentElement.getResourceFilterConfiguration();
        Pair _mappedTo_3 = Pair.of((Object)_builder_3.toString(), (Object)_resourceFilterConfiguration);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("Object filter");
        IBaseIndexObjectFilter _objectFilterConfiguration = parentElement.getObjectFilterConfiguration();
        Pair _mappedTo_4 = Pair.of((Object)_builder_4.toString(), (Object)_objectFilterConfiguration);
        List baseOptions = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4}));
        return baseOptions;
    }

    protected List<?> _getChildrenInternal(ViatraQueryEngineOptions parentElement) {
        return this.getChildrenInternal(parentElement.getEngineDefaultHints());
    }

    protected List<?> _getChildrenInternal(QueryEvaluationHint parentElement) {
        boolean _not;
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)parentElement.getQueryBackendFactory());
        boolean _isEmpty = parentElement.getBackendHintSettings().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            builder.add(parentElement.getBackendHintSettings().entrySet());
        } else {
            builder.add((Object)"No hints specified");
        }
        return builder.build();
    }

    protected List<?> _getChildrenInternal(ResourceSet parentElement) {
        return parentElement.getResources();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element) != null && !((List)Conversions.doWrapArray((Object)this.getChildren(element))).isEmpty();
    }

    public void dispose() {
        Consumer<EngineListener> _function = it -> it.dispose();
        this.listeners.forEach(_function);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
    }

    public List<?> getChildrenInternal(Object parentElement) {
        if (parentElement instanceof EObject) {
            return this._getChildrenInternal((EObject)parentElement);
        }
        if (parentElement instanceof Resource) {
            return this._getChildrenInternal((Resource)parentElement);
        }
        if (parentElement instanceof ResourceSet) {
            return this._getChildrenInternal((ResourceSet)parentElement);
        }
        if (parentElement instanceof AdvancedViatraQueryEngine) {
            return this._getChildrenInternal((AdvancedViatraQueryEngine)parentElement);
        }
        if (parentElement instanceof ViatraQueryEngineManager) {
            return this._getChildrenInternal((ViatraQueryEngineManager)parentElement);
        }
        if (parentElement instanceof ViatraQueryEngineOptions) {
            return this._getChildrenInternal((ViatraQueryEngineOptions)parentElement);
        }
        if (parentElement instanceof BaseIndexOptions) {
            return this._getChildrenInternal((BaseIndexOptions)parentElement);
        }
        if (parentElement instanceof QueryEvaluationHint) {
            return this._getChildrenInternal((QueryEvaluationHint)parentElement);
        }
        if (parentElement != null) {
            return this._getChildrenInternal(parentElement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(parentElement).toString());
    }

    @Pure
    public boolean isTraverseResources() {
        return this.traverseResources;
    }

    public void setTraverseResources(boolean traverseResources) {
        this.traverseResources = traverseResources;
    }

    @Pure
    public boolean isTraverseEObjects() {
        return this.traverseEObjects;
    }

    public void setTraverseEObjects(boolean traverseEObjects) {
        this.traverseEObjects = traverseEObjects;
    }

    private static class EngineListener
    implements ViatraQueryEngineLifecycleListener {
        private final TreeViewer viewer;
        private final AdvancedViatraQueryEngine engine;
        private boolean disposed = false;

        public EngineListener(AdvancedViatraQueryEngine engine, TreeViewer viewer) {
            this.viewer = viewer;
            this.engine = engine;
            engine.addLifecycleListener((ViatraQueryEngineLifecycleListener)this);
        }

        public void engineBecameTainted(String message, Throwable t) {
            Runnable _function = () -> {
                EngineError _engineError = new EngineError(message, t);
                this.viewer.add((Object)this.engine, (Object)_engineError);
            };
            this.viewer.getTree().getDisplay().asyncExec(_function);
        }

        public void engineDisposed() {
            this.disposed = true;
        }

        public void engineWiped() {
        }

        public void matcherInstantiated(ViatraQueryMatcher<? extends IPatternMatch> matcher) {
        }

        public boolean dispose() {
            boolean _xifexpression = false;
            if (this.disposed) {
                boolean _xblockexpression = false;
                this.engine.removeLifecycleListener((ViatraQueryEngineLifecycleListener)this);
                this.disposed = true;
                _xifexpression = _xblockexpression = true;
            }
            return _xifexpression;
        }
    }
}

