/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.views.transformationbrowser;

import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.transformation.debug.model.TransformationThread;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationState;
import org.eclipse.viatra.transformation.debug.ui.views.model.CompositeItem;
import org.eclipse.viatra.transformation.debug.ui.views.transformationbrowser.TransformationBrowserView;

public class ConflictSetContentProvider
implements ITreeContentProvider {
    private static final String NEXT_NAME = "Conflicting Activations";
    private static final String CONFLICTING_NAME = "Executable Activations";
    protected TransformationBrowserView view;

    public ConflictSetContentProvider(TransformationBrowserView view) {
        this.view = view;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        TransformationState transformationState;
        if (inputElement instanceof TransformationThread && (transformationState = ((TransformationThread)inputElement).getTransformationState()) != null) {
            return new TransformationState[]{((TransformationThread)inputElement).getTransformationState()};
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TransformationState) {
            List conflictingActivations = ((TransformationState)parentElement).getConflictingActivations();
            List nextActivations = ((TransformationState)parentElement).getNextActivations();
            CompositeItem nextContainer = new CompositeItem(NEXT_NAME, nextActivations.toArray());
            CompositeItem conflictingNode = new CompositeItem(CONFLICTING_NAME, conflictingActivations.toArray());
            Object[] retVal = new CompositeItem[]{nextContainer, conflictingNode};
            return retVal;
        }
        if (parentElement instanceof CompositeItem) {
            Object[] children = ((CompositeItem)parentElement).getChildren();
            return children;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TransformationState) {
            List conflictingActivations = ((TransformationState)element).getConflictingActivations();
            List nextActivations = ((TransformationState)element).getNextActivations();
            return nextActivations.size() > 0 || conflictingActivations.size() > 0;
        }
        if (element instanceof CompositeItem) {
            Object[] children = ((CompositeItem)element).getChildren();
            return children.length > 0;
        }
        return false;
    }
}

