/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.debug.variables;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.debug.common.VariablesFactory;
import org.eclipse.viatra.query.tooling.debug.common.ViatraQueryDebugVariable;
import org.eclipse.viatra.query.tooling.debug.variables.ValueWrapper;
import org.eclipse.viatra.query.tooling.debug.variables.values.EngineValue;

public class DebugVariablesFactory
extends VariablesFactory {
    @Override
    public List<IJavaVariable> getVariables(JDIStackFrame wrappedStackFrame, ThreadReference threadReference) {
        ArrayList<IJavaVariable> variables = new ArrayList<IJavaVariable>();
        try {
            VirtualMachine vm = this.getVirtualMachine(wrappedStackFrame);
            if (vm != null) {
                ArrayList<EngineValue> engines = new ArrayList<EngineValue>();
                for (ReferenceType rt : vm.allClasses()) {
                    List<ObjectReference> instances;
                    if (!rt.name().matches("org.eclipse.viatra.query.runtime.internal.apiimpl.ViatraQueryEngineImpl") || (instances = rt.instances(100L)).size() <= 0) continue;
                    for (ObjectReference instance : instances) {
                        EngineValue value = new EngineValue(wrappedStackFrame.getJavaDebugTarget(), ValueWrapper.wrap(instance, threadReference));
                        engines.add(value);
                    }
                }
                Collections.sort(engines);
                for (EngineValue ev : engines) {
                    ViatraQueryDebugVariable var = new ViatraQueryDebugVariable(wrappedStackFrame.getJavaDebugTarget());
                    var.setValue((IValue)ev);
                    variables.add((IJavaVariable)var);
                }
            }
        }
        catch (DebugException e) {
            ViatraQueryLoggingUtil.getLogger(DebugVariablesFactory.class).error((Object)"Couldn't retrieve the list of debug variables!", (Throwable)e);
        }
        return variables;
    }
}

