/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher.integration;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.DontFlattenDisjunctive;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.DontFlattenIncrementalPredicate;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.IAdornmentProvider;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LazyPlanningAdornments;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchEMFBackendFactory;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchGenericBackendFactory;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHintOptions;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.ICostFunction;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl.IndexerBasedConstraintCostFunction;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl.VariableBindingBasedCostFunction;
import org.eclipse.viatra.query.runtime.matchers.backend.CommonQueryHintOptions;
import org.eclipse.viatra.query.runtime.matchers.backend.ICallDelegationStrategy;
import org.eclipse.viatra.query.runtime.matchers.backend.IMatcherCapability;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryHintOption;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.DefaultFlattenCallPredicate;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IFlattenCallPredicate;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IRewriterTraceCollector;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.NeverFlattenCallPredicate;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.NopTraceCollector;

public final class LocalSearchHints
implements IMatcherCapability {
    private Boolean useBase = null;
    private Integer rowCount = null;
    private ICostFunction costFunction = null;
    private IFlattenCallPredicate flattenCallPredicate = null;
    private ICallDelegationStrategy callDelegationStrategy = null;
    private IAdornmentProvider adornmentProvider = null;
    private IRewriterTraceCollector traceCollector = NopTraceCollector.INSTANCE;
    private IQueryBackendFactory backendFactory = null;

    private LocalSearchHints() {
    }

    public static LocalSearchHints getDefaultOverriddenBy(QueryEvaluationHint overridingHint) {
        return LocalSearchHints.parse(LocalSearchHints.getDefault().build(overridingHint));
    }

    public static LocalSearchHints getDefault() {
        LocalSearchHints result = new LocalSearchHints();
        result.useBase = (Boolean)LocalSearchHintOptions.USE_BASE_INDEX.getDefaultValue();
        result.rowCount = (Integer)LocalSearchHintOptions.PLANNER_TABLE_ROW_COUNT.getDefaultValue();
        result.costFunction = (ICostFunction)LocalSearchHintOptions.PLANNER_COST_FUNCTION.getDefaultValue();
        result.flattenCallPredicate = (IFlattenCallPredicate)LocalSearchHintOptions.FLATTEN_CALL_PREDICATE.getDefaultValue();
        result.callDelegationStrategy = (ICallDelegationStrategy)LocalSearchHintOptions.CALL_DELEGATION_STRATEGY.getDefaultValue();
        result.adornmentProvider = (IAdornmentProvider)LocalSearchHintOptions.ADORNMENT_PROVIDER.getDefaultValue();
        result.backendFactory = LocalSearchEMFBackendFactory.INSTANCE;
        return result;
    }

    public static LocalSearchHints getDefaultFlatten() {
        LocalSearchHints result = new LocalSearchHints();
        result.useBase = true;
        result.rowCount = 4;
        result.costFunction = new IndexerBasedConstraintCostFunction();
        result.flattenCallPredicate = new DefaultFlattenCallPredicate();
        result.callDelegationStrategy = (ICallDelegationStrategy)LocalSearchHintOptions.CALL_DELEGATION_STRATEGY.getDefaultValue();
        result.adornmentProvider = (IAdornmentProvider)LocalSearchHintOptions.ADORNMENT_PROVIDER.getDefaultValue();
        result.backendFactory = LocalSearchEMFBackendFactory.INSTANCE;
        return result;
    }

    public static LocalSearchHints getDefaultNoBase() {
        LocalSearchHints result = new LocalSearchHints();
        result.useBase = false;
        result.rowCount = 4;
        result.costFunction = new VariableBindingBasedCostFunction();
        result.flattenCallPredicate = new NeverFlattenCallPredicate();
        result.callDelegationStrategy = ICallDelegationStrategy.FULL_BACKEND_ADHESION;
        result.adornmentProvider = (IAdornmentProvider)LocalSearchHintOptions.ADORNMENT_PROVIDER.getDefaultValue();
        result.backendFactory = LocalSearchEMFBackendFactory.INSTANCE;
        return result;
    }

    public static LocalSearchHints getDefaultGeneric() {
        LocalSearchHints result = new LocalSearchHints();
        result.useBase = true;
        result.rowCount = 4;
        result.costFunction = new IndexerBasedConstraintCostFunction(0.01);
        result.flattenCallPredicate = (IFlattenCallPredicate)LocalSearchHintOptions.FLATTEN_CALL_PREDICATE.getDefaultValue();
        result.callDelegationStrategy = ICallDelegationStrategy.FULL_BACKEND_ADHESION;
        result.adornmentProvider = new LazyPlanningAdornments();
        result.backendFactory = LocalSearchGenericBackendFactory.INSTANCE;
        return result;
    }

    public static LocalSearchHints getDefaultHybrid() {
        LocalSearchHints result = LocalSearchHints.getDefault();
        result.callDelegationStrategy = ICallDelegationStrategy.PARTIAL_BACKEND_ADHESION;
        result.flattenCallPredicate = new IFlattenCallPredicate.And(new IFlattenCallPredicate[]{new DontFlattenIncrementalPredicate(), new DontFlattenDisjunctive()});
        return result;
    }

    public static LocalSearchHints getDefaultGenericHybrid() {
        LocalSearchHints result = LocalSearchHints.getDefaultGeneric();
        result.callDelegationStrategy = ICallDelegationStrategy.PARTIAL_BACKEND_ADHESION;
        result.flattenCallPredicate = new IFlattenCallPredicate.And(new IFlattenCallPredicate[]{new DontFlattenIncrementalPredicate(), new DontFlattenDisjunctive()});
        return result;
    }

    public static LocalSearchHints parse(QueryEvaluationHint hint) {
        LocalSearchHints result = new LocalSearchHints();
        result.useBase = (Boolean)LocalSearchHintOptions.USE_BASE_INDEX.getValueOrNull(hint);
        result.rowCount = (Integer)LocalSearchHintOptions.PLANNER_TABLE_ROW_COUNT.getValueOrNull(hint);
        result.flattenCallPredicate = (IFlattenCallPredicate)LocalSearchHintOptions.FLATTEN_CALL_PREDICATE.getValueOrNull(hint);
        result.callDelegationStrategy = (ICallDelegationStrategy)LocalSearchHintOptions.CALL_DELEGATION_STRATEGY.getValueOrNull(hint);
        result.costFunction = (ICostFunction)LocalSearchHintOptions.PLANNER_COST_FUNCTION.getValueOrNull(hint);
        result.adornmentProvider = (IAdornmentProvider)LocalSearchHintOptions.ADORNMENT_PROVIDER.getValueOrNull(hint);
        result.traceCollector = (IRewriterTraceCollector)CommonQueryHintOptions.normalizationTraceCollector.getValueOrDefault(hint);
        return result;
    }

    private Map<QueryHintOption<?>, Object> calculateHintMap() {
        HashMap map = new HashMap();
        if (this.useBase != null) {
            LocalSearchHintOptions.USE_BASE_INDEX.insertOverridingValue(map, (Object)this.useBase);
        }
        if (this.rowCount != null) {
            LocalSearchHintOptions.PLANNER_TABLE_ROW_COUNT.insertOverridingValue(map, (Object)this.rowCount);
        }
        if (this.costFunction != null) {
            LocalSearchHintOptions.PLANNER_COST_FUNCTION.insertOverridingValue(map, (Object)this.costFunction);
        }
        if (this.flattenCallPredicate != null) {
            LocalSearchHintOptions.FLATTEN_CALL_PREDICATE.insertOverridingValue(map, (Object)this.flattenCallPredicate);
        }
        if (this.callDelegationStrategy != null) {
            LocalSearchHintOptions.CALL_DELEGATION_STRATEGY.insertOverridingValue(map, (Object)this.callDelegationStrategy);
        }
        if (this.adornmentProvider != null) {
            LocalSearchHintOptions.ADORNMENT_PROVIDER.insertOverridingValue(map, (Object)this.adornmentProvider);
        }
        if (this.traceCollector != null) {
            CommonQueryHintOptions.normalizationTraceCollector.insertOverridingValue(map, (Object)this.traceCollector);
        }
        return map;
    }

    public QueryEvaluationHint build() {
        Map<QueryHintOption<?>, Object> map = this.calculateHintMap();
        return new QueryEvaluationHint(map, this.backendFactory);
    }

    public QueryEvaluationHint build(QueryEvaluationHint overridingHint) {
        if (overridingHint == null) {
            return this.build();
        }
        IQueryBackendFactory factory = overridingHint.getQueryBackendFactory() == null ? this.backendFactory : overridingHint.getQueryBackendFactory();
        Map<QueryHintOption<?>, Object> hints = this.calculateHintMap();
        if (overridingHint.getBackendHintSettings() != null) {
            hints.putAll(overridingHint.getBackendHintSettings());
        }
        return new QueryEvaluationHint(hints, factory);
    }

    public boolean isUseBase() {
        return this.useBase;
    }

    public ICostFunction getCostFunction() {
        return this.costFunction;
    }

    public IFlattenCallPredicate getFlattenCallPredicate() {
        return this.flattenCallPredicate;
    }

    public ICallDelegationStrategy getCallDelegationStrategy() {
        return this.callDelegationStrategy;
    }

    public Integer getRowCount() {
        return this.rowCount;
    }

    public IAdornmentProvider getAdornmentProvider() {
        return this.adornmentProvider;
    }

    public IRewriterTraceCollector getTraceCollector() {
        return this.traceCollector == null ? (IRewriterTraceCollector)CommonQueryHintOptions.normalizationTraceCollector.getDefaultValue() : this.traceCollector;
    }

    public LocalSearchHints setUseBase(boolean useBase) {
        this.useBase = useBase;
        return this;
    }

    public LocalSearchHints setRowCount(int rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    public LocalSearchHints setCostFunction(ICostFunction costFunction) {
        this.costFunction = costFunction;
        return this;
    }

    public LocalSearchHints setFlattenCallPredicate(IFlattenCallPredicate flattenCallPredicate) {
        this.flattenCallPredicate = flattenCallPredicate;
        return this;
    }

    public LocalSearchHints setCallDelegationStrategy(ICallDelegationStrategy callDelegationStrategy) {
        this.callDelegationStrategy = callDelegationStrategy;
        return this;
    }

    public LocalSearchHints setTraceCollector(IRewriterTraceCollector traceCollector) {
        this.traceCollector = traceCollector;
        return this;
    }

    public LocalSearchHints setAdornmentProvider(IAdornmentProvider adornmentProvider) {
        this.adornmentProvider = adornmentProvider;
        return this;
    }

    public static LocalSearchHints customizeUseBase(boolean useBase) {
        return new LocalSearchHints().setUseBase(useBase);
    }

    public static LocalSearchHints customizeRowCount(int rowCount) {
        return new LocalSearchHints().setRowCount(rowCount);
    }

    public static LocalSearchHints customizeCostFunction(ICostFunction costFunction) {
        return new LocalSearchHints().setCostFunction(costFunction);
    }

    public static LocalSearchHints customizeFlattenCallPredicate(IFlattenCallPredicate predicate) {
        return new LocalSearchHints().setFlattenCallPredicate(predicate);
    }

    public static LocalSearchHints customizeCallDelegationStrategy(ICallDelegationStrategy strategy) {
        return new LocalSearchHints().setCallDelegationStrategy(strategy);
    }

    public static LocalSearchHints customizeAdornmentProvider(IAdornmentProvider adornmentProvider) {
        return new LocalSearchHints().setAdornmentProvider(adornmentProvider);
    }

    public static LocalSearchHints customizeTraceCollector(IRewriterTraceCollector traceCollector) {
        return new LocalSearchHints().setTraceCollector(traceCollector);
    }

    public boolean canBeSubstitute(IMatcherCapability capability) {
        if (capability instanceof LocalSearchHints) {
            LocalSearchHints other = (LocalSearchHints)capability;
            return Objects.equals(other.useBase, this.useBase);
        }
        return false;
    }
}

