/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.runtime.ui.handlers;

import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.addon.validation.runtime.ui.ValidationInitUtil;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.ui.modelconnector.AdapterUtil;
import org.eclipse.viatra.query.runtime.ui.modelconnector.IModelConnector;

public class InitValidatorsForEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Optional optionalConnector = AdapterUtil.getModelConnectorFromIEditorPartChecked((IEditorPart)editorPart);
        if (optionalConnector.isPresent()) {
            ResourceSet resourceSet = (ResourceSet)((IModelConnector)optionalConnector.get()).getNotifier(IModelConnectorTypeEnum.RESOURCESET);
            if (resourceSet != null) {
                ValidationInitUtil.initializeAdapters(editorPart, (Notifier)resourceSet);
            }
        } else {
            MessageDialog.openError((Shell)HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getShell(), (String)"No Model Connector", (String)String.format("No model connector registered for editor %s", editorPart.getTitle()));
        }
        return null;
    }
}

